/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eu.smileyik.luajava.CPtr;
import org.eu.smileyik.luajava.JavaFunction;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFactory;
import org.eu.smileyik.luajava.debug.LuaDebug;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.IInnerLuaObject;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.util.ParamRef;

public class LuaStateFacade
implements AutoCloseable {
    private final Lock lock = new ReentrantLock();
    private final int stateId;
    private final LuaState luaState;
    private final boolean ignoreNotPublic;
    private boolean justUseFirstMethod;
    private BiConsumer<LuaStateFacade, LuaDebug> debugHook = null;
    private Function<Throwable, Throwable> throwableHook = null;

    protected LuaStateFacade(int stateId, boolean ignoreNotPublic) {
        this.stateId = stateId;
        this.luaState = new LuaState(stateId);
        this.ignoreNotPublic = ignoreNotPublic;
    }

    protected LuaStateFacade(CPtr cPtr) {
        ParamRef<LuaStateFacade> existLuaState = ParamRef.wrapper();
        this.stateId = LuaStateFactory.insertLuaState(this, cPtr, existLuaState);
        this.luaState = existLuaState.isEmpty() ? new LuaState(cPtr, this.stateId) : existLuaState.getParamAndClear().luaState;
        this.ignoreNotPublic = existLuaState.isEmpty() || existLuaState.getParamAndClear().ignoreNotPublic;
    }

    public long getCPtrPeer() {
        return this.luaState.getCPtrPeer();
    }

    public boolean isIgnoreNotPublic() {
        return this.ignoreNotPublic;
    }

    public boolean isJustUseFirstMethod() {
        return this.justUseFirstMethod;
    }

    public void setJustUseFirstMethod(boolean justUseFirstMethod) {
        this.justUseFirstMethod = justUseFirstMethod;
    }

    public void setDebugHook(BiConsumer<LuaStateFacade, LuaDebug> debugHook) {
        this.lock((LuaState it) -> {
            this.debugHook = debugHook;
        });
    }

    protected void debugHook(LuaDebug ar) {
        if (this.debugHook != null) {
            this.debugHook.accept(this, ar);
        }
    }

    public void setThrowableHook(Function<Throwable, Throwable> throwableHook) {
        this.throwableHook = throwableHook;
    }

    protected Throwable throwsByC(Throwable throwable) {
        if (this.throwableHook != null) {
            return this.throwableHook.apply(throwable);
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Result<T, ? extends Exception> lockThrowAll(LuaStateDangerFunction<T> function) {
        this.lock.lock();
        try {
            Result result = Result.success(function.apply(this.luaState));
            return result;
        }
        catch (Exception e) {
            Result result = Result.failure(e);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Result<T, ? extends LuaException> lockThrow(LuaStateFunction<T> function) {
        this.lock.lock();
        try {
            Result result = Result.success(function.apply(this.luaState));
            return result;
        }
        catch (LuaException e) {
            Result result = Result.failure(e);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> T lock(LuaStateSafeFunction<T> function) {
        this.lock.lock();
        try {
            T t = function.apply(this.luaState);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<?, ? extends Exception> lockThrowAll(LuaStateDangerConsumer consumer) {
        this.lock.lock();
        try {
            consumer.accept(this.luaState);
            Result result = Result.success();
            return result;
        }
        catch (Exception e) {
            Result result = Result.failure(e);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<?, ? extends LuaException> lockThrow(LuaStateConsumer consumer) {
        this.lock.lock();
        try {
            consumer.accept(this.luaState);
            Result result = Result.success();
            return result;
        }
        catch (LuaException e) {
            Result result = Result.failure(e);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock(LuaStateSafeConsumer consumer) {
        this.lock.lock();
        try {
            consumer.accept(this.luaState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Result<Integer, LuaException> evalString(String str) {
        return this.lock((LuaState l) -> {
            int exp = l.LdoString(str);
            if (exp != 0) {
                String err = this.getErrorMessage(exp);
                return Result.failure(new LuaException(err), err);
            }
            return Result.success(exp);
        });
    }

    public Result<Integer, LuaException> evalFile(String filename) {
        return this.lock((LuaState l) -> {
            int exp = l.LdoFile(filename);
            if (exp != 0) {
                String err = this.getErrorMessage(exp);
                return Result.failure(new LuaException(err), err);
            }
            return Result.success(exp);
        });
    }

    public Result<Integer, LuaException> loadString(String str) {
        return this.lock((LuaState l) -> {
            int exp = l.LloadString(str);
            if (exp != 0) {
                String err = this.getErrorMessage(exp);
                return Result.failure(new LuaException(err), err);
            }
            return Result.success(exp);
        });
    }

    public Result<Integer, LuaException> loadFile(String filename) {
        return this.lock((LuaState l) -> {
            int exp = l.LloadFile(filename);
            if (exp != 0) {
                String err = this.getErrorMessage(exp);
                return Result.failure(new LuaException(err), err);
            }
            return Result.success(exp);
        });
    }

    public Result<Integer, LuaException> load(byte[] buffer, String name) {
        return this.lock((LuaState l) -> {
            int exp = l.LloadBuffer(buffer, name);
            if (exp != 0) {
                String err = this.getErrorMessage(exp);
                return Result.failure(new LuaException(err), err);
            }
            return Result.success(exp);
        });
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public Lock getLock() {
        return this.lock;
    }

    public LuaState getLuaState() {
        return this.luaState;
    }

    public int getStateId() {
        return this.stateId;
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            LuaStateFactory.removeLuaState(this.stateId);
            if (this.luaState != null && !this.luaState.isClosed()) {
                this.luaState.clearRef();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isClosed() {
        return this.luaState.isClosed();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LuaStateFacade facade = (LuaStateFacade)object;
        return this.stateId == facade.stateId && Objects.equals(this.luaState, facade.luaState);
    }

    public int hashCode() {
        return Objects.hash(this.stateId, this.luaState);
    }

    protected String getErrorMessage(int err) {
        String ret = null;
        switch (err) {
            case 2: {
                ret = "Runtime error. ";
                break;
            }
            case 4: {
                ret = "Memory allocation error. ";
                break;
            }
            case 5: {
                ret = "Error while running the error handler function.";
                break;
            }
        }
        if (this.luaState.isString(-1)) {
            try {
                ret = ret == null ? this.luaState.toString(-1) : ret + this.luaState.toString(-1);
            }
            finally {
                this.luaState.pop(1);
            }
        }
        return ret;
    }

    public Result<LuaObject, ? extends LuaException> getLuaObject(LuaObject parent, String name) {
        if (parent.luaState.getCPtrPeer() != this.luaState.getCPtrPeer()) {
            return Result.failure(new LuaException("Object must have the same LuaState as the parent!"));
        }
        return LuaObject.create(parent, name);
    }

    public Result<LuaObject, ? extends LuaException> getLuaObject(String globalName) {
        return LuaObject.create(this, globalName);
    }

    public Result<LuaObject, ? extends LuaException> getLuaObject(LuaObject parent, Number name) {
        if (parent.luaState.getCPtrPeer() != this.luaState.getCPtrPeer()) {
            return Result.failure(new LuaException("Object must have the same LuaState as the parent!"));
        }
        return LuaObject.create(parent, name);
    }

    public Result<LuaObject, ? extends LuaException> getLuaObject(LuaObject parent, LuaObject name) {
        if (parent.getLuaState().getCPtrPeer() != this.luaState.getCPtrPeer() || parent.getLuaState().getCPtrPeer() != name.getLuaState().getCPtrPeer()) {
            return Result.failure(new LuaException("Object must have the same LuaState as the parent!"));
        }
        return LuaObject.create(parent, name);
    }

    public Result<LuaObject, ? extends LuaException> getLuaObject(int index) {
        return LuaObject.create(this, index);
    }

    public Result<LuaObject, ? extends LuaException> rawGetLuaObject(int index) {
        return LuaObject.rawCreate(this, index);
    }

    public Result<Object, ? extends LuaException> toJavaObject(int idx) {
        this.lock.lock();
        try {
            Result<Object, ? extends LuaException> result = this.rawToJavaObject(idx);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Result<Object, ? extends LuaException> rawToJavaObject(int idx) {
        int type = this.luaState.type(idx);
        switch (type) {
            case 1: {
                return Result.success(this.luaState.toBoolean(idx));
            }
            case 4: {
                return Result.success(this.luaState.toString(idx));
            }
            case 5: 
            case 6: {
                return this.rawGetLuaObject(idx).justCast();
            }
            case 3: {
                return Result.success(this.luaState.toNumber(idx));
            }
            case 7: {
                try {
                    if (this.luaState.isObject(idx)) {
                        return Result.success(this.luaState.getObjectFromUserdata(idx));
                    }
                    return this.getLuaObject(idx).justCast();
                }
                catch (LuaException e) {
                    return Result.failure(e);
                }
            }
        }
        return Result.success(null);
    }

    public Result<Void, ? extends LuaException> pushObjectValue(Object obj) {
        this.lock.lock();
        try {
            Result<Void, ? extends LuaException> result = this.rawPushObjectValue(obj);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Result<Void, ? extends LuaException> rawPushObjectValue(Object obj) {
        if (obj == null) {
            this.luaState.pushNil();
        } else if (obj instanceof Boolean) {
            this.luaState.pushBoolean((Boolean)obj);
        } else if (obj instanceof Number) {
            this.luaState.pushNumber(((Number)obj).doubleValue());
        } else if (obj instanceof String) {
            this.luaState.pushString((String)obj);
        } else if (obj instanceof JavaFunction) {
            try {
                this.luaState.pushJavaFunction((JavaFunction)obj);
            }
            catch (LuaException e) {
                return Result.failure(e);
            }
        } else if (obj instanceof LuaObject) {
            ((LuaObject)obj).rawPush();
        } else if (obj instanceof byte[]) {
            this.luaState.pushString((byte[])obj);
        } else if (obj.getClass().isArray()) {
            try {
                this.luaState.pushJavaArray(obj);
            }
            catch (LuaException e) {
                return Result.failure(e);
            }
        } else if (obj instanceof Class) {
            this.luaState.pushJavaClass((Class)obj);
        } else {
            this.luaState.pushJavaObject(obj);
        }
        return Result.success();
    }

    public LuaStateFacade newThread() {
        this.lock.lock();
        try {
            LuaStateFacade luaStateFacade = new LuaStateFacade(this.luaState.newThread());
            return luaStateFacade;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getTop() {
        return this.lock(LuaState::getTop);
    }

    public void setTop(int idx) {
        this.lock((LuaState l) -> l.setTop(idx));
    }

    public void pushValue(int idx) {
        this.lock((LuaState l) -> l.pushValue(idx));
    }

    public void remove(int idx) {
        this.lock((LuaState l) -> l.remove(idx));
    }

    public void insert(int idx) {
        this.lock((LuaState l) -> l.insert(idx));
    }

    public void replace(int idx) {
        this.lock((LuaState l) -> l.replace(idx));
    }

    public int checkStack(int sz) {
        return this.lock((LuaState l) -> l.checkStack(sz));
    }

    public void xmove(LuaStateFacade to, int n) {
        this.lock.lock();
        try {
            this.luaState.xmove(to.luaState, n);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isNumber(int idx) {
        return this.lock((LuaState l) -> l.isNumber(idx));
    }

    public boolean isString(int idx) {
        return this.lock((LuaState l) -> l.isString(idx));
    }

    public boolean isFunction(int idx) {
        return this.lock((LuaState l) -> l.isFunction(idx));
    }

    public boolean isCFunction(int idx) {
        return this.lock((LuaState l) -> l.isCFunction(idx));
    }

    public boolean isUserdata(int idx) {
        return this.lock((LuaState l) -> l.isUserdata(idx));
    }

    public boolean isTable(int idx) {
        return this.lock((LuaState l) -> l.isTable(idx));
    }

    public boolean isBoolean(int idx) {
        return this.lock((LuaState l) -> l.isBoolean(idx));
    }

    public boolean isNil(int idx) {
        return this.lock((LuaState l) -> l.isNil(idx));
    }

    public boolean isThread(int idx) {
        return this.lock((LuaState l) -> l.isThread(idx));
    }

    public boolean isNone(int idx) {
        return this.lock((LuaState l) -> l.isNone(idx));
    }

    public boolean isNoneOrNil(int idx) {
        return this.lock((LuaState l) -> l.isNoneOrNil(idx));
    }

    public int type(int idx) {
        return this.lock((LuaState l) -> l.type(idx));
    }

    public String typeName(int tp) {
        return this.lock((LuaState l) -> l.typeName(tp));
    }

    public int equal(int idx1, int idx2) {
        return this.lock((LuaState l) -> l.equal(idx1, idx2));
    }

    public boolean rawequal(int idx1, int idx2) {
        return this.lock((LuaState l) -> l.rawequal(idx1, idx2));
    }

    public int lessthan(int idx1, int idx2) {
        return this.lock((LuaState l) -> l.lessthan(idx1, idx2));
    }

    public double toNumber(int idx) {
        return this.lock((LuaState l) -> l.toNumber(idx));
    }

    public int toInteger(int idx) {
        return this.lock((LuaState l) -> l.toInteger(idx));
    }

    public boolean toBoolean(int idx) {
        return this.lock((LuaState l) -> l.toBoolean(idx));
    }

    public String toString(int idx) {
        return this.lock((LuaState l) -> l.toString(idx));
    }

    public int strLen(int idx) {
        return this.lock((LuaState l) -> l.strLen(idx));
    }

    public int objLen(int idx) {
        return this.lock((LuaState l) -> l.objLen(idx));
    }

    public LuaStateFacade toThread(int idx) {
        this.lock.lock();
        try {
            LuaStateFacade luaStateFacade = new LuaStateFacade(this.luaState.toThread(idx));
            return luaStateFacade;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pushNil() {
        this.lock(LuaState::pushNil);
    }

    public void pushNumber(double db) {
        this.lock((LuaState l) -> l.pushNumber(db));
    }

    public void pushInteger(int integer) {
        this.lock((LuaState l) -> l.pushInteger(integer));
    }

    public void pushString(String str) {
        this.lock((LuaState l) -> l.pushString(str));
    }

    public void pushString(byte[] bytes) {
        this.lock((LuaState l) -> l.pushString(bytes));
    }

    public void pushBoolean(boolean bool) {
        this.lock((LuaState l) -> l.pushBoolean(bool));
    }

    public void getTable(int idx) {
        this.lock((LuaState l) -> l.getTable(idx));
    }

    public void getField(int idx, String k) {
        this.lock((LuaState l) -> l.getField(idx, k));
    }

    public void rawGet(int idx) {
        this.lock((LuaState l) -> l.rawGet(idx));
    }

    public void rawGetI(int idx, int n) {
        this.lock((LuaState l) -> l.rawGetI(idx, n));
    }

    public void createTable(int narr, int nrec) {
        this.lock((LuaState l) -> l.createTable(narr, nrec));
    }

    public void newTable() {
        this.lock(LuaState::newTable);
    }

    public boolean getMetaTable(int idx) {
        return this.lock((LuaState l) -> l.getMetaTable(idx));
    }

    public void getFEnv(int idx) {
        this.lock((LuaState l) -> l.getFEnv(idx));
    }

    public void setTable(int idx) {
        this.lock((LuaState l) -> l.setTable(idx));
    }

    public void setField(int idx, String k) {
        this.lock((LuaState l) -> l.setField(idx, k));
    }

    public void rawSet(int idx) {
        this.lock((LuaState l) -> l.rawSet(idx));
    }

    public void rawSetI(int idx, int n) {
        this.lock((LuaState l) -> l.rawSetI(idx, n));
    }

    public int setMetaTable(int idx) {
        return this.lock((LuaState l) -> l.setMetaTable(idx));
    }

    public int setFEnv(int idx) {
        return this.lock((LuaState l) -> l.setFEnv(idx));
    }

    public void call(int nArgs, int nResults) {
        this.lock((LuaState l) -> l.call(nArgs, nResults));
    }

    public Result<Void, LuaException> pcall(int nArgs, int nResults, int errFunc) {
        return this.lock((LuaState l) -> this.doPcall(nArgs, nResults, errFunc));
    }

    public Result<Void, LuaException> doPcall(int nArgs, int nResults, int errFunc) {
        int exp = this.luaState.pcall(nArgs, nResults, errFunc);
        if (exp != 0) {
            String err = this.getErrorMessage(exp);
            return Result.failure(new LuaException(err), err);
        }
        return Result.success();
    }

    public Result<Object, ? extends LuaException> pcall(ILuaCallable callable, Object[] args) {
        return this.pcall(callable, args, 1).mapValue(it -> it[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Object[], ? extends LuaException> pcall(ILuaCallable callable, Object[] args, int nres) {
        this.lock.lock();
        try {
            Result<Object[], ? extends LuaException> result = this.doPcall(callable, args, nres);
            return result;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Object[], ? extends LuaException> doPcall(ILuaCallable callable, Object[] args, int _nres) {
        IInnerLuaObject innerObject = (IInnerLuaObject)((Object)callable);
        int top = this.luaState.getTop();
        int nargs = 0;
        try {
            innerObject.rawPush();
            if (args != null) {
                nargs = args.length;
                for (Object obj : args) {
                    Result<Void, ? extends LuaException> pushResult = this.rawPushObjectValue(obj);
                    if (!pushResult.isError()) continue;
                    Result result = pushResult.justCast();
                    return result;
                }
            }
            Result result = this.doPcall(nargs, _nres, 0).mapResultValue(v -> {
                int nres = _nres;
                int currentTop = this.luaState.getTop();
                if (nres == -1) {
                    nres = currentTop - top;
                }
                if (currentTop - top < nres) {
                    return Result.failure(new LuaException("Invalid Number of Results .")).justCast();
                }
                Object[] res = new Object[nres];
                for (int i = nres - 1; i >= 0; --i) {
                    Result<Object, ? extends LuaException> ret = this.rawToJavaObject(-1);
                    if (ret.isError()) {
                        return ret.justCast();
                    }
                    res[i] = ret.getValue();
                    this.luaState.pop(1);
                }
                return Result.success(res);
            });
            return result;
        }
        finally {
            this.luaState.setTop(top);
        }
    }

    public int yield(int nResults) {
        return this.lock((LuaState l) -> l.yield(nResults));
    }

    public int resume(int nArgs) {
        return this.lock((LuaState l) -> l.resume(nArgs));
    }

    public int status() {
        return this.lock(LuaState::status);
    }

    public int gc(int what, int data) {
        return this.lock((LuaState l) -> l.gc(what, data));
    }

    public int getGcCount() {
        return this.lock(LuaState::getGcCount);
    }

    public int next(int idx) {
        return this.lock((LuaState l) -> l.next(idx));
    }

    public int error() {
        return this.lock(LuaState::error);
    }

    public void concat(int n) {
        this.lock((LuaState l) -> l.concat(n));
    }

    public int LgetMetaField(int obj, String e) {
        return this.lock((LuaState l) -> l.LgetMetaField(obj, e));
    }

    public int LcallMeta(int obj, String e) {
        return this.lock((LuaState l) -> l.LcallMeta(obj, e));
    }

    public int Ltyperror(int nArg, String tName) {
        return this.lock((LuaState l) -> l.Ltyperror(nArg, tName));
    }

    public int LargError(int numArg, String extraMsg) {
        return this.lock((LuaState l) -> l.LargError(numArg, extraMsg));
    }

    public String LcheckString(int numArg) {
        return this.lock((LuaState l) -> l.LcheckString(numArg));
    }

    public String LoptString(int numArg, String def) {
        return this.lock((LuaState l) -> l.LoptString(numArg, def));
    }

    public double LcheckNumber(int numArg) {
        return this.lock((LuaState l) -> l.LcheckNumber(numArg));
    }

    public double LoptNumber(int numArg, double def) {
        return this.lock((LuaState l) -> l.LoptNumber(numArg, def));
    }

    public int LcheckInteger(int numArg) {
        return this.lock((LuaState l) -> l.LcheckInteger(numArg));
    }

    public int LoptInteger(int numArg, int def) {
        return this.lock((LuaState l) -> l.LoptInteger(numArg, def));
    }

    public void LcheckStack(int sz, String msg) {
        this.lock((LuaState l) -> l.LcheckStack(sz, msg));
    }

    public void LcheckType(int nArg, int t) {
        this.lock((LuaState l) -> l.LcheckType(nArg, t));
    }

    public void LcheckAny(int nArg) {
        this.lock((LuaState l) -> l.LcheckAny(nArg));
    }

    public int LnewMetatable(String tName) {
        return this.lock((LuaState l) -> l.LnewMetatable(tName));
    }

    public void LgetMetatable(String tName) {
        this.lock((LuaState l) -> l.LgetMetatable(tName));
    }

    public void Lwhere(int lvl) {
        this.lock((LuaState l) -> l.Lwhere(lvl));
    }

    public int Lref(int t) {
        return this.lock((LuaState l) -> l.Lref(t));
    }

    public void LunRef(int t, int ref) {
        this.lock((LuaState l) -> l.LunRef(t, ref));
    }

    public String Lgsub(String s, String p, String r) {
        return this.lock((LuaState l) -> l.Lgsub(s, p, r));
    }

    public String LfindTable(int idx, String fname, int szhint) {
        return this.lock((LuaState l) -> l.LfindTable(idx, fname, szhint));
    }

    public void pop(int n) {
        this.lock((LuaState l) -> l.pop(n));
    }

    public Result<Object, ? extends LuaException> getGlobal(String globalName) {
        return this.getGlobal(globalName, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Result<T, ? extends LuaException> getGlobal(String globalName, Class<T> tClass) {
        this.lock.lock();
        try {
            this.luaState.getGlobal(globalName);
            try {
                Result result = this.rawToJavaObject(-1).mapResultValue(it -> tClass.isInstance(it) ? Result.success(tClass.cast(it)) : Result.failure(new LuaException("failed to convert " + it + " to " + tClass)));
                this.luaState.pop(1);
                return result;
            }
            catch (Throwable throwable) {
                this.luaState.pop(1);
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Result<Void, ? extends LuaException> setGlobal(String name, LuaObject luaObject) {
        return this.lockThrowAll((LuaState l) -> {
            luaObject.rawPush();
            l.setGlobal(name);
        }).justCast();
    }

    public Result<Void, ? extends LuaException> setGlobal(String name, Object obj) {
        if (obj instanceof LuaObject) {
            return this.setGlobal(name, (LuaObject)obj);
        }
        return this.lockThrowAll((LuaState l) -> {
            this.rawPushObjectValue(obj).justThrow();
            l.setGlobal(name);
        }).justCast();
    }

    public void openBase() {
        this.lock(LuaState::openBase);
    }

    public void openTable() {
        this.lock(LuaState::openTable);
    }

    public void openIo() {
        this.lock(LuaState::openIo);
    }

    public void openOs() {
        this.lock(LuaState::openOs);
    }

    public void openString() {
        this.lock(LuaState::openString);
    }

    public void openMath() {
        this.lock(LuaState::openMath);
    }

    public void openDebug() {
        this.lock(LuaState::openDebug);
    }

    public void openPackage() {
        this.lock(LuaState::openPackage);
    }

    public int rawLen(int idx) {
        return this.lock((LuaState it) -> it.rawLen(idx));
    }

    public boolean compare(int idx1, int idx2, int op) {
        return this.lock((LuaState l) -> l.compare(idx1, idx2, op));
    }

    public void arith(int op) {
        this.lock((LuaState l) -> l.arith(op));
    }

    public void len(int idx) {
        this.lock((LuaState l) -> l.len(idx));
    }

    public int resume(LuaState thread, int nargs) {
        return this.lock((LuaState l) -> l.resume(thread, nargs));
    }

    public int pushThread(LuaState thread) {
        return this.lock((LuaState l) -> l.pushThread(thread));
    }

    public void setUserValue(int idx) {
        this.lock((LuaState l) -> l.setUserValue(idx));
    }

    public void getUserValue(int idx) {
        this.lock((LuaState l) -> l.getUserValue(idx));
    }

    public int absIndex(int idx) {
        return this.lock((LuaState it) -> it.absIndex(idx));
    }

    public void openLibs() {
        this.lock(LuaState::openLibs);
    }

    public Object getObjectFromUserdata(int idx) throws LuaException {
        return this.lockThrow((LuaState l) -> l.getObjectFromUserdata(idx));
    }

    public boolean isObject(int idx) {
        return this.lock((LuaState l) -> l.isObject(idx));
    }

    public void pushJavaObject(Object obj) {
        this.lock((LuaState l) -> l.pushJavaObject(obj));
    }

    public void pushJavaClass(Class<?> clazz) {
        this.lock((LuaState l) -> l.pushJavaClass(clazz));
    }

    public void pushJavaArray(Object obj) throws LuaException {
        this.lockThrow((LuaState l) -> l.pushJavaArray(obj));
    }

    public void pushJavaFunction(JavaFunction func) throws LuaException {
        this.lockThrow((LuaState l) -> l.pushJavaFunction(func));
    }

    public boolean isJavaFunction(int idx) {
        return this.lock((LuaState l) -> l.isJavaFunction(idx));
    }

    public static interface LuaStateSafeConsumer {
        public void accept(LuaState var1);
    }

    public static interface LuaStateSafeFunction<T> {
        public T apply(LuaState var1);
    }

    public static interface LuaStateDangerConsumer {
        public void accept(LuaState var1) throws Exception;
    }

    public static interface LuaStateDangerFunction<T> {
        public T apply(LuaState var1) throws Exception;
    }

    public static interface LuaStateConsumer {
        public void accept(LuaState var1) throws LuaException;
    }

    public static interface LuaStateFunction<T> {
        public T apply(LuaState var1) throws LuaException;
    }
}

