/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eu.smileyik.luajava.CPtr;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.util.ParamRef;

public final class LuaStateFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private static final ConcurrentMap<Integer, LuaStateFacade> STATES = new ConcurrentHashMap<Integer, LuaStateFacade>();
    private static final ConcurrentMap<Long, Integer> CPER_TP_STATE_ID_MAP = new ConcurrentHashMap<Long, Integer>();

    private LuaStateFactory() {
    }

    public static synchronized LuaStateFacade newLuaState() {
        return LuaStateFactory.newLuaState(true);
    }

    public static synchronized LuaStateFacade newLuaState(boolean ignoreNotPublic) {
        LuaStateFacade facade = new LuaStateFacade(COUNTER.getAndIncrement(), ignoreNotPublic);
        STATES.put(facade.getStateId(), facade);
        CPER_TP_STATE_ID_MAP.put(facade.getCPtrPeer(), facade.getStateId());
        return facade;
    }

    public static LuaStateFacade getExistingState(int index) {
        return (LuaStateFacade)STATES.get(index);
    }

    public static synchronized int insertLuaState(LuaStateFacade L, CPtr cPtr, ParamRef<LuaStateFacade> existLuaState) {
        long target = cPtr == null ? L.getCPtrPeer() : cPtr.getPeer();
        Integer stateId = (Integer)CPER_TP_STATE_ID_MAP.get(target);
        if (stateId == null) {
            stateId = COUNTER.incrementAndGet();
            CPER_TP_STATE_ID_MAP.put(target, stateId);
            STATES.put(stateId, L);
        } else {
            existLuaState.setParam((LuaStateFacade)STATES.get(stateId));
        }
        return stateId;
    }

    public static void removeLuaState(int idx) {
        LuaStateFacade remove = (LuaStateFacade)STATES.remove(idx);
        if (remove != null) {
            long cPtrPeer = remove.getCPtrPeer();
            CPER_TP_STATE_ID_MAP.remove(cPtrPeer, idx);
        }
    }
}

