/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.debug;

import java.nio.ByteBuffer;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.debug.LuaDebugReader;
import org.eu.smileyik.luajava.debug.LuaDebugReaderLua51;
import org.eu.smileyik.luajava.debug.LuaDebugReaderLua52;
import org.eu.smileyik.luajava.debug.LuaDebugReaderLua54;

public class LuaDebug {
    private static final LuaDebugReader LUA_DEBUG_READER;
    private final long ptr;
    private final int event;
    private final String name;
    private final String nameWhat;
    private final String what;
    private final String source;
    private final long srcLen;
    private final int currentLine;
    private final int lineDefine;
    private final int lastLineDefine;
    private final int nUps;
    private final short nParams;
    private final byte isVarArg;
    private final byte isTailCall;
    private final int fTransfer;
    private final int nTransfer;
    private final String shortSrc;

    public LuaDebug(long ptr) {
        this(ptr, 0, null, null, null, null, 0L, 0, 0, 0, 0, 0, 0, 0, 0, 0, null);
    }

    public LuaDebug(long ptr, int event, String name, String nameWhat, String what, String source, long srcLen, int currentLine, int lineDefine, int lastLineDefine, int nUps, short nParams, byte isVarArg, byte isTailCall, int fTransfer, int nTransfer, String shortSrc) {
        this.ptr = ptr;
        this.event = event;
        this.name = name;
        this.nameWhat = nameWhat;
        this.what = what;
        this.source = source;
        this.srcLen = srcLen;
        this.currentLine = currentLine;
        this.lineDefine = lineDefine;
        this.lastLineDefine = lastLineDefine;
        this.nUps = nUps;
        this.nParams = nParams;
        this.isVarArg = isVarArg;
        this.isTailCall = isTailCall;
        this.fTransfer = fTransfer;
        this.nTransfer = nTransfer;
        this.shortSrc = shortSrc;
    }

    public static LuaDebug newInstance(long ptr, ByteBuffer buffer, String name, String nameWhat, String what, String source) {
        return LUA_DEBUG_READER.read(ptr, buffer, name, nameWhat, what, source);
    }

    public long getPtr() {
        return this.ptr;
    }

    public int getEvent() {
        return this.event;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWhat() {
        return this.nameWhat;
    }

    public String getWhat() {
        return this.what;
    }

    public String getSource() {
        return this.source;
    }

    public long getSrcLen() {
        return this.srcLen;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getLineDefine() {
        return this.lineDefine;
    }

    public int getLastLineDefine() {
        return this.lastLineDefine;
    }

    public int getnUps() {
        return this.nUps;
    }

    public short getnParams() {
        return this.nParams;
    }

    public byte getIsVarArg() {
        return this.isVarArg;
    }

    public byte getIsTailCall() {
        return this.isTailCall;
    }

    public int getfTransfer() {
        return this.fTransfer;
    }

    public int getnTransfer() {
        return this.nTransfer;
    }

    public String getShortSrc() {
        return this.shortSrc;
    }

    public String toString() {
        return "LuaDebug{ptr=" + this.ptr + ", event=" + this.event + ", name='" + this.name + '\'' + ", nameWhat='" + this.nameWhat + '\'' + ", what='" + this.what + '\'' + ", source='" + this.source + '\'' + ", srcLen=" + this.srcLen + ", currentLine=" + this.currentLine + ", lineDefine=" + this.lineDefine + ", lastLineDefine=" + this.lastLineDefine + ", nUps=" + this.nUps + ", nParams=" + this.nParams + ", isVarArg=" + this.isVarArg + ", isTailCall=" + this.isTailCall + ", fTransfer=" + this.fTransfer + ", nTransfer=" + this.nTransfer + ", shortSrc='" + this.shortSrc + '\'' + '}';
    }

    static {
        LuaDebugReader reader = null;
        switch (LuaState.LUA_VERSION) {
            case "Lua 5.1": {
                reader = new LuaDebugReaderLua51();
                break;
            }
            case "Lua 5.2": 
            case "Lua 5.3": {
                reader = new LuaDebugReaderLua52();
                break;
            }
            default: {
                reader = new LuaDebugReaderLua54();
            }
        }
        LUA_DEBUG_READER = reader;
    }
}

