/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.debug.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.debug.LuaDebug;
import org.eu.smileyik.luajava.type.LuaTable;

public class DebugUtils {
    public static Map<String, Object> getLocalVariable(LuaStateFacade facade, LuaDebug ar) {
        if (ar == null) {
            return Collections.emptyMap();
        }
        LuaState luaState = facade.getLuaState();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = null;
        int idx = 1;
        while ((name = luaState.getLocal(ar, idx++)) != null) {
            if (!name.startsWith("(")) {
                map.put(name, facade.rawToJavaObject(-1).orElseGet(() -> null));
            }
            luaState.pop(1);
        }
        return map;
    }

    public static Map<String, Object> getGlobalVariable(LuaStateFacade facade, LuaDebug ar) {
        if (ar == null) {
            return Collections.emptyMap();
        }
        LuaState luaState = facade.getLuaState();
        luaState.pushGlobalTable();
        Object o = facade.rawToJavaObject(-1).orElseGet(() -> null);
        facade.pop(1);
        if (o instanceof LuaTable) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ((LuaTable)o).forEach((k, v) -> {
                if (k instanceof String) {
                    map.put((String)k, v);
                }
            });
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> getUpValues(LuaStateFacade facade, LuaDebug ar) {
        if (ar == null) {
            return Collections.emptyMap();
        }
        LuaState luaState = facade.getLuaState();
        if (!luaState.isFunction(-1)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = null;
        int idx = 1;
        while ((name = luaState.getUpValue(-1, idx++)) != null) {
            map.put(name, facade.rawToJavaObject(-1).orElseGet(() -> null));
            luaState.pop(1);
        }
        return map;
    }

    public static String variableToString(Object variable) {
        if (variable == null) {
            return "nil";
        }
        if (variable instanceof String) {
            return String.format("\"%s\"", variable);
        }
        if (variable instanceof LuaTable) {
            try {
                return DebugUtils.variableToString(new HashSet<Object>(), (LuaTable)variable);
            }
            catch (Exception e) {
                return "[Lua Table]";
            }
        }
        return variable.toString();
    }

    public static String variableToString(Set<Object> checked, LuaTable variable) {
        if (variable == null) {
            return "nil";
        }
        checked.add(variable);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        variable.forEach((key, value) -> {
            if (value instanceof LuaTable && !checked.add(value)) {
                return;
            }
            map.put(key, value);
        });
        ArrayList list = new ArrayList();
        map.forEach((key, value) -> {
            String keyString = "nil";
            String valueString = "nil";
            valueString = value instanceof LuaTable ? DebugUtils.variableToString(checked, (LuaTable)value) : DebugUtils.variableToString(value);
            keyString = key instanceof LuaTable ? DebugUtils.variableToString(checked, (LuaTable)key) : DebugUtils.variableToString(key);
            list.add(String.format("[%s]=%s", keyString, valueString));
        });
        return String.format("{%s}", String.join((CharSequence)", ", list));
    }
}

