/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.exception;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Result<T, E> {
    private static final Result<?, ?> SUCCESS = new Result<Object, Object>(null, null, null);
    private final String message;
    private final T value;
    private final E error;

    private Result(String message, T value, E error) {
        this.message = message;
        this.value = value;
        this.error = error;
    }

    public String getMessage() {
        return this.message;
    }

    public T getValue() {
        return this.value;
    }

    public E getError() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public Result<T, E> ifSuccessThen(Consumer<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Result<T, E> ifFailureThen(Consumer<E> consumer) {
        if (this.isError()) {
            consumer.accept(this.error);
        }
        return this;
    }

    public T orElse(T other) {
        return this.isError() ? other : this.value;
    }

    public T orElseGet(Supplier<T> other) {
        return this.isError() ? other.get() : this.value;
    }

    public void justThrow() throws Exception {
        if (this.isError()) {
            if (this.error instanceof Exception) {
                throw (Exception)this.error;
            }
            throw new RuntimeException(this.message == null ? Objects.toString(this.error) : this.message + this.error);
        }
    }

    public <Err extends Exception> void justThrow(Class<Err> clazz) throws Err {
        if (this.isError()) {
            if (clazz.isAssignableFrom(this.error.getClass())) {
                throw (Exception)clazz.cast(this.error);
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            if (this.error instanceof Throwable) {
                throw new RuntimeException(this.message, (Exception)this.error);
            }
            throw new RuntimeException(this.message == null ? Objects.toString(this.error) : this.message + this.error);
        }
    }

    public T getOrThrow() throws Exception {
        this.justThrow();
        return this.value;
    }

    public <Err extends Exception> T getOrThrow(Class<Err> clazz) throws Err {
        this.justThrow(clazz);
        return this.value;
    }

    public T getOrSneakyThrow() {
        if (this.isError()) {
            Throwable ret;
            Throwable throwable = ret = this.error instanceof Throwable ? (Throwable)this.error : null;
            if (ret == null) {
                throw new RuntimeException(this.message == null ? Objects.toString(this.error) : this.message + this.error);
            }
            throw new RuntimeException(this.message, ret);
        }
        return this.value;
    }

    public <RT, RE> Result<RT, RE> justCast() {
        return this;
    }

    public <RT, RE> Result<RT, RE> justCast(Class<RT> rtClass, Class<RE> reClass) {
        if (this.isError()) {
            return Result.failure(reClass.cast(this.error), this.message);
        }
        return Result.success(rtClass.cast(this.value), this.message);
    }

    private <RT, RE> Result<RT, RE> justReplaceValue(RT newValue) {
        if (newValue == this.value) {
            return this;
        }
        return newValue == null ? Result.success() : Result.success(newValue, this.message);
    }

    public <RT> Result<RT, E> replaceValue(RT newValue) {
        if (this.isError()) {
            return this;
        }
        if (newValue == this.value || this == SUCCESS && newValue == null) {
            return this;
        }
        return Result.success(newValue, this.message);
    }

    public <RT> Result<RT, E> mapValue(Function<T, RT> f) {
        if (this.isError()) {
            return this;
        }
        RT apply = f.apply(this.value);
        return this.justReplaceValue(apply);
    }

    public <RE> Result<T, RE> mapError(Function<E, RE> f) {
        if (this.isError()) {
            return Result.failure(f.apply(this.error), this.message);
        }
        return this;
    }

    public Result<T, String> replaceErrorString(Function<E, String> f) {
        if (this.isError()) {
            String str = null;
            str = this.error instanceof Throwable ? ((Throwable)this.error).getMessage() : f.apply(this.error);
            return Result.failure(str);
        }
        return this;
    }

    public <RT, RE> Result<RT, RE> map(Function<T, RT> rt, Function<E, RE> re) {
        if (this.isError()) {
            return Result.failure(re.apply(this.error), this.message);
        }
        RT apply = rt.apply(this.value);
        return this.justReplaceValue(apply);
    }

    public <RT, RE> Result<RT, RE> mapResultValue(Function<T, Result<RT, RE>> function) {
        if (this.isError()) {
            return this;
        }
        Result<RT, RE> ret = function.apply(this.value);
        if (ret != SUCCESS && ret.value == null && this.message == null) {
            return Result.success();
        }
        return ret;
    }

    public <RT, RE> Result<RT, RE> thenMap(ThrowFunction<T, Result<RT, RE>> function) {
        if (this.isError()) {
            return this;
        }
        try {
            Result<RT, RE> ret = function.apply(this.value);
            if (ret != SUCCESS && ret.value == null && this.message == null) {
                return Result.success();
            }
            return ret;
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public <RT, RE> Result<RT, RE> mapResult(Function<Result<T, E>, Result<RT, RE>> function) {
        Result<RT, RE> ret = function.apply(this);
        if (ret.value == null && this.error == null && this.message == null) {
            return Result.success();
        }
        return ret;
    }

    public String toString() {
        return this.isError() ? String.format("Result Error { %s }", this.error) : String.format("Result { %s }", this.value);
    }

    public static <T, E> Result<T, E> of(T value, E error) {
        return new Result<T, E>(null, value, error);
    }

    public static <T, E> Result<T, E> of(T value, E error, String message) {
        return new Result<T, E>(message, value, error);
    }

    public static <T, E> Result<T, E> success() {
        return SUCCESS;
    }

    public static <T, E> Result<T, E> success(T value) {
        if (value == null) {
            return Result.success();
        }
        return Result.of(value, null);
    }

    public static <T, E> Result<T, E> success(T value, String message) {
        if (value == null && message == null) {
            return Result.success();
        }
        return Result.of(value, null, message);
    }

    public static <T, E> Result<T, E> failure(E error) {
        assert (error != null);
        return Result.of(null, error);
    }

    public static <T, E> Result<T, E> failure(E error, String message) {
        assert (error != null);
        return Result.of(null, error, message);
    }

    public static interface ThrowFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

