/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.reflect;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.LuaArray;
import org.eu.smileyik.luajava.util.BoxedTypeHelper;
import org.eu.smileyik.luajava.util.LRUCache;
import org.eu.smileyik.luajava.util.ParamRef;

public class ConvertablePriority {
    public static final byte NOT_MATCH = -1;
    public static final byte FULL_MATCH = 0;
    public static final byte NULL_TO_ALL = 10;
    public static final byte ASSIGNABLE = 20;
    public static final byte BOXED_TYPE_EQUALS = 25;
    public static final byte BOXED_TYPE_ASSIGNABLE = 30;
    public static final byte DOUBLE_TO_DOUBLE = 40;
    public static final byte DOUBLE_TO_FLOAT = 41;
    public static final byte DOUBLE_TO_LONG = 42;
    public static final byte DOUBLE_TO_INT = 43;
    public static final byte DOUBLE_TO_SHORT = 44;
    public static final byte DOUBLE_TO_BYTE = 45;
    public static final byte ARRAY_DOUBLE_TO_DOUBLE = 50;
    public static final byte ARRAY_DOUBLE_TO_FLOAT = 51;
    public static final byte ARRAY_DOUBLE_TO_LONG = 52;
    public static final byte ARRAY_DOUBLE_TO_INT = 53;
    public static final byte ARRAY_DOUBLE_TO_SHORT = 54;
    public static final byte ARRAY_DOUBLE_TO_BYTE = 55;
    public static final byte ARRAY_TO_PRIMITIVE_ARRAY = 60;
    public static final byte ARRAY_TO_SPECIFIC_OBJECT_ARRAY = 61;
    public static final byte ARRAY_TO_OBJECT_ARRAY = 64;
    public static final byte ARRAY_TO_OBJECT = 65;
    public static final byte ANY_TO_OBJECT = 70;
    public static final Map<Integer, Byte> DOUBLE_CONVERT_PRIMITIVE;
    public static final Map<Integer, Byte> DOUBLE_ARRAY_CONVERT_PRIMITIVE;
    public static final Map<Integer, Function<LuaArray, ?>> UNBOXED_LUA_ARRAY_TRANSFORMERS;
    public static final Map<Integer, Function<Object[], ?>> OBJECT_ARRAY_TRANSFORMERS;
    private static final Map<Long, Object[]> LUA_ARRAY_CACHE;

    public static byte double2TypePriority(Class<?> target) {
        if (target == null) {
            return -1;
        }
        return DOUBLE_CONVERT_PRIMITIVE.getOrDefault(target.hashCode(), (byte)-1);
    }

    public static byte arrayPriority(Class<?> componentType) {
        if (componentType == null) {
            return -1;
        }
        Byte b = DOUBLE_ARRAY_CONVERT_PRIMITIVE.get(componentType.hashCode());
        if (b != null) {
            return b;
        }
        if (componentType.isPrimitive()) {
            return 60;
        }
        if (componentType == Object.class) {
            return 64;
        }
        return 61;
    }

    private static byte doIsConvertableArray(int limitedPriority, LuaArray luaObj, Class<?> toType, ParamRef<Object> overwrite) {
        Object array;
        Class<?> componentType = toType.getComponentType();
        byte priority = ConvertablePriority.arrayPriority(componentType);
        if (priority == -1) {
            return -1;
        }
        if (limitedPriority < priority) {
            return -1;
        }
        long luaPointer = luaObj.rawGetLuaPointer();
        Object[] objects = LUA_ARRAY_CACHE.computeIfAbsent(luaPointer, ptr -> {
            Object[] array = new Object[luaObj.length()];
            luaObj.rawForEach(Integer.class, Object.class, (i, v) -> {
                array[i.intValue()] = v;
                return false;
            });
            return array;
        });
        Object object = array = componentType.isPrimitive() ? OBJECT_ARRAY_TRANSFORMERS.get(toType.hashCode()).apply(objects) : ConvertablePriority.objectArrayToObjectArray(objects, componentType);
        if (array == null) {
            return -1;
        }
        if (overwrite != null) {
            overwrite.setParam(array);
        }
        return priority;
    }

    public static byte isConvertableType(int limitedPriority, Object luaObj, Class<?> toType, ParamRef<Object> overwrite) {
        if (luaObj == null) {
            return toType.isPrimitive() ? (byte)-1 : 10;
        }
        boolean isToObject = toType == Object.class;
        Class<?> fromClass = luaObj.getClass();
        if (fromClass == toType) {
            return 0;
        }
        if (toType.isAssignableFrom(fromClass) && !isToObject) {
            return 20;
        }
        Class<?> boxedFromClass = BoxedTypeHelper.getBoxedType(fromClass);
        Class<?> boxedToClass = BoxedTypeHelper.getBoxedType(toType);
        if (boxedToClass.isAssignableFrom(boxedFromClass) && !isToObject) {
            return boxedFromClass == boxedToClass ? (byte)25 : 30;
        }
        if (BoxedTypeHelper.isBoxedNumberType(boxedFromClass) && BoxedTypeHelper.isBoxedNumberType(boxedToClass)) {
            byte priority = ConvertablePriority.double2TypePriority(toType);
            if (priority == -1 || limitedPriority < priority) {
                return -1;
            }
            if (overwrite != null) {
                overwrite.setParam(BoxedTypeHelper.covertNumberTo(((Number)luaObj).doubleValue(), boxedToClass));
            }
            return priority;
        }
        boolean isLuaArray = luaObj instanceof LuaArray;
        if (isLuaArray && toType.isArray()) {
            return ConvertablePriority.doIsConvertableArray(limitedPriority, (LuaArray)luaObj, toType, overwrite);
        }
        if (isToObject) {
            if (limitedPriority < 65) {
                return -1;
            }
            if (isLuaArray) {
                return 65;
            }
            return 70;
        }
        return -1;
    }

    private static Object objectArrayToObjectArray(Object[] objects, Class<?> toType) {
        Object array = Array.newInstance(toType, objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) continue;
            if (toType.isInstance(obj)) {
                Array.set(array, i, obj);
                continue;
            }
            return null;
        }
        return array;
    }

    private static byte[] objectArrayToByteArray(Object[] objects) {
        byte[] array = new byte[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).byteValue();
        }
        return array;
    }

    private static short[] objectArrayToShortArray(Object[] objects) {
        short[] array = new short[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).shortValue();
        }
        return array;
    }

    private static int[] objectArrayToIntArray(Object[] objects) {
        int[] array = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).intValue();
        }
        return array;
    }

    private static long[] objectArrayToLongArray(Object[] objects) {
        long[] array = new long[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).longValue();
        }
        return array;
    }

    private static float[] objectArrayToFloatArray(Object[] objects) {
        float[] array = new float[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).floatValue();
        }
        return array;
    }

    private static double[] objectArrayToDoubleArray(Object[] objects) {
        double[] array = new double[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Number)) {
                return null;
            }
            array[i] = ((Number)obj).doubleValue();
        }
        return array;
    }

    private static boolean[] objectArrayToBooleanArray(Object[] objects) {
        boolean[] array = new boolean[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (!(obj instanceof Boolean)) {
                return null;
            }
            array[i] = (Boolean)obj;
        }
        return array;
    }

    private static char[] objectArrayToCharArray(Object[] objects) {
        char[] array = new char[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof String)) {
                return null;
            }
            array[i] = ((String)obj).charAt(0);
        }
        return array;
    }

    private static Object luaArrayToObjectArray(LuaArray luaObj, Class<?> toType) {
        Object array = Array.newInstance(toType, luaObj.length());
        Result<Boolean, Exception> result = luaObj.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null || toType.isInstance(v)) {
                Array.set(array, k, v);
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static byte[] luaArrayToByteArray(LuaArray luaArray) {
        byte[] array = new byte[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).byteValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static short[] luaArrayToShortArray(LuaArray luaArray) {
        short[] array = new short[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).shortValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static int[] luaArrayToIntArray(LuaArray luaArray) {
        int[] array = new int[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).intValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static long[] luaArrayToLongArray(LuaArray luaArray) {
        long[] array = new long[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).longValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static double[] luaArrayToDoubleArray(LuaArray luaArray) {
        double[] array = new double[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).doubleValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static float[] luaArrayToFloatArray(LuaArray luaArray) {
        float[] array = new float[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Number) {
                array[k.intValue()] = ((Number)v).floatValue();
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static boolean[] luaArrayToBooleanArray(LuaArray luaArray) {
        boolean[] array = new boolean[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof Boolean) {
                array[k.intValue()] = (Boolean)v;
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    private static char[] luaArrayToCharArray(LuaArray luaArray) {
        char[] array = new char[luaArray.length()];
        Result<Boolean, Exception> result = luaArray.rawForEach(Integer.class, Object.class, (k, v) -> {
            if (v == null) {
                return true;
            }
            if (v instanceof String) {
                array[k.intValue()] = ((String)v).charAt(0);
                return false;
            }
            return true;
        });
        return result.isSuccess() && result.getValue() != false ? array : null;
    }

    static {
        LUA_ARRAY_CACHE = Collections.synchronizedMap(new LRUCache(64));
        HashMap<Integer, Byte> doubleConvert = new HashMap<Integer, Byte>();
        doubleConvert.put(Double.TYPE.hashCode(), (byte)40);
        doubleConvert.put(Double.class.hashCode(), (byte)40);
        doubleConvert.put(Float.TYPE.hashCode(), (byte)41);
        doubleConvert.put(Long.TYPE.hashCode(), (byte)42);
        doubleConvert.put(Integer.TYPE.hashCode(), (byte)43);
        doubleConvert.put(Short.TYPE.hashCode(), (byte)44);
        doubleConvert.put(Byte.TYPE.hashCode(), (byte)45);
        doubleConvert.put(Float.class.hashCode(), (byte)41);
        doubleConvert.put(Long.class.hashCode(), (byte)42);
        doubleConvert.put(Integer.class.hashCode(), (byte)43);
        doubleConvert.put(Short.class.hashCode(), (byte)44);
        doubleConvert.put(Byte.class.hashCode(), (byte)45);
        DOUBLE_CONVERT_PRIMITIVE = Collections.unmodifiableMap(doubleConvert);
        doubleConvert.clear();
        doubleConvert.put(Double.TYPE.hashCode(), (byte)50);
        doubleConvert.put(Double.class.hashCode(), (byte)50);
        doubleConvert.put(Float.TYPE.hashCode(), (byte)51);
        doubleConvert.put(Long.TYPE.hashCode(), (byte)52);
        doubleConvert.put(Integer.TYPE.hashCode(), (byte)53);
        doubleConvert.put(Short.TYPE.hashCode(), (byte)54);
        doubleConvert.put(Byte.TYPE.hashCode(), (byte)55);
        doubleConvert.put(Float.class.hashCode(), (byte)51);
        doubleConvert.put(Long.class.hashCode(), (byte)52);
        doubleConvert.put(Integer.class.hashCode(), (byte)53);
        doubleConvert.put(Short.class.hashCode(), (byte)54);
        doubleConvert.put(Byte.class.hashCode(), (byte)55);
        DOUBLE_ARRAY_CONVERT_PRIMITIVE = Collections.unmodifiableMap(doubleConvert);
        HashMap<Integer, Function<LuaArray, Object>> unboxedLuaArrayTransformers = new HashMap<Integer, Function<LuaArray, Object>>();
        unboxedLuaArrayTransformers.put(int[].class.hashCode(), ConvertablePriority::luaArrayToIntArray);
        unboxedLuaArrayTransformers.put(long[].class.hashCode(), ConvertablePriority::luaArrayToLongArray);
        unboxedLuaArrayTransformers.put(float[].class.hashCode(), ConvertablePriority::luaArrayToFloatArray);
        unboxedLuaArrayTransformers.put(boolean[].class.hashCode(), ConvertablePriority::luaArrayToBooleanArray);
        unboxedLuaArrayTransformers.put(char[].class.hashCode(), ConvertablePriority::luaArrayToCharArray);
        unboxedLuaArrayTransformers.put(short[].class.hashCode(), ConvertablePriority::luaArrayToShortArray);
        unboxedLuaArrayTransformers.put(byte[].class.hashCode(), ConvertablePriority::luaArrayToByteArray);
        unboxedLuaArrayTransformers.put(double[].class.hashCode(), ConvertablePriority::luaArrayToDoubleArray);
        UNBOXED_LUA_ARRAY_TRANSFORMERS = Collections.unmodifiableMap(unboxedLuaArrayTransformers);
        HashMap<Integer, Function<Object[], Object>> objectArrayTransformers = new HashMap<Integer, Function<Object[], Object>>();
        objectArrayTransformers.put(int[].class.hashCode(), ConvertablePriority::objectArrayToIntArray);
        objectArrayTransformers.put(long[].class.hashCode(), ConvertablePriority::objectArrayToLongArray);
        objectArrayTransformers.put(float[].class.hashCode(), ConvertablePriority::objectArrayToFloatArray);
        objectArrayTransformers.put(boolean[].class.hashCode(), ConvertablePriority::objectArrayToBooleanArray);
        objectArrayTransformers.put(char[].class.hashCode(), ConvertablePriority::objectArrayToCharArray);
        objectArrayTransformers.put(short[].class.hashCode(), ConvertablePriority::objectArrayToShortArray);
        objectArrayTransformers.put(byte[].class.hashCode(), ConvertablePriority::objectArrayToByteArray);
        objectArrayTransformers.put(double[].class.hashCode(), ConvertablePriority::objectArrayToDoubleArray);
        OBJECT_ARRAY_TRANSFORMERS = Collections.unmodifiableMap(objectArrayTransformers);
    }
}

