/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.type;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.LuaTable;

public class LuaArray
extends LuaTable {
    Function<LuaArray, Result<?, ? extends Exception>> EMPTY = array -> Result.failure(new IllegalArgumentException("Need primitive type!"));
    private static final Map<Class<?>, Function<LuaArray, Result<?, ? extends Exception>>> UNBOXED_ARRAY_TRANSFORMERS = new HashMap();
    protected int len;

    protected LuaArray(LuaStateFacade L, int index, int len) {
        super(L, index);
        this.len = len;
    }

    @Override
    public String toString() {
        Result result = this.asDeepList(Object.class);
        return result.isError() ? result.toString() : result.getValue().toString();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public int length() {
        return this.len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public Result<byte[], ? extends Exception> toByteArray() {
        byte[] bytes = new byte[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            bytes[idx.intValue()] = num.byteValue();
        }).replaceValue(bytes);
    }

    public Result<short[], ? extends Exception> toShortArray() {
        short[] shorts = new short[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            shorts[idx.intValue()] = num.shortValue();
        }).replaceValue(shorts);
    }

    public Result<int[], ? extends Exception> toIntArray() {
        int[] nums = new int[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            nums[idx.intValue()] = num.intValue();
        }).replaceValue(nums);
    }

    public Result<long[], ? extends Exception> toLongArray() {
        long[] longs = new long[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            longs[idx.intValue()] = num.longValue();
        }).replaceValue(longs);
    }

    public Result<float[], ? extends Exception> toFloatArray() {
        float[] floats = new float[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            floats[idx.intValue()] = num.floatValue();
        }).replaceValue(floats);
    }

    public Result<boolean[], ? extends Exception> toBooleanArray() {
        boolean[] bool = new boolean[this.len];
        return this.forEach(Boolean.class, (idx, b) -> {
            bool[idx.intValue()] = b;
        }).replaceValue(bool);
    }

    public Result<char[], ? extends Exception> toCharArray() {
        char[] chars = new char[this.len];
        return this.forEach(String.class, (idx, str) -> {
            chars[idx.intValue()] = str.charAt(0);
        }).replaceValue(chars);
    }

    public Result<double[], ? extends Exception> toDoubleArray() {
        double[] doubles = new double[this.len];
        return this.forEach(Double.class, (idx, num) -> {
            doubles[idx.intValue()] = num;
        }).replaceValue(doubles);
    }

    public Result<List<Object>, ? extends Exception> asList() {
        return this.asList(Object.class);
    }

    public <T> Result<List<T>, ? extends Exception> asList(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return Result.failure(new IllegalArgumentException("Primitive type is not supported"));
        }
        if (clazz == Character.class) {
            return this.asCharacterList().justCast();
        }
        ArrayList list = new ArrayList(this.len);
        return this.forEachValue(clazz, list::add).replaceValue(list);
    }

    public Result<List<Character>, ? extends Exception> asCharacterList() {
        ArrayList list = new ArrayList(this.len);
        return this.forEachValue(String.class, it -> list.add(Character.valueOf(it.charAt(0)))).replaceValue(list);
    }

    public <T> Result<List<T>, ? extends Exception> asDeepList(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Result.failure(new IllegalArgumentException("Primitive type is not supported"));
        }
        if (clazz == Character.class) {
            return this.asDeepCharacterList();
        }
        ArrayList list = new ArrayList(this.len);
        return this.forEachValue(v -> {
            if (v instanceof LuaArray) {
                if (Objects.equals(this, v)) {
                    throw new RuntimeException("Cannot asDeepList, because same array as element. ");
                }
                list.add(((LuaArray)v).asDeepList(clazz).getOrSneakyThrow());
            } else {
                list.add(clazz.cast(v));
            }
        }).replaceValue(list);
    }

    public <T> Result<List<T>, ? extends Exception> asDeepCharacterList() {
        ArrayList list = new ArrayList(this.len);
        return this.forEachValue(v -> {
            if (v instanceof LuaArray) {
                if (Objects.equals(this, v)) {
                    throw new RuntimeException("Cannot asDeepList, because same array as element. ");
                }
                list.add(((LuaArray)v).asDeepCharacterList().getOrSneakyThrow());
            } else {
                list.add(Character.valueOf(String.valueOf(v).charAt(0)));
            }
        }).replaceValue(list);
    }

    public Result<Object[], ? extends Exception> asArray() {
        return this.asArray(Object.class);
    }

    public <T> Result<T[], ? extends Exception> asArray(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return Result.failure(new IllegalArgumentException("Primitive type is not supported"));
        }
        return this.asList(clazz).mapValue(list -> list.toArray((Object[])Array.newInstance(clazz, 0)));
    }

    public <T> Result<T, ? extends Exception> asPrimitiveArray(Class<T> tClass) {
        if (!tClass.isArray() || !tClass.getComponentType().isPrimitive()) {
            return Result.failure(new IllegalArgumentException("Not a primitive array type: " + tClass));
        }
        return UNBOXED_ARRAY_TRANSFORMERS.getOrDefault(tClass, this.EMPTY).apply(this).justCast();
    }

    public Result<Void, ? extends Exception> forEachValue(Consumer<Object> consumer) {
        return this.forEachValue(Object.class, consumer);
    }

    public <T> Result<Void, ? extends Exception> forEachValue(Class<T> tClass, Consumer<T> consumer) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        return this.luaState.lockThrowAll(l -> {
            int top = l.getTop();
            try {
                this.push();
                for (int i = 1; i <= this.len; ++i) {
                    l.rawGetI(-1, i);
                    Object javaObject = this.luaState.toJavaObject(-1).getOrThrow();
                    consumer.accept(tClass.cast(javaObject));
                    l.pop(1);
                }
                l.pop(1);
            }
            finally {
                l.setTop(top);
            }
            return null;
        });
    }

    @Override
    public <K, V> Result<Void, ? extends Exception> forEach(Class<K> kClass, Class<V> vClass, BiConsumer<K, V> consumer) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        return this.luaState.lockThrowAll(l -> {
            int top = l.getTop();
            try {
                this.push();
                for (int i = 1; i <= this.len; ++i) {
                    l.rawGetI(-1, i);
                    Object javaObject = this.luaState.toJavaObject(-1).getOrThrow();
                    consumer.accept(kClass.cast(i - 1), vClass.cast(javaObject));
                    l.pop(1);
                }
                l.pop(1);
            }
            finally {
                l.setTop(top);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Result<Boolean, ? extends Exception> rawForEach(Class<K> kClass, Class<V> vClass, BiFunction<K, V, Boolean> function) {
        LuaState l = this.getLuaState().getLuaState();
        int top = l.getTop();
        try {
            this.rawPush();
            for (int i = 1; i <= this.len; ++i) {
                l.rawGetI(-1, i);
                Result<Object, ? extends LuaException> valueResult = this.luaState.rawToJavaObject(-1);
                if (valueResult.isError()) {
                    Result result = valueResult.justCast();
                    return result;
                }
                if (function.apply(i - 1, valueResult.getValue()).booleanValue()) {
                    Result result = Result.success(false);
                    return result;
                }
                l.pop(1);
            }
            l.pop(1);
        }
        finally {
            l.setTop(top);
        }
        return Result.success(true);
    }

    public <V> Result<Void, ? extends Exception> forEach(Class<V> vClass, BiConsumer<Integer, V> consumer) {
        return this.forEach(Integer.class, vClass, consumer);
    }

    public Result<Object, ? extends LuaException> at(int idx) {
        return this.luaState.lockThrow(l -> this.doAt(idx).getOrThrow(LuaException.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Object, ? extends LuaException> doAt(int idx) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        if (idx < 0 || idx >= this.len) {
            return Result.failure(new LuaException("out of bounds: idx=" + idx + ", len=" + this.len));
        }
        LuaState inner = this.luaState.getLuaState();
        int top = inner.getTop();
        try {
            this.rawPush();
            inner.rawGetI(-1, idx + 1);
            Result<Object, ? extends LuaException> result = this.luaState.rawToJavaObject(-1);
            return result;
        }
        finally {
            inner.setTop(top);
        }
    }

    public Result<Void, ? extends Exception> set(int idx, Object obj) {
        return this.luaState.lock(l -> this.rawSet(idx, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Void, ? extends LuaException> rawSet(int idx, Object obj) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        if (idx < 0 || idx >= this.len) {
            return Result.failure(new LuaException("out of bounds: idx=" + idx + ", len=" + this.len));
        }
        if (obj instanceof LuaObject && !Objects.equals(this.luaState, ((LuaObject)obj).getLuaState())) {
            return Result.failure(new LuaException("Lua objects are in different lua states!"));
        }
        LuaState inner = this.luaState.getLuaState();
        int top = inner.getTop();
        try {
            this.rawPush();
            Result<Void, ? extends LuaException> result = this.luaState.rawPushObjectValue(obj).mapValue(it -> {
                inner.rawSetI(-2, idx + 1);
                return null;
            });
            return result;
        }
        finally {
            inner.setTop(top);
        }
    }

    public Result<Void, ? extends LuaException> add(Object obj) {
        return this.luaState.lock(it -> this.rawAdd(obj));
    }

    public synchronized Result<Void, ? extends LuaException> rawAdd(Object obj) {
        return this.rawSet(this.len++, obj).ifFailureThen(it -> --this.len);
    }

    @Override
    public Result<Void, ? extends LuaException> rawPut(Object key, Object value) {
        throw new UnsupportedOperationException("Lua Array not support put method. please use add method");
    }

    @Override
    public Result<Void, ? extends LuaException> rawRemove(Object key) {
        throw new UnsupportedOperationException("Lua Array not support remove method.");
    }

    public Result<Void, ? extends LuaException> remove(int idx) {
        return this.luaState.lock(it -> this.rawRemove(idx));
    }

    public Result<Void, ? extends LuaException> rawRemove(int idx) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        if (idx < 0 || idx >= this.len) {
            return Result.failure(new LuaException("out of bounds: idx=" + idx + ", len=" + this.len));
        }
        LuaState inner = this.luaState.getLuaState();
        this.rawPush();
        for (int i = idx + 1; i < this.len; ++i) {
            this.luaState.rawGetI(-1, i + 1);
            this.luaState.rawSetI(-2, i);
        }
        inner.pushNil();
        inner.rawSetI(-2, this.len);
        --this.len;
        inner.pop(1);
        return Result.success();
    }

    @Override
    public Result<Void, ? extends Exception> forEach(BiConsumer<Object, Object> consumer) {
        return this.forEach(Object.class, Object.class, consumer);
    }

    static {
        UNBOXED_ARRAY_TRANSFORMERS.put(int[].class, LuaArray::toIntArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(long[].class, LuaArray::toLongArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(float[].class, LuaArray::toFloatArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(boolean[].class, LuaArray::toBooleanArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(char[].class, LuaArray::toCharArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(short[].class, LuaArray::toShortArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(byte[].class, LuaArray::toByteArray);
        UNBOXED_ARRAY_TRANSFORMERS.put(double[].class, LuaArray::toDoubleArray);
    }
}

