/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.ILuaFieldGettable;
import org.eu.smileyik.luajava.type.LuaArray;

public class LuaTable
extends LuaObject
implements ILuaCallable,
ILuaFieldGettable {
    protected LuaTable(LuaStateFacade L, int index) {
        super(L, index);
    }

    protected static LuaTable createTable(LuaStateFacade luaStateFacade, int index) {
        return luaStateFacade.lock(l -> LuaTable.rawCreateTable(luaStateFacade, index));
    }

    protected static LuaTable rawCreateTable(LuaStateFacade luaStateFacade, int index) {
        int len = luaStateFacade.getLuaState().isLuaArray(index);
        if (len >= 0) {
            return new LuaArray(luaStateFacade, index, len);
        }
        return new LuaTable(luaStateFacade, index);
    }

    @Override
    public String toString() {
        Result<Map<Object, Object>, ? extends Exception> deepMap = this.asDeepMap();
        return deepMap.isError() ? "[Cannot Transform this LuaTable to Map]" : deepMap.getValue().toString();
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isUserdata() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isLuaPointerObject() {
        return true;
    }

    public LuaTable asTable() {
        if (this instanceof LuaArray) {
            try {
                LuaTable luaTable = this.luaState.lock(it -> {
                    try {
                        this.rawPush();
                        LuaTable luaTable = new LuaTable(this.luaState, -1);
                        return luaTable;
                    }
                    finally {
                        it.pop(1);
                    }
                });
                return luaTable;
            }
            finally {
                this.close();
            }
        }
        return this;
    }

    public Result<Map<String, Object>, ? extends Exception> asDeepStringMap() {
        return this.asDeepMap(String.class, Object.class);
    }

    public <V> Result<Map<String, V>, ? extends Exception> asDeepStringMap(Class<V> vClass) {
        return this.asDeepMap(String.class, vClass);
    }

    public Result<Map<Object, Object>, ? extends Exception> asDeepMap() {
        return this.asDeepMap(Object.class, Object.class);
    }

    public <K, V> Result<Map<K, V>, ? extends Exception> asDeepMap(Class<K> kClass, Class<V> vClass) {
        return this.asDeepMap(new HashSet<LuaTable>(Collections.singleton(this)), kClass, vClass);
    }

    protected <K, V> Result<Map<K, V>, ? extends Exception> asDeepMap(Set<LuaTable> checked, Class<K> kClass, Class<V> vClass) {
        HashMap map = new HashMap();
        return this.forEach(kClass, vClass, (K k, V v) -> {
            Object key = k;
            Object value = v;
            if (k instanceof LuaTable && !checked.add((LuaTable)k)) {
                return;
            }
            if (v instanceof LuaTable && !checked.add((LuaTable)v)) {
                return;
            }
            map.put(key, value);
        }).mapValue(it -> {
            HashMap result = new HashMap();
            map.forEach((? super K k, ? super V v) -> {
                Result key = k;
                Result value = v;
                if (key instanceof LuaTable) {
                    key = ((LuaTable)((Object)key)).asDeepMap(checked, kClass, vClass);
                }
                if (value instanceof LuaTable) {
                    value = ((LuaTable)((Object)value)).asDeepMap(checked, kClass, vClass);
                }
                result.put(key, value);
            });
            return result;
        });
    }

    public Result<Map<Object, Object>, ? extends Exception> asMap() {
        return this.asMap(Object.class, Object.class);
    }

    public <K, V> Result<Map<K, V>, ? extends Exception> asMap(Class<K> kClass, Class<V> vClass) {
        HashMap map = new HashMap();
        return this.forEach(kClass, vClass, map::put).replaceValue(map);
    }

    public Result<Map<String, Object>, ? extends Exception> asStringMap() {
        return this.asStringMap(Object.class);
    }

    public <V> Result<Map<String, V>, ? extends Exception> asStringMap(Class<V> vClass) {
        return this.asMap(String.class, vClass);
    }

    public <K, V> Result<Void, ? extends Exception> forEach(Class<K> kClass, Class<V> vClass, BiConsumer<K, V> consumer) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        return this.luaState.lockThrowAll(l -> {
            int top = l.getTop();
            try {
                this.push();
                l.pushNil();
                while (l.next(-2) != 0) {
                    Object key = this.luaState.toJavaObject(-2).getOrThrow();
                    Object value = this.luaState.toJavaObject(-1).getOrThrow();
                    consumer.accept(kClass.cast(key), vClass.cast(value));
                    l.pop(1);
                }
                l.pop(1);
            }
            finally {
                l.setTop(top);
            }
            return null;
        });
    }

    public <K, V> Result<Boolean, ? extends Exception> forEach(Class<K> kClass, Class<V> vClass, BiFunction<K, V, Boolean> function) {
        return this.luaState.lock(l -> this.rawForEach(kClass, vClass, function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Result<Boolean, ? extends Exception> rawForEach(Class<K> kClass, Class<V> vClass, BiFunction<K, V, Boolean> function) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        LuaState l = this.getLuaState().getLuaState();
        int top = l.getTop();
        try {
            this.push();
            l.pushNil();
            while (l.next(-2) != 0) {
                Result<Object, ? extends LuaException> keyResult = this.luaState.toJavaObject(-2);
                if (keyResult.isError()) {
                    Result result = keyResult.justCast();
                    return result;
                }
                Result<Object, ? extends LuaException> valueResult = this.luaState.toJavaObject(-1);
                if (valueResult.isError()) {
                    Result result = valueResult.justCast();
                    return result;
                }
                if (function.apply(kClass.cast(keyResult.getValue()), vClass.cast(valueResult.getValue())).booleanValue()) {
                    Result result = Result.success(false);
                    return result;
                }
                l.pop(1);
            }
            l.pop(1);
        }
        finally {
            l.setTop(top);
        }
        return Result.success(true);
    }

    public Result<Void, ? extends Exception> forEach(BiConsumer<Object, Object> consumer) {
        return this.forEach(Object.class, Object.class, consumer);
    }

    public Result<Object, ? extends LuaException> get(Object key) {
        return this.luaState.lock(l -> this.doGet(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Object, ? extends LuaException> doGet(Object key) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        LuaState inner = this.luaState.getLuaState();
        int top = inner.getTop();
        try {
            this.rawPush();
            if (key instanceof LuaObject) {
                ((LuaObject)key).rawPush();
            } else {
                Result<Void, ? extends LuaException> result = this.luaState.pushObjectValue(key);
                if (result.isError()) {
                    Result result2 = result.justCast();
                    return result2;
                }
            }
            inner.getTable(-2);
            Result<Object, ? extends LuaException> result = this.luaState.toJavaObject(-1);
            return result;
        }
        finally {
            inner.setTop(top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Void, ? extends LuaException> put(Object key, Object value) {
        this.luaState.lock();
        try {
            Result<Void, ? extends LuaException> result = this.rawPut(key, value);
            return result;
        }
        finally {
            this.luaState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Void, ? extends LuaException> rawPut(Object key, Object value) {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        LuaState inner = this.luaState.getLuaState();
        int top = inner.getTop();
        try {
            this.rawPush();
            Result result = this.luaState.rawPushObjectValue(key).mapResultValue(it -> this.luaState.rawPushObjectValue(value)).ifSuccessThen(it -> inner.setTable(-3));
            return result;
        }
        finally {
            inner.setTop(top);
        }
    }

    public Result<Void, ? extends LuaException> rawRemove(Object key) {
        return this.rawPut(key, null);
    }

    public Result<Void, ? extends LuaException> remove(Object key) {
        return this.put(key, null);
    }
}

