/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.ILuaStateManager;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStatePluginEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.config.Config;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaStateConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.LuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.PluginLuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaStateManager
implements ILuaStateManager,
Listener {
    private final Config config;
    private final Map<String, ILuaStateEnvInner> envs = new HashMap<String, ILuaStateEnvInner>();
    private final Map<Plugin, ILuaStateEnvInner> pluginEnvs = new HashMap<Plugin, ILuaStateEnvInner>();

    public LuaStateManager(Config config) {
        this.config = config;
    }

    @Override
    public Collection<String> getScriptEnvIds() {
        return this.envs.keySet();
    }

    @Override
    public Collection<ILuaStateEnv> getScriptEnvs() {
        return Collections.unmodifiableCollection(this.envs.values());
    }

    @Override
    public ILuaStatePluginEnv createPluginEnv(@NotNull Plugin plugin) {
        return this.createPluginEnv(plugin, false);
    }

    @Override
    public ILuaStatePluginEnv createPluginEnv(@NotNull Plugin plugin, boolean ignoreAccessLimit) {
        if (plugin == LuaInMinecraftBukkit.instance()) {
            throw new IllegalArgumentException("Cannot create plugin env for LuaInMinecraftBukkit.");
        }
        this.destroyPluginEnv(plugin);
        PluginLuaEnv env = new PluginLuaEnv(ignoreAccessLimit);
        ILuaStateEnvInner inner = env;
        inner.createEnv();
        this.pluginEnvs.put(plugin, inner);
        return env;
    }

    @Override
    public ILuaStatePluginEnv getPluginEnv(@NotNull Plugin plugin) {
        return (ILuaStatePluginEnv)((Object)this.pluginEnvs.get(plugin));
    }

    @Override
    public void destroyPluginEnv(@NotNull Plugin plugin) {
        ILuaStateEnvInner removed = this.pluginEnvs.remove(plugin);
        if (removed != null) {
            removed.close();
        }
    }

    @Override
    @Nullable
    public ILuaStateEnv getEnv(String id) {
        return this.envs.get(id);
    }

    @Override
    public void close() {
        this.envs.values().forEach(ILuaStateEnvInner::close);
        this.envs.clear();
        this.pluginEnvs.values().forEach(ILuaStateEnvInner::close);
        this.pluginEnvs.clear();
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void reloadEnvScript(String id) {
        ILuaStateEnvInner env = this.envs.get(id);
        if (env != null) {
            env.reload();
        }
    }

    @Override
    public void reload(Config config) {
        this.close();
        this.preLoad();
        this.initialization();
    }

    @Override
    public void preLoad() {
        LuaInMinecraftBukkit.instance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)LuaInMinecraftBukkit.instance());
        this.config.getLuaState().forEach((id, conf) -> {
            LuaStateEnv env = new LuaStateEnv((String)id, (LuaStateConfig)conf);
            try {
                env.createEnv();
            }
            catch (Exception e) {
                LuaInMinecraftBukkit.instance().getLogger().warning("Error while initializing lua state env '" + id + "': " + e.getMessage());
                DebugLogger.debug(e);
                return;
            }
            this.envs.put((String)id, env);
        });
    }

    @Override
    public void initialization() {
        this.config.getLuaState().forEach((id, conf) -> this.envs.get(id).initialization());
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.envs.values().forEach(ILuaStateEnvInner::initialization);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        this.destroyPluginEnv(event.getPlugin());
    }

    @Override
    public Config getConfig() {
        return this.config;
    }
}

