/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;

public class UpdateChecker {
    private static final String RELEASE_URL = "https://api.github.com/repos/SmileYik/LuaInMinecraftBukkitII/releases";

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Node> getReleases() {
        try {
            URL url = new URL(RELEASE_URL);
            URLConnection conn = url.openConnection();
            try (InputStream inputStream = conn.getInputStream();){
                List list;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    Gson gson = new Gson();
                    list = (List)gson.fromJson((Reader)reader, new TypeToken<List<Node>>(){}.getType());
                }
                return list;
            }
        }
        catch (Exception e) {
            DebugLogger.debug("Error while getting releases");
            DebugLogger.debug(e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCurrentBuildTimestamp() {
        try (InputStream manifestStream = UpdateChecker.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            if (manifestStream == null) {
                long l2 = 0L;
                return l2;
            }
            Manifest manifest = new Manifest(manifestStream);
            Attributes attributes = manifest.getMainAttributes();
            String value = attributes.getValue("Build-Timestamp");
            long l = Long.parseLong(value);
            return l;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates(Logger logger) {
        logger.info("Checking for updates...");
        long currentBuildTimestamp = this.getCurrentBuildTimestamp();
        if (currentBuildTimestamp == 0L) {
            logger.warning("Cannot determine current build timestamp, failed to check for updates.");
            return;
        }
        Node target = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<List> submit = executor.submit(this::getReleases);
            List releases = submit.get(60L, TimeUnit.SECONDS);
            for (Node node : releases) {
                if (node.isDraft() || node.isPrerelease() || node.getPublishedTimestamp() <= currentBuildTimestamp) continue;
                target = node;
                break;
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            logger.warning("Error checking for updates. " + String.valueOf(e));
            DebugLogger.debug(e);
            return;
        }
        finally {
            executor.shutdownNow();
        }
        Object msg = target == null ? "This is the newest version" : "Found new release tag `" + target.getTag_name() + "`, published at " + target.getPublished_at() + ": " + target.html_url + "\n" + target.getName() + "\n" + target.getBody() + "\n";
        logger.info((String)msg);
    }

    public static final class Node {
        private String body;
        private String tag_name;
        private String name;
        private boolean draft;
        private boolean prerelease;
        private String published_at;
        private String html_url;

        public long getPublishedTimestamp() {
            try {
                Instant instant = Instant.parse(this.published_at);
                return instant.toEpochMilli();
            }
            catch (DateTimeParseException e) {
                return 0L;
            }
        }

        public String getBody() {
            return this.body;
        }

        public String getTag_name() {
            return this.tag_name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public boolean isPrerelease() {
            return this.prerelease;
        }

        public String getPublished_at() {
            return this.published_at;
        }

        public String getHtml_url() {
            return this.html_url;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setTag_name(String tag_name) {
            this.tag_name = tag_name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public void setPrerelease(boolean prerelease) {
            this.prerelease = prerelease;
        }

        public void setPublished_at(String published_at) {
            this.published_at = published_at;
        }

        public void setHtml_url(String html_url) {
            this.html_url = html_url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (this.isDraft() != other.isDraft()) {
                return false;
            }
            if (this.isPrerelease() != other.isPrerelease()) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$tag_name = this.getTag_name();
            String other$tag_name = other.getTag_name();
            if (this$tag_name == null ? other$tag_name != null : !this$tag_name.equals(other$tag_name)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$published_at = this.getPublished_at();
            String other$published_at = other.getPublished_at();
            if (this$published_at == null ? other$published_at != null : !this$published_at.equals(other$published_at)) {
                return false;
            }
            String this$html_url = this.getHtml_url();
            String other$html_url = other.getHtml_url();
            return !(this$html_url == null ? other$html_url != null : !this$html_url.equals(other$html_url));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDraft() ? 79 : 97);
            result = result * 59 + (this.isPrerelease() ? 79 : 97);
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            String $tag_name = this.getTag_name();
            result = result * 59 + ($tag_name == null ? 43 : $tag_name.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $published_at = this.getPublished_at();
            result = result * 59 + ($published_at == null ? 43 : $published_at.hashCode());
            String $html_url = this.getHtml_url();
            result = result * 59 + ($html_url == null ? 43 : $html_url.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateChecker.Node(body=" + this.getBody() + ", tag_name=" + this.getTag_name() + ", name=" + this.getName() + ", draft=" + this.isDraft() + ", prerelease=" + this.isPrerelease() + ", published_at=" + this.getPublished_at() + ", html_url=" + this.getHtml_url() + ")";
        }
    }
}

