/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public interface LuaIOHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferAndClose(@NotNull InputStream inputStream, @NotNull OutputStream outputStream, int bufferSize) throws IOException {
        try {
            LuaIOHelper.transfer(inputStream, outputStream, bufferSize);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void transfer(@NotNull InputStream inputStream, @NotNull OutputStream outputStream, int bufferSize) throws IOException {
        int bytesRead;
        BufferedInputStream input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        BufferedOutputStream output = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        output.flush();
    }

    public static byte[] readBytes(@NotNull InputStream inputStream, int bufferSize) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            LuaIOHelper.transfer(inputStream, output, bufferSize);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static void writeBytes(@NotNull OutputStream outputStream, byte[] bytes) throws IOException {
        outputStream.write(bytes);
        outputStream.flush();
    }
}

