/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class NativeLibraryConfig {
    private String[] urls;
    private Map<String, Map<String, Map<String, String[]>>> files;
    private Map<String, Map<String, Map<String, String[]>>> modules;

    public Collection<String> systems() {
        return this.files.keySet();
    }

    public Collection<String> architectures(String system) {
        return this.files.getOrDefault(system, Collections.emptyMap()).keySet();
    }

    public Collection<String> versions(String system, String architecture) {
        return this.files.getOrDefault(system, Collections.emptyMap()).getOrDefault(architecture, Collections.emptyMap()).keySet();
    }

    @Nullable
    public String[] version(String system, String architecture, String version) {
        return (String[])this.files.getOrDefault(system, Collections.emptyMap()).getOrDefault(architecture, Collections.emptyMap()).get(version);
    }

    public Collection<String> availableModules(String system, String architecture) {
        return this.modules.getOrDefault(system, Collections.emptyMap()).getOrDefault(architecture, Collections.emptyMap()).keySet();
    }

    @Nullable
    public String[] module(String system, String architecture, String module) {
        return (String[])this.modules.getOrDefault(system, Collections.emptyMap()).getOrDefault(architecture, Collections.emptyMap()).get(module);
    }

    public String[] getUrls() {
        return this.urls;
    }

    public Map<String, Map<String, Map<String, String[]>>> getFiles() {
        return this.files;
    }

    public Map<String, Map<String, Map<String, String[]>>> getModules() {
        return this.modules;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public void setFiles(Map<String, Map<String, Map<String, String[]>>> files) {
        this.files = files;
    }

    public void setModules(Map<String, Map<String, Map<String, String[]>>> modules) {
        this.modules = modules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativeLibraryConfig)) {
            return false;
        }
        NativeLibraryConfig other = (NativeLibraryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUrls(), other.getUrls())) {
            return false;
        }
        Map<String, Map<String, Map<String, String[]>>> this$files = this.getFiles();
        Map<String, Map<String, Map<String, String[]>>> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Map<String, Map<String, Map<String, String[]>>> this$modules = this.getModules();
        Map<String, Map<String, Map<String, String[]>>> other$modules = other.getModules();
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NativeLibraryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getUrls());
        Map<String, Map<String, Map<String, String[]>>> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Map<String, Map<String, Map<String, String[]>>> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    public String toString() {
        return "NativeLibraryConfig(urls=" + Arrays.deepToString(this.getUrls()) + ", files=" + String.valueOf(this.getFiles()) + ", modules=" + String.valueOf(this.getModules()) + ")";
    }
}

