/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState;

import java.util.Arrays;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.LuaFunction;

public class UnsafeLuaCallable
extends LuaFunction {
    protected UnsafeLuaCallable(LuaStateFacade L, int index) {
        super(L, index);
    }

    public static ILuaCallable of(ILuaCallable luaCallable) {
        LuaStateFacade facade = luaCallable.getLuaState();
        facade.lock();
        try {
            LuaObject innerObject = (LuaObject)((Object)luaCallable);
            try {
                innerObject.rawPush();
                UnsafeLuaCallable unsafeLuaCallable = new UnsafeLuaCallable(facade, -1);
                if (innerObject != null) {
                    innerObject.close();
                }
                return unsafeLuaCallable;
            }
            catch (Throwable throwable) {
                if (innerObject != null) {
                    try {
                        innerObject.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            facade.unlock();
        }
    }

    @Override
    public Result<Object, ? extends LuaException> call(Object ... args) {
        DebugLogger.debug(ele -> DebugLogger.debug(ele, "[Unsafe] LuaState call: %s", Arrays.toString(args)));
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        return this.pcall(args, 1).mapValue(it -> it[0]);
    }

    @Override
    public Result<Object[], ? extends LuaException> call(int nres, Object ... args) {
        DebugLogger.debug(ele -> DebugLogger.debug(ele, "[Unsafe] LuaState call #%d: %s", nres, Arrays.toString(args)));
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed!"));
        }
        return this.pcall(args, nres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<Object[], ? extends LuaException> pcall(Object[] args, int _nres) {
        LuaState state = this.luaState.getLuaState();
        UnsafeLuaCallable innerObject = this;
        int top = state.getTop();
        int nargs = 0;
        try {
            innerObject.rawPush();
            if (args != null) {
                nargs = args.length;
                for (Object obj : args) {
                    Result<Void, ? extends LuaException> pushResult = this.luaState.rawPushObjectValue(obj);
                    if (!pushResult.isError()) continue;
                    Result result = pushResult.justCast();
                    return result;
                }
            }
            Result result = this.pcall(nargs, _nres, 0).mapResultValue(v -> {
                int nres = _nres;
                int currentTop = this.luaState.getTop();
                if (nres == -1) {
                    nres = currentTop - top;
                }
                if (currentTop - top < nres) {
                    return Result.failure(new LuaException("Invalid Number of Results .")).justCast();
                }
                Object[] res = new Object[nres];
                for (int i = nres - 1; i >= 0; --i) {
                    Result<Object, ? extends LuaException> ret = this.luaState.rawToJavaObject(-1);
                    if (ret.isError()) {
                        return ret.justCast();
                    }
                    res[i] = ret.getValue();
                    this.luaState.pop(1);
                }
                return Result.success(res);
            });
            return result;
        }
        finally {
            this.luaState.setTop(top);
        }
    }

    private Result<Void, LuaException> pcall(int nArgs, int nResults, int errFunc) {
        LuaState luaState = this.getLuaState().getLuaState();
        int exp = luaState.pcall(nArgs, nResults, errFunc);
        if (exp != 0) {
            String err = this.getErrorMessage(exp);
            return Result.failure(new LuaException(err), err);
        }
        return Result.success();
    }

    protected String getErrorMessage(int err) {
        LuaState luaState = this.getLuaState().getLuaState();
        String ret = null;
        switch (err) {
            case 2: {
                ret = "Runtime error. ";
                break;
            }
            case 4: {
                ret = "Memory allocation error. ";
                break;
            }
            case 5: {
                ret = "Error while running the error handler function.";
                break;
            }
        }
        if (luaState.isString(-1)) {
            ret = ret == null ? luaState.toString(-1) : ret + luaState.toString(-1);
        }
        return ret;
    }
}

