/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.autoReload;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.config.AutoReloadConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaInitConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaStateConfig;

public class AutoReloadManager
implements Runnable {
    private final String envId;
    private final Map<File, Long> files;
    private final ScheduledExecutorService scheduler;

    public AutoReloadManager(String envId, File rootDir, LuaStateConfig luaStateConfig) {
        LuaInitConfig[] initialization;
        this.envId = envId;
        HashMap<File, Long> files = new HashMap<File, Long>();
        AutoReloadConfig autoReloadConfig = luaStateConfig.getAutoReload();
        for (LuaInitConfig luaInitConfig : initialization = luaStateConfig.getInitialization()) {
            if (Arrays.stream(autoReloadConfig.getBlacklist()).anyMatch(it -> Objects.equals(it, luaInitConfig.getFile()))) continue;
            File file = new File(rootDir, luaInitConfig.getFile());
            long lastModified = file.lastModified();
            if (lastModified <= 0L) {
                lastModified = System.currentTimeMillis();
            }
            files.put(file, lastModified);
        }
        this.files = files;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this, autoReloadConfig.getFrequency(), autoReloadConfig.getFrequency(), TimeUnit.MILLISECONDS);
        LuaInMinecraftBukkit.logger().info(String.format("[LuaEnv %s] Enabled auto-reload.", envId));
    }

    public void shutdown() {
        LuaInMinecraftBukkit.logger().info(String.format("[LuaEnv %s] Shutdown auto-reload.", this.envId));
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void run() {
        boolean needReload = false;
        for (Map.Entry<File, Long> entry : this.files.entrySet()) {
            File file = entry.getKey();
            Long lastModified = entry.getValue();
            if (!file.exists()) continue;
            long l = file.lastModified();
            if (l <= 0L) {
                return;
            }
            if (l <= lastModified) continue;
            needReload = true;
            this.files.put(file, l);
            LuaInMinecraftBukkit.logger().info(String.format("[LuaEnv %s] Detected script file modification: %s", this.envId, file.getName()));
        }
        if (needReload) {
            LuaInMinecraftBukkit.logger().info(String.format("[LuaEnv %s] Some file be modified, reloading lua environment", this.envId));
            LuaInMinecraftBukkit.instance().getLuaStateManager().reloadEnvScript(this.envId);
        }
    }
}

