/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.command;

import java.io.InvalidClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.ReflectUtil;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandMessageFormat;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandTranslator;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.type.ILuaCallable;

public class LuaCommandRegister {
    public static final CommandTranslator DEFAULT_TRANSLATOR = (msg, obj) -> msg;
    public static final CommandMessageFormat DEFAULT_FORMAT = new CommandMessageFormat(){

        @Override
        public String notFound() {
            return "\u6307\u4ee4\u672a\u627e\u5230!";
        }

        @Override
        public String notFound(String suggestCommandHelp) {
            return "\u6307\u4ee4\u672a\u627e\u5230, \u731c\u4f60\u53ef\u80fd\u60f3\u6267\u884c: \n" + suggestCommandHelp;
        }

        @Override
        public String commandError() {
            return "\u6307\u4ee4\u672a\u627e\u5230!";
        }

        @Override
        public String commandError(String suggestCommandHelp) {
            return "\u6307\u4ee4\u672a\u627e\u5230, \u731c\u4f60\u53ef\u80fd\u60f3\u6267\u884c: \n" + suggestCommandHelp;
        }

        @Override
        public String notPlayer() {
            return "\u53ea\u80fd\u73a9\u5bb6\u6267\u884c\u8fd9\u4e2a\u6307\u4ee4!";
        }

        @Override
        public String notPermission() {
            return "\u6307\u4ee4\u4e0d\u5b58\u5728!";
        }
    };
    private static final Field COMMAND_MAP_FIELD;
    private static final Constructor<PluginCommand> PLUGIN_COMMAND_CONSTRUCTOR;

    public static CommandService register(String rootCommand, String[] aliases, Class<?> ... classes) throws InvalidClassException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        PluginCommand pluginCommand = plugin.getCommand(rootCommand);
        CommandMap commandMap = (CommandMap)COMMAND_MAP_FIELD.get(plugin.getServer());
        if (pluginCommand == null) {
            pluginCommand = PLUGIN_COMMAND_CONSTRUCTOR.newInstance(new Object[]{rootCommand, plugin});
        }
        if (aliases != null) {
            pluginCommand.setAliases(Arrays.asList(aliases));
        }
        commandMap.register(rootCommand, rootCommand, (Command)pluginCommand);
        CommandService commandService = CommandService.newInstance(DEFAULT_TRANSLATOR, DEFAULT_FORMAT, classes);
        try {
            commandService.registerToBukkit((Plugin)plugin);
        }
        catch (NullPointerException e) {
            DebugLogger.debug("Failed register command to bukkit, try manual register: %s", e.getMessage());
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(rootCommand);
            commands.addAll(pluginCommand.getAliases());
            Set<PluginCommand> collect = commands.stream().map(arg_0 -> ((LuaInMinecraftBukkit)plugin).getCommand(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            collect.add(pluginCommand);
            collect.forEach(command -> {
                command.setExecutor((CommandExecutor)commandService);
                command.setTabCompleter((TabCompleter)commandService);
            });
        }
        return commandService;
    }

    public static void register(String rootCommand, ILuaCallable callable) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        LuaCommandRegister.register(rootCommand, null, callable);
    }

    public static void register(String rootCommand, String[] aliases, ILuaCallable callable) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        PluginCommand pluginCommand = plugin.getCommand(rootCommand);
        CommandMap commandMap = (CommandMap)COMMAND_MAP_FIELD.get(plugin.getServer());
        if (pluginCommand == null) {
            pluginCommand = PLUGIN_COMMAND_CONSTRUCTOR.newInstance(new Object[]{rootCommand, plugin});
        }
        if (aliases != null) {
            pluginCommand.setAliases(Arrays.asList(aliases));
        }
        commandMap.register(rootCommand, rootCommand, (Command)pluginCommand);
        pluginCommand.setExecutor((sender, command, label, args) -> {
            try {
                return (Boolean)callable.call(sender, command, label, args).getOrThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        Server server = LuaInMinecraftBukkit.instance().getServer();
        Field commandMapField = ReflectUtil.findFieldByType(server.getClass(), CommandMap.class);
        if (commandMapField == null) {
            throw new RuntimeException("Could not find CommandMap");
        }
        commandMapField.setAccessible(true);
        COMMAND_MAP_FIELD = commandMapField;
        try {
            PLUGIN_COMMAND_CONSTRUCTOR = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            PLUGIN_COMMAND_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find PluginCommand constructor", e);
        }
    }
}

