/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.event;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.ILuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.ILuaEventListenerBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.LuaEventListenerProperty;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.LuaUnregisteredListener;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.ByteBuddy;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.description.annotation.AnnotationDescription;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.description.modifier.Visibility;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.dynamic.DynamicType;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.implementation.MethodCall;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.implementation.MethodDelegation;
import org.eu.smileyik.luaInMinecraftBukkitII.bytebuddy.matcher.ElementMatchers;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.event.LuaEventHandler;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.event.LuaEventListener;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.LuaTable2Object;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.LuaTable;
import org.jetbrains.annotations.NotNull;

public class LuaEventListenerBuilder
implements ILuaEventListenerBuilder {
    private static final String[] EVENT_CLASS_PREFIX = new String[]{"org.bukkit.event.", "org.bukkit.event.player.", "org.bukkit.event.event.", "org.bukkit.event.world.", "org.bukkit.event.inventory."};
    private final List<EventConfig> eventConfigs = new LinkedList<EventConfig>();
    private final ILuaEnv luaEnv;

    public LuaEventListenerBuilder(ILuaEnv luaEnv) {
        this.luaEnv = luaEnv;
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, null, null);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull EventPriority eventPriority, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, eventPriority, null);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull String eventPriority, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        EventPriority priority = EventPriority.valueOf((String)eventPriority.toUpperCase());
        return this.subscribe(eventClassName, priority, closure);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull EventPriority eventPriority, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, eventPriority, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull String eventPriority, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        EventPriority priority = EventPriority.valueOf((String)eventPriority.toUpperCase());
        return this.subscribe(eventClassName, priority, ignoreCancelled, closure);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, null, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull LuaTable table) throws Exception {
        LuaEventListenerProperty property = LuaTable2Object.covert(table, LuaEventListenerProperty.class).getOrThrow();
        if (property.getEvent() == null) {
            throw new IllegalArgumentException("'event' property must not be nil'");
        }
        if (property.getHandler() == null) {
            throw new IllegalArgumentException("'handler' property must not be nil'");
        }
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(property.getEvent());
        ILuaCallable callable = property.getHandler();
        boolean ignoreCancelled = property.isIgnoreCancelled();
        EventPriority priority = property.getPriority() == null ? null : EventPriority.valueOf((String)property.getPriority());
        return this.doSubscribe(eventClass, callable, priority, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribes(LuaTable ... tables) throws Exception {
        for (LuaTable t : tables) {
            this.subscribe(t);
        }
        return this;
    }

    private ILuaEventListenerBuilder doSubscribe(Class<?> eventClass, ILuaCallable closure, EventPriority eventPriority, Boolean ignoreCancelled) {
        this.eventConfigs.add(new EventConfig(eventClass, closure, eventPriority, ignoreCancelled));
        return this;
    }

    @Override
    public LuaUnregisteredListener build() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        int count = 0;
        DynamicType.Builder.MethodDefinition<LuaEventListener> byteBuddy = new ByteBuddy().subclass(LuaEventListener.class).constructor(ElementMatchers.any()).intercept(MethodCall.invoke(LuaEventListener.class.getConstructor(LuaEventHandler.class)).withArgument(0));
        HashMap<String, ILuaCallable> callableMap = new HashMap<String, ILuaCallable>();
        LuaEventHandler luaEventHandler = new LuaEventHandler(callableMap);
        for (EventConfig eventConfig : this.eventConfigs) {
            AnnotationDescription.Builder builder = AnnotationDescription.Builder.ofType(EventHandler.class);
            if (eventConfig.eventPriority != null) {
                builder = builder.define("priority", (Enum<?>)eventConfig.eventPriority);
            }
            if (eventConfig.ignoreCancelled != null) {
                builder = builder.define("ignoreCancelled", eventConfig.ignoreCancelled);
            }
            AnnotationDescription eventHandler = builder.build();
            String methodName = String.format("on%s%d", eventConfig.eventClass.getSimpleName(), count++);
            callableMap.put(methodName, eventConfig.closure);
            byteBuddy = byteBuddy.defineMethod(methodName, Void.TYPE, Visibility.PUBLIC).withParameters(eventConfig.eventClass).intercept(MethodDelegation.to(luaEventHandler)).annotateMethod(eventHandler);
        }
        try {
            LuaUnregisteredListener luaUnregisteredListener;
            block14: {
                DynamicType.Unloaded made = byteBuddy.make();
                try {
                    Listener listener = (Listener)made.load(LuaInMinecraftBukkit.instance().classLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(LuaEventHandler.class).newInstance(luaEventHandler);
                    luaUnregisteredListener = new LuaUnregisteredListener(this.luaEnv, listener);
                    if (made == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (made != null) {
                            try {
                                made.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                made.close();
            }
            return luaUnregisteredListener;
        }
        finally {
            this.eventConfigs.clear();
        }
    }

    @NotNull
    private static Class<?> findEventClass(String eventClassName) throws ClassNotFoundException {
        Class<?> eventClass;
        block5: {
            eventClass = null;
            try {
                eventClass = Class.forName(eventClassName);
            }
            catch (ClassNotFoundException e) {
                for (String prefix : EVENT_CLASS_PREFIX) {
                    try {
                        eventClass = Class.forName(prefix + eventClassName);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (eventClass != null) break block5;
                throw e;
            }
        }
        return eventClass;
    }

    public static class EventConfig {
        private final Class<?> eventClass;
        private final ILuaCallable closure;
        private final EventPriority eventPriority;
        private final Boolean ignoreCancelled;

        public EventConfig(Class<?> eventClass, ILuaCallable closure, EventPriority eventPriority, Boolean ignoreCancelled) {
            this.eventClass = eventClass;
            this.closure = closure;
            this.eventPriority = eventPriority;
            this.ignoreCancelled = ignoreCancelled;
        }

        public Class<?> getEventClass() {
            return this.eventClass;
        }

        public ILuaCallable getClosure() {
            return this.closure;
        }

        public EventPriority getEventPriority() {
            return this.eventPriority;
        }

        public Boolean getIgnoreCancelled() {
            return this.ignoreCancelled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventConfig)) {
                return false;
            }
            EventConfig other = (EventConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$ignoreCancelled = this.getIgnoreCancelled();
            Boolean other$ignoreCancelled = other.getIgnoreCancelled();
            if (this$ignoreCancelled == null ? other$ignoreCancelled != null : !((Object)this$ignoreCancelled).equals(other$ignoreCancelled)) {
                return false;
            }
            Class<?> this$eventClass = this.getEventClass();
            Class<?> other$eventClass = other.getEventClass();
            if (this$eventClass == null ? other$eventClass != null : !this$eventClass.equals(other$eventClass)) {
                return false;
            }
            ILuaCallable this$closure = this.getClosure();
            ILuaCallable other$closure = other.getClosure();
            if (this$closure == null ? other$closure != null : !this$closure.equals(other$closure)) {
                return false;
            }
            EventPriority this$eventPriority = this.getEventPriority();
            EventPriority other$eventPriority = other.getEventPriority();
            return !(this$eventPriority == null ? other$eventPriority != null : !this$eventPriority.equals(other$eventPriority));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $ignoreCancelled = this.getIgnoreCancelled();
            result = result * 59 + ($ignoreCancelled == null ? 43 : ((Object)$ignoreCancelled).hashCode());
            Class<?> $eventClass = this.getEventClass();
            result = result * 59 + ($eventClass == null ? 43 : $eventClass.hashCode());
            ILuaCallable $closure = this.getClosure();
            result = result * 59 + ($closure == null ? 43 : $closure.hashCode());
            EventPriority $eventPriority = this.getEventPriority();
            result = result * 59 + ($eventPriority == null ? 43 : $eventPriority.hashCode());
            return result;
        }

        public String toString() {
            return "LuaEventListenerBuilder.EventConfig(eventClass=" + String.valueOf(this.getEventClass()) + ", closure=" + String.valueOf(this.getClosure()) + ", eventPriority=" + String.valueOf(this.getEventPriority()) + ", ignoreCancelled=" + this.getIgnoreCancelled() + ")";
        }
    }
}

