/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage;

import com.google.gson.Gson;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.PluginManager;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuacageConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacage;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacageRepository;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageCommonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageJsonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageLuaMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageRepository;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageRepositoryBundle;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.LuaTable2Object;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luaInMinecraftBukkitII.util.HashUtil;
import org.eu.smileyik.luaInMinecraftBukkitII.util.StaticResourceDownloader;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.LuaTable;
import org.jetbrains.annotations.NotNull;

public class Luacage
implements ILuacageRepository,
ILuacage {
    public static final String PACKAGE_META_NAME = "luacage.json";
    public static final String PACKAGE_DIR_NAME = "packages";
    public static final String PACKAGE_LUA_NAME = "package.lua";
    private static final ReentrantLock REPO_LOCK = new ReentrantLock();
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static ScheduledFuture<ILuacageRepository> repositoryCleanFuture = null;
    private static ILuacageRepository repository;
    private final ILuaStateEnvInner env;
    private final LuacageConfig config;
    private final File baseDir;
    private final Logger logger;
    private final Map<String, LuacageLuaMeta> loadedPackages = new HashMap<String, LuacageLuaMeta>();
    private final Function<List<LuacageJsonMeta>, LuacageJsonMeta> DEFAULT_ON_CONFLICT;
    private boolean loaded = false;

    public Luacage(ILuaStateEnvInner env, LuacageConfig config, File baseDir, Logger logger) {
        this.env = env;
        this.config = config;
        this.baseDir = baseDir;
        this.logger = logger;
        this.DEFAULT_ON_CONFLICT = packages -> {
            HashMap<String, LuacageJsonMeta> packageMap = new HashMap<String, LuacageJsonMeta>();
            for (LuacageJsonMeta dependency : packages) {
                packageMap.put(dependency.getSource(), dependency);
            }
            for (LuacageConfig.Source source : config.getSources()) {
                if (!packageMap.containsKey(source.getName())) continue;
                return (LuacageJsonMeta)packageMap.get(source.getName());
            }
            return null;
        };
    }

    /*
     * Exception decompiling
     */
    protected ILuacageRepository getRepository(String name, String baseUrl, boolean noCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized ILuacageRepository getRepository(boolean noCache) {
        if (noCache) {
            if (repositoryCleanFuture != null) {
                repositoryCleanFuture.cancel(false);
            }
            repository = null;
        }
        if (repository == null) {
            LuacageConfig.Source[] sources = this.config.getSources();
            LuacageRepositoryBundle bundle = new LuacageRepositoryBundle(sources.length);
            for (LuacageConfig.Source source : sources) {
                ILuacageRepository repo = this.getRepository(source.getName(), source.getUrl(), noCache);
                if (repo == null) continue;
                bundle.add(repo);
            }
            repository = bundle;
        }
        if (repositoryCleanFuture != null) {
            repositoryCleanFuture.cancel(false);
        }
        repositoryCleanFuture = scheduler.schedule(() -> {
            repository = null;
            return null;
        }, 5L, TimeUnit.MINUTES);
        return repository;
    }

    protected ILuacageRepository getRepository() {
        return this.getRepository(false);
    }

    protected String getRepositoryCacheFileName(String name) {
        return String.format("%s-luacages.json", name);
    }

    protected String getBaseUrl(@NotNull LuacageJsonMeta meta) {
        for (LuacageConfig.Source source : this.config.getSources()) {
            if (!source.getName().equals(meta.getSource())) continue;
            return source.getUrl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doInstallPackage(@NotNull LuacageJsonMeta meta, boolean force) {
        File installDir = this.getInstallDir(meta);
        REPO_LOCK.lock();
        try {
            if (force) {
                this.deleteFolder(installDir);
            } else if (installDir.exists() && new File(installDir, PACKAGE_LUA_NAME).exists()) {
                boolean bl = true;
                return bl;
            }
            String[] files = meta.getFiles();
            String[] hashes = meta.getHashes();
            String baseUrl = this.getBaseUrl(meta);
            for (int i = 0; i < files.length; ++i) {
                String path = files[i];
                String hash = hashes[i];
                String url = baseUrl + "packages/" + meta.getName() + path;
                File file = new File(installDir, path);
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.logger.info("Downloading package '" + meta.getName() + "' file '" + path + "' from " + url);
                String downloadHash = StaticResourceDownloader.download(url, 8192, 60, file);
                if (HashUtil.isEqualsHashString(hash, downloadHash)) continue;
                this.deleteFolder(installDir);
                this.logger.warning(String.format("File '%s' hash mismatch, expected '%s', got '%s'. Attempt to update the database source index.", path, hash, downloadHash));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.deleteFolder(installDir);
            this.logger.warning("Luacage install failed, attempt to update the database source index: " + String.valueOf(e));
            DebugLogger.debug(e);
            boolean bl = false;
            return bl;
        }
        finally {
            REPO_LOCK.unlock();
        }
        return true;
    }

    protected Result<List<LuacageJsonMeta>, Collection<LuacageJsonMeta>> sort(List<LuacageJsonMeta> list) {
        HashMap<String, LuacageJsonMeta> map = new HashMap<String, LuacageJsonMeta>();
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        for (LuacageJsonMeta meta : list) {
            map.put(meta.getName(), meta);
            inDegree.putIfAbsent(meta.getName(), 0);
            for (String depend : meta.getDependPackages()) {
                inDegree.put(depend, inDegree.getOrDefault(depend, 0) + 1);
            }
        }
        ArrayList<LuacageJsonMeta> sorted = new ArrayList<LuacageJsonMeta>();
        LinkedList<String> queue = new LinkedList<String>();
        inDegree.forEach((k, v) -> {
            if (v == 0) {
                queue.add((String)k);
            }
        });
        while (!queue.isEmpty()) {
            String name = (String)queue.poll();
            LuacageJsonMeta meta = (LuacageJsonMeta)map.get(name);
            sorted.add(meta);
            for (String depend : meta.getDependPackages()) {
                int in = inDegree.getOrDefault(depend, 0) - 1;
                inDegree.put(depend, in);
                if (in != 0) continue;
                queue.add(depend);
            }
        }
        if (sorted.size() != map.size()) {
            HashSet circle = new HashSet(map.values());
            sorted.forEach(circle::remove);
            return Result.failure(circle);
        }
        return Result.success(sorted);
    }

    protected Result<Void, Collection<LuacageJsonMeta>> updateInstalledPackagesJson(List<LuacageJsonMeta> list) throws IOException {
        Result<List<LuacageJsonMeta>, Collection<LuacageJsonMeta>> result = this.sort(list);
        if (result.isError()) {
            return result.justCast();
        }
        List<LuacageJsonMeta> sorted = result.getValue();
        String json = new Gson().toJson(sorted);
        File file = new File(this.env.getRootDir(), String.format("%s.installed.luacage.json", this.env.getId()));
        Files.write(file.toPath(), json.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return Result.success();
    }

    @Override
    public List<LuacageJsonMeta> getPackages() {
        return this.getRepository().getPackages();
    }

    @Override
    @NotNull
    public List<LuacageJsonMeta> findPackages(String packageName, String desc, short searchType) {
        return this.getRepository().findPackages(packageName, desc, searchType);
    }

    @Override
    public void cleanCache() {
        this.getRepository(true);
    }

    @Override
    public void update() {
        this.getRepository(true);
    }

    @Override
    public synchronized void installPackage(@NotNull File installDir) {
        LuacageLuaMeta meta = this.loadPackageMeta(this.env.getLuaState(), installDir, installDir.getName());
        if (meta == null) {
            return;
        }
        List<LuacageJsonMeta> depends = this.findDepends(meta);
        List<LuacageJsonMeta> installedPackages = this.installedPackages();
        Set installedNames = installedPackages.parallelStream().map(LuacageCommonMeta::getName).collect(Collectors.toSet());
        depends = depends.parallelStream().filter(it -> !installedNames.contains(it.getName())).collect(Collectors.toList());
        for (LuacageJsonMeta m : depends) {
            this.installPackage(m, false, false, this.DEFAULT_ON_CONFLICT);
        }
        installedPackages = this.installedPackages();
        LuacageJsonMeta jsonMeta = meta.toJsonMeta();
        jsonMeta.setManual(true);
        jsonMeta.setSource("local");
        installedPackages.add(jsonMeta);
        try {
            this.updateInstalledPackagesJson(installedPackages);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void installPackage(@NotNull LuacageJsonMeta meta, boolean force) {
        this.installPackage(meta, force, this.DEFAULT_ON_CONFLICT);
    }

    @Override
    public synchronized void installPackage(@NotNull LuacageJsonMeta meta, boolean force, @NotNull Function<List<LuacageJsonMeta>, LuacageJsonMeta> onConflict) {
        this.installPackage(meta, force, true, onConflict);
    }

    protected synchronized void installPackage(@NotNull LuacageJsonMeta meta, boolean force, boolean manual, @NotNull Function<List<LuacageJsonMeta>, LuacageJsonMeta> onConflict) {
        List<LuacageJsonMeta> installedPackages = this.installedPackages();
        Set installedNames = installedPackages.parallelStream().map(LuacageCommonMeta::getName).collect(Collectors.toSet());
        List<LuacageJsonMeta> waitInstallPackages = this.findDepends(meta, onConflict);
        waitInstallPackages.add(meta);
        meta.setManual(manual);
        Result<List<LuacageJsonMeta>, Collection<LuacageJsonMeta>> sortResult = this.sort(waitInstallPackages);
        if (sortResult.isError()) {
            throw new RuntimeException(String.format("Package '%s' include circular dependency: %s", meta.getName(), sortResult.getValue()));
        }
        List<LuacageJsonMeta> pkgs = sortResult.getValue();
        ArrayList<LuacageJsonMeta> installed = new ArrayList<LuacageJsonMeta>();
        boolean failed = false;
        for (LuacageJsonMeta pkgMeta : pkgs) {
            if (installedNames.contains(pkgMeta.getName())) continue;
            installed.add(pkgMeta);
            if (this.doInstallPackage(pkgMeta, force && pkgMeta.getName().equals(meta.getName()))) continue;
            failed = true;
            break;
        }
        if (!failed) {
            installed.addAll(installedPackages);
            try {
                Result<Void, Collection<LuacageJsonMeta>> updateResult = this.updateInstalledPackagesJson(installed);
                if (updateResult.isError()) {
                    throw new RuntimeException(String.format("Package '%s' include circular dependency: %s", meta.getName(), sortResult.getValue()));
                }
            }
            catch (IOException e) {
                failed = true;
            }
        }
        if (failed) {
            throw new RuntimeException(String.format("Package '%s' install failure.", meta.getName()));
        }
    }

    @Override
    public List<LuacageJsonMeta> findDepends(@NotNull LuacageCommonMeta meta) {
        return this.findDepends(meta, this.DEFAULT_ON_CONFLICT);
    }

    @Override
    public List<LuacageJsonMeta> findDepends(@NotNull LuacageCommonMeta meta, @NotNull Function<List<LuacageJsonMeta>, LuacageJsonMeta> onConflict) {
        ArrayList<LuacageJsonMeta> depends = new ArrayList<LuacageJsonMeta>();
        ArrayList<String> notfound = new ArrayList<String>();
        LinkedList<LuacageCommonMeta> queue = new LinkedList<LuacageCommonMeta>();
        queue.add(meta);
        while (!queue.isEmpty()) {
            LuacageCommonMeta dependency = (LuacageCommonMeta)queue.poll();
            String[] dependPackages = dependency.getDependPackages();
            ILuacageRepository repo = this.getRepository();
            if (dependPackages == null) continue;
            for (String dependPackage : dependPackages) {
                List<LuacageJsonMeta> packages = repo.findPackages(dependPackage, null, (short)3);
                LuacageJsonMeta pickup = packages.isEmpty() ? null : (packages.size() == 1 ? packages.get(0) : onConflict.apply(packages));
                if (pickup == null) {
                    notfound.add(dependPackage);
                    continue;
                }
                depends.add(pickup);
                queue.add(pickup);
            }
        }
        if (!notfound.isEmpty()) {
            throw new RuntimeException("Dependencies not found: " + String.valueOf(notfound));
        }
        return depends;
    }

    @Override
    public synchronized List<LuacageJsonMeta> installedPackages() {
        File file = new File(this.env.getRootDir(), String.format("%s.installed.luacage.json", this.env.getId()));
        if (!file.exists()) {
            return Collections.emptyList();
        }
        try {
            return new ArrayList<LuacageJsonMeta>(new LuacageRepository(file).getPackages());
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public synchronized boolean uninstallPackage(@NotNull LuacageJsonMeta meta) {
        List<LuacageJsonMeta> installedPackages = this.installedPackages();
        for (LuacageJsonMeta installedPackage : installedPackages) {
            if (installedPackage.getName().equals(meta.getName())) {
                meta = installedPackage;
                continue;
            }
            for (String depend : installedPackage.getDependPackages()) {
                if (!Objects.equals(depend, meta.getName())) continue;
                this.logger.warning(String.format("Cannot remove package '%s' because it is be depends by package named '%s'", depend, installedPackage.getName()));
                return false;
            }
        }
        installedPackages.remove(meta);
        try {
            this.updateInstalledPackagesJson(installedPackages);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public synchronized List<LuacageJsonMeta> removeUselessPackages() {
        List<LuacageJsonMeta> installedPackages = this.installedPackages();
        HashMap<String, LuacageJsonMeta> map = new HashMap<String, LuacageJsonMeta>();
        HashSet<String> deleted = new HashSet<String>();
        for (LuacageJsonMeta installedPackage : installedPackages) {
            map.put(installedPackage.getName(), installedPackage);
            if (installedPackage.isManual()) continue;
            deleted.add(installedPackage.getName());
        }
        for (LuacageJsonMeta installedPackage : installedPackages) {
            if (!installedPackage.isManual()) continue;
            HashSet<String> checked = new HashSet<String>();
            LinkedList<LuacageJsonMeta> queue = new LinkedList<LuacageJsonMeta>();
            queue.add(installedPackage);
            checked.add(installedPackage.getName());
            while (!queue.isEmpty()) {
                String[] dependPackages;
                LuacageJsonMeta dependency = (LuacageJsonMeta)queue.poll();
                if (checked.add(dependency.getName())) {
                    deleted.remove(dependency.getName());
                }
                for (String dependPackage : dependPackages = dependency.getDependPackages()) {
                    LuacageJsonMeta meta = (LuacageJsonMeta)map.get(dependPackage);
                    if (meta == null) continue;
                    queue.add(meta);
                }
            }
        }
        List<LuacageJsonMeta> removed = installedPackages.parallelStream().filter(it -> deleted.contains(it.getName())).collect(Collectors.toList());
        installedPackages = installedPackages.parallelStream().filter(it -> !deleted.contains(it.getName())).collect(Collectors.toList());
        this.sort(installedPackages).ifSuccessThen(newList -> {
            try {
                this.updateInstalledPackagesJson((List<LuacageJsonMeta>)newList);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).ifFailureThen(circularDependencies -> this.logger.severe("[LuaEnv " + this.env.getId() + "] Circular dependencies found: " + String.valueOf(circularDependencies)));
        return removed;
    }

    @Override
    public File getInstallDir(@NotNull LuacageCommonMeta meta) {
        File packageFile = new File(this.baseDir, PACKAGE_DIR_NAME + File.separator + meta.getName());
        if (!packageFile.exists()) {
            packageFile.mkdirs();
        }
        return packageFile;
    }

    @Override
    public synchronized void loadPackages() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(new Runnable(){
            private int count = 60;

            @Override
            public synchronized void run() {
                DebugLogger.debug("Luacage load packages: (%02d/60)", 60 - this.count);
                if (this.count-- <= 0) {
                    try {
                        Luacage.this.doLoadPackages();
                    }
                    finally {
                        service.shutdown();
                    }
                    return;
                }
                List<LuacageJsonMeta> installedPackages = Luacage.this.installedPackages();
                Set depends = installedPackages.parallelStream().flatMap(it -> Stream.of(it.getDependPlugins())).collect(Collectors.toSet());
                PluginManager pluginManager = LuaInMinecraftBukkit.instance().getServer().getPluginManager();
                for (String p : depends) {
                    if (pluginManager.isPluginEnabled(p)) continue;
                    if (this.count % 10 == 0) {
                        Luacage.this.logger.warning(String.format("Still waiting plugin: %s", p));
                    }
                    return;
                }
                Luacage.this.doLoadPackages();
                service.shutdown();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public boolean loadPackage(LuacageJsonMeta pkg) {
        List<LuacageJsonMeta> pkgs = this.findDepends(pkg);
        pkgs.add(pkg);
        return this.sort(pkgs).ifSuccessThen(packs -> {
            LuaStateFacade lua = this.env.getLuaState();
            lua.lock(l -> {
                ArrayList<LuacageLuaMeta> packages = new ArrayList<LuacageLuaMeta>();
                for (LuacageJsonMeta p : packs) {
                    LuacageLuaMeta meta;
                    if (this.loadedPackages.containsKey(p.getName()) || (meta = this.loadPackageLua(lua, p, new HashSet<String>())) == null) continue;
                    packages.add(meta);
                }
                for (LuacageLuaMeta meta : packages) {
                    this.loadPackage(lua, meta);
                }
            });
        }).isSuccess();
    }

    protected synchronized void doLoadPackages() {
        this.loadedPackages.clear();
        List<LuacageJsonMeta> installedPackages = this.installedPackages();
        LinkedList packages = new LinkedList();
        HashSet failed = new HashSet();
        LuaStateFacade lua = this.env.getLuaState();
        lua.lock(l -> {
            for (LuacageJsonMeta installedPackage : installedPackages) {
                LuacageLuaMeta meta = this.loadPackageLua(lua, installedPackage, failed);
                if (meta == null) continue;
                packages.addFirst(meta);
            }
            for (LuacageLuaMeta meta : packages) {
                boolean next = false;
                for (String depends : meta.getDependPackages()) {
                    if (!failed.contains(depends)) continue;
                    failed.add(meta.getName());
                    next = true;
                    this.logger.warning(String.format("Package '%s' load failed because failed load depend package '%s'", meta.getName(), depends));
                    break;
                }
                if (next || this.loadPackage(lua, meta)) continue;
                failed.add(meta.getName());
                this.logger.warning(String.format("Package '%s' load failed because not found dependence plugins: %s", meta.getName(), Arrays.toString(meta.getDependPlugins())));
            }
        });
    }

    protected boolean loadPackage(LuaStateFacade lua, LuacageLuaMeta pkg) {
        PluginManager pluginManager = LuaInMinecraftBukkit.instance().getServer().getPluginManager();
        for (String id : pkg.getDependPlugins()) {
            if (pluginManager.isPluginEnabled(id)) continue;
            return false;
        }
        String main = pkg.getMain();
        if (main != null) {
            if (main.startsWith("/")) {
                main = main.substring(1);
            }
            if (main.toLowerCase(Locale.ENGLISH).endsWith(".lua")) {
                main = main.substring(0, main.length() - 4);
            }
            return lua.evalString(String.format("require('@%s/%s')", pkg.getName(), main)).ifFailureThen(err -> {
                this.logger.warning(String.format("Failed load main file of package '%s': %s", pkg.getName(), err.getMessage()));
                DebugLogger.debug(err);
            }).isSuccess();
        }
        return true;
    }

    public LuacageLuaMeta loadPackageMeta(LuaStateFacade lua, File installDir, String name) {
        File file = new File(installDir, PACKAGE_LUA_NAME);
        Result<Integer, LuaException> metaResult = this.env.evalFile(file.getAbsolutePath());
        if (metaResult.isError()) {
            LuaException error = metaResult.getError();
            this.logger.warning(String.format("Failed load 'package.lua' file of package '%s': %s", name, error.getMessage()));
            DebugLogger.debug(error);
            return null;
        }
        Result covertResult = lua.toJavaObject(-1).mapResultValue(obj -> {
            if (obj instanceof LuaTable) {
                return LuaTable2Object.covert((LuaTable)obj, LuacageLuaMeta.class);
            }
            return null;
        });
        if (covertResult.isError() || covertResult.isSuccess() && covertResult.getValue() == null) {
            Exception error = (Exception)covertResult.getError();
            this.logger.warning(String.format("Failed load 'package.lua' file of package '%s': %s", name, error.getMessage()));
            DebugLogger.debug(error);
            return null;
        }
        return (LuacageLuaMeta)covertResult.getValue();
    }

    protected LuacageLuaMeta loadPackageLua(LuaStateFacade lua, LuacageJsonMeta installedPackage, Set<String> failed) {
        File installDir;
        LuacageLuaMeta meta;
        if (installedPackage.getDependPackages() != null) {
            boolean skip = false;
            for (String dependPackage : installedPackage.getDependPackages()) {
                if (!failed.contains(dependPackage)) continue;
                this.logger.warning(String.format("Failed load package '%s': depends '%s' is not loaded", installedPackage.getName(), dependPackage));
                failed.add(installedPackage.getName());
                skip = true;
                break;
            }
            if (skip) {
                return null;
            }
        }
        if ((meta = this.loadPackageMeta(lua, installDir = this.getInstallDir(installedPackage), installedPackage.getName())) == null) {
            failed.add(installedPackage.getName());
            return null;
        }
        if (meta.isRunnable()) {
            return meta;
        }
        failed.add(installedPackage.getName());
        this.logger.warning(String.format("Failed load package '%s': it's not support your server: %s", installedPackage.getName(), meta.getReason()));
        return null;
    }

    protected void deleteFolder(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFolder(file);
                }
                file.delete();
            }
        }
        folder.delete();
    }

    private static /* synthetic */ void lambda$getRepository$1(MessageDigest digest, BufferedOutputStream bos, byte[] bytes, int len) throws IOException {
        digest.update(bytes, 0, len);
        bos.write(bytes, 0, len);
    }
}

