/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eu.smileyik.luajava.LuaJavaAPI;
import org.eu.smileyik.luajava.reflect.IExecutable;
import org.eu.smileyik.luajava.reflect.IFieldAccessor;
import org.eu.smileyik.luajava.reflect.LuaInvokedMethod;

public class ReflectUtil {
    public static final String PRIMITIVE_TYPE_PATTERN_STR = "(byte|short|int|long|float|double|char|boolean)";
    public static final Pattern PRIMITIVE_TYPE_PATTERN = Pattern.compile(String.format("^%s(\\[\\])*$", "(byte|short|int|long|float|double|char|boolean)"));
    public static final String FULL_CLASS_NAME_PATTERN_STR = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*";
    public static final Pattern FULL_CLASS_NAME_PATTERN = Pattern.compile(String.format("^%s$", "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*"));
    public static final Pattern FULL_CLASS_ARRAY_NAME_PATTERN_1 = Pattern.compile(String.format("^\\[+L%s;$", "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*"));
    public static final Pattern FULL_CLASS_ARRAY_NAME_PATTERN_2 = Pattern.compile(String.format("^%s(\\[\\])+$", "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*"));
    private static final Map<String, Class<?>> PRIMITIVE_NAME_2_TYPE_MAP;

    public static Field findFieldByType(Class<?> clazz, Class<?> targetType) {
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!targetType.isAssignableFrom(field.getType())) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object newInstance(Class<?> clazz, Object ... _args) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (clazz == null) {
            throw new NullPointerException("class is null");
        }
        if (_args == null) {
            _args = new Object[]{};
        }
        Object[] args = _args;
        LuaInvokedMethod<IExecutable<Constructor<?>>> constructor = LuaJavaAPI.getReflectUtil().findConstructorByParams(clazz, args, false, false, false);
        if (constructor == null) {
            throw new NullPointerException("No constructor found in " + String.valueOf(clazz) + " by params: " + Arrays.toString(args));
        }
        constructor.getOverwriteParams().forEach((idx, value) -> {
            args[idx.intValue()] = value;
        });
        return constructor.getExecutable().invoke(null, args);
    }

    public static Object callMethod(Object object, String methodName, Object ... _args) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (_args == null) {
            _args = new Object[]{};
        }
        Object[] args = _args;
        LinkedList<LuaInvokedMethod<IExecutable<Method>>> methodByParams = LuaJavaAPI.getReflectUtil().findMethodByParams(object.getClass(), methodName, args, false, false, false, false);
        if (methodByParams.isEmpty()) {
            throw new NullPointerException("No method found for " + methodName + " in " + String.valueOf(object.getClass()) + " by params: " + Arrays.toString(args));
        }
        if (methodByParams.size() != 1) {
            throw new NullPointerException("Multi-target method found for " + methodName + " in " + String.valueOf(object.getClass()) + " by params: " + Arrays.toString(args));
        }
        LuaInvokedMethod<IExecutable<Method>> invokedMethod = methodByParams.removeFirst();
        invokedMethod.getOverwriteParams().forEach((idx, value) -> {
            args[idx.intValue()] = value;
        });
        boolean isStaticMethod = Modifier.isStatic(invokedMethod.getExecutable().getExecutable().getModifiers());
        return invokedMethod.getExecutable().invoke(isStaticMethod ? null : object, args);
    }

    public static boolean hasMethod(Object object, String methodName) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new NullPointerException("methodName is null or empty");
        }
        return LuaJavaAPI.getReflectUtil().existsMethodByName(object.getClass(), methodName, false, false, false);
    }

    public static boolean hasField(Object object, String fieldName) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (fieldName == null || fieldName.isEmpty()) {
            throw new NullPointerException("fieldName is null or empty");
        }
        return LuaJavaAPI.getReflectUtil().findFieldByName(object.getClass(), fieldName, false, false, false, false) != null;
    }

    public static void setField(Object object, String fieldName, Object value) throws IllegalAccessException {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (fieldName == null || fieldName.isEmpty()) {
            throw new NullPointerException("fieldName is null or empty");
        }
        IFieldAccessor field = LuaJavaAPI.getReflectUtil().findFieldByName(object.getClass(), fieldName, false, false, false, false);
        if (field == null) {
            throw new NullPointerException("No field found for " + fieldName + " in " + String.valueOf(object.getClass()));
        }
        field.set(object, value);
    }

    public static Object getField(Object object, String fieldName) throws IllegalAccessException {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (fieldName == null || fieldName.isEmpty()) {
            throw new NullPointerException("fieldName is null or empty");
        }
        IFieldAccessor field = LuaJavaAPI.getReflectUtil().findFieldByName(object.getClass(), fieldName, false, false, false, false);
        if (field == null) {
            throw new NullPointerException("No field found for " + fieldName + " in " + String.valueOf(object.getClass()));
        }
        return field.get(object);
    }

    private static String fastRepeat(String str, int times) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (times <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder s = new StringBuilder(str);
        while (times > 0) {
            if ((times & 1) == 1) {
                result.append((CharSequence)s);
            }
            s.append((CharSequence)s);
            times >>= 1;
        }
        return result.toString();
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (PRIMITIVE_NAME_2_TYPE_MAP.containsKey(className)) {
            return PRIMITIVE_NAME_2_TYPE_MAP.get(className);
        }
        Matcher matcher = PRIMITIVE_TYPE_PATTERN.matcher(className);
        if (matcher.matches()) {
            String primitiveType = matcher.group(1);
            int d = className.length() - primitiveType.length() >> 1;
            String realClassName = null;
            Class<Comparable<Byte>> realClass = null;
            switch (primitiveType) {
                case "byte": {
                    realClass = Byte.TYPE;
                    realClassName = "B";
                    break;
                }
                case "short": {
                    realClass = Short.TYPE;
                    realClassName = "S";
                    break;
                }
                case "int": {
                    realClass = Integer.TYPE;
                    realClassName = "I";
                    break;
                }
                case "long": {
                    realClass = Long.TYPE;
                    realClassName = "J";
                    break;
                }
                case "float": {
                    realClass = Float.TYPE;
                    realClassName = "F";
                    break;
                }
                case "double": {
                    realClass = Double.TYPE;
                    realClassName = "D";
                    break;
                }
                case "char": {
                    realClass = Character.TYPE;
                    realClassName = "C";
                    break;
                }
                case "boolean": {
                    realClass = Boolean.TYPE;
                    realClassName = "Z";
                }
            }
            return d > 0 ? Class.forName(ReflectUtil.fastRepeat("[", d) + realClassName) : realClass;
        }
        if (FULL_CLASS_NAME_PATTERN.matcher(className).matches() || FULL_CLASS_ARRAY_NAME_PATTERN_1.matcher(className).matches()) {
            return Class.forName(className);
        }
        if (!FULL_CLASS_ARRAY_NAME_PATTERN_2.matcher(className).matches()) {
            throw new ClassNotFoundException(className);
        }
        int idx = className.indexOf(91);
        int d = className.length() - idx >> 1;
        return Class.forName(ReflectUtil.fastRepeat("[", d) + "L" + className.substring(0, idx) + ";");
    }

    public static boolean isLambdaInstance(Object instance) {
        return instance != null && instance.getClass().getSimpleName().contains("$$Lambda/");
    }

    public static Method getLambdaRealMethod(Method targetMethod) {
        Class<?> declaringClass = targetMethod.getDeclaringClass();
        if (declaringClass.getSimpleName().contains("$$Lambda/")) {
            return org.eu.smileyik.luajava.reflect.ReflectUtil.foreachClass(declaringClass, true, it -> {
                Method[] methods;
                if (declaringClass == it) {
                    return null;
                }
                for (Method method : methods = it.getDeclaredMethods()) {
                    if (!method.getName().equals(targetMethod.getName()) || !Arrays.equals(method.getParameterTypes(), targetMethod.getParameterTypes())) continue;
                    return method;
                }
                return null;
            });
        }
        return null;
    }

    static {
        HashMap<String, Class<Object>> primitiveName2TypeMap = new HashMap<String, Class<Object>>();
        primitiveName2TypeMap.put("byte", Byte.TYPE);
        primitiveName2TypeMap.put("short", Short.TYPE);
        primitiveName2TypeMap.put("int", Integer.TYPE);
        primitiveName2TypeMap.put("long", Long.TYPE);
        primitiveName2TypeMap.put("float", Float.TYPE);
        primitiveName2TypeMap.put("double", Double.TYPE);
        primitiveName2TypeMap.put("char", Character.TYPE);
        primitiveName2TypeMap.put("boolean", Boolean.TYPE);
        primitiveName2TypeMap.put("void", Void.TYPE);
        primitiveName2TypeMap.put("B", Byte.TYPE);
        primitiveName2TypeMap.put("S", Short.TYPE);
        primitiveName2TypeMap.put("I", Integer.TYPE);
        primitiveName2TypeMap.put("J", Long.TYPE);
        primitiveName2TypeMap.put("F", Float.TYPE);
        primitiveName2TypeMap.put("D", Double.TYPE);
        primitiveName2TypeMap.put("C", Character.TYPE);
        primitiveName2TypeMap.put("Z", Boolean.TYPE);
        primitiveName2TypeMap.put("V", Void.TYPE);
        PRIMITIVE_NAME_2_TYPE_MAP = Collections.unmodifiableMap(primitiveName2TypeMap);
    }
}

