/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.simplecommand;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandTranslator;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.DefaultTabSuggest;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.Result;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.TabSuggest;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.annotation.Command;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.annotation.CommandI18N;

public class CommandMethod {
    private final Command commandInfo;
    private final CommandI18N commandI18N;
    private final Object instance;
    private final Method method;
    private String permission = null;
    private Map<String, CommandMethod> children = null;
    private List<CommandMethod> sortedMethod;
    private CommandMethod parent = null;
    private CommandMethod next = null;
    private String helpCache = null;
    private Map<String, Map<Character, Integer>> subcommandMap;

    public CommandMethod(Command commandInfo, CommandI18N commandI18N, Object instance, Method method) {
        this.commandInfo = commandInfo;
        this.commandI18N = commandI18N;
        this.instance = instance;
        this.method = method;
        if (!commandInfo.permission().isEmpty()) {
            this.permission = commandInfo.permission();
        }
    }

    public boolean hasChild() {
        return this.children != null;
    }

    public boolean canExecute() {
        return this.method != null;
    }

    public boolean hasParentCommand() {
        return !this.commandInfo.parentCommand().isEmpty();
    }

    public String getParentCommand() {
        return this.commandInfo.parentCommand();
    }

    public boolean isRootCommand() {
        return this.parent == null;
    }

    public String getCommand() {
        return this.commandInfo.value();
    }

    public void clear() {
        if (this.hasChild()) {
            for (CommandMethod value : this.children.values()) {
                while (value != null) {
                    value.clear();
                    value = value.next;
                }
            }
            this.children.clear();
            this.sortedMethod.clear();
            this.subcommandMap.clear();
        }
        this.permission = null;
        this.parent = null;
        this.children = null;
        this.sortedMethod = null;
        this.next = null;
        this.helpCache = null;
        this.subcommandMap = null;
    }

    public void addChild(CommandMethod commandMethod) {
        if (this.children == null) {
            this.children = new HashMap<String, CommandMethod>();
            this.subcommandMap = new HashMap<String, Map<Character, Integer>>();
            this.sortedMethod = new ArrayList<CommandMethod>();
        }
        if (this.permission != null && commandMethod.permission == null) {
            commandMethod.permission = this.permission;
        }
        String subcommand = commandMethod.getCommand().toLowerCase();
        commandMethod.parent = this;
        commandMethod.next = this.children.get(subcommand);
        this.children.put(subcommand, commandMethod);
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (char c : subcommand.toCharArray()) {
            map.put(Character.valueOf(c), map.getOrDefault(Character.valueOf(c), 0) + 1);
        }
        this.subcommandMap.put(subcommand, map);
        this.sortedMethod.add(commandMethod);
    }

    private String getColor(CommandTranslator tr) {
        return this.commandI18N == null ? this.commandInfo.colorCode() : tr.tr(String.format("%s.%s.%s", this.commandI18N.value(), this.getCommand(), this.commandInfo.colorCode()), new Object[0]);
    }

    private String getSameWeightCommand() {
        if (this.parent == null) {
            return this.getCommand();
        }
        if (this.parent.children == null) {
            return this.getCommand();
        }
        int max = this.parent.children.values().stream().max(Comparator.comparing(it -> it.getCommand().length())).get().getCommand().length();
        StringBuilder sb = new StringBuilder(this.getCommand());
        while (sb.length() != max) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void spawnHelp(CommandTranslator translator) {
        LinkedList<CommandMethod> list = new LinkedList<CommandMethod>();
        CommandMethod p = this.parent;
        while (p != null) {
            list.addFirst(p);
            p = p.parent;
        }
        StringBuilder sb = new StringBuilder();
        if (!list.isEmpty()) {
            String[] cmd = (CommandMethod)list.removeFirst();
            sb.append(" ").append(super.getColor(translator)).append("<%:root_command>");
        }
        for (CommandMethod cmd : list) {
            sb.append(" ").append(cmd.getColor(translator)).append(cmd.getCommand());
        }
        sb.append(" ").append(this.getColor(translator)).append(this.getCommand());
        if (this.canExecute()) {
            for (String arg : this.commandInfo.args()) {
                sb.append(" ").append("&b[").append(this.commandI18N == null ? arg : translator.tr(String.format("%s.%s.%s", this.commandI18N.value(), this.getCommand(), arg), new Object[0])).append("&b]");
            }
        } else {
            this.sortedMethod.sort(Comparator.comparingInt(l -> l.getCommand().length()).thenComparing(CommandMethod::getCommand));
        }
        sb.append(" &r- ").append(this.commandI18N == null ? this.commandInfo.description() : translator.tr(String.format("%s.%s.%s", this.commandI18N.value(), this.getCommand(), this.commandInfo.description()), new Object[0]));
        this.helpCache = ChatColor.translateAlternateColorCodes((char)'&', (String)sb.substring(1));
        if (this.children != null) {
            this.children.values().forEach(it -> it.spawnHelp(translator));
        }
        CommandMethod n = this.next;
        while (n != null) {
            n.spawnHelp(translator);
            n = n.next;
        }
    }

    public String getHelp(CommandSender sender, String alias) {
        if (sender instanceof Player) {
            alias = "/" + alias;
        }
        if (this.canExecute()) {
            return this.helpCache == null ? null : this.helpCache.replace("<%:root_command>", alias);
        }
        if (this.children != null) {
            StringBuilder sb = new StringBuilder();
            this.sortedMethod.forEach(it -> {
                if (it.hasPermission(sender)) {
                    sb.append("\n").append(it.helpCache);
                }
            });
            return sb.length() == 0 ? "" : sb.substring(1).replace("<%:root_command>", alias);
        }
        return this.helpCache == null ? null : this.helpCache.replace("<%:root_command>", alias);
    }

    public String[] getAliases() {
        return this.commandInfo.aliases();
    }

    public boolean hasPermission(CommandSender sender) {
        return this.permission == null || sender.isOp() || sender.hasPermission(this.permission);
    }

    public List<String> getTabSuggest(List<DefaultTabSuggest> defaultSuggests, Map<String, TabSuggest> tabSuggestMap, CommandSender sender, String[] args, int idx, int step) {
        if (!this.hasChild()) {
            if (!this.hasPermission(sender)) {
                return Collections.emptyList();
            }
            if (idx == args.length - 1) {
                TabSuggest tabSuggest = null;
                if (this.commandInfo.args().length > idx - step) {
                    tabSuggest = tabSuggestMap.get(this.commandInfo.args()[idx - step].toLowerCase());
                }
                if (tabSuggest == null) {
                    for (DefaultTabSuggest defaultSuggest : defaultSuggests) {
                        if (!defaultSuggest.matches(args, step - 1)) continue;
                        tabSuggest = defaultSuggest;
                        break;
                    }
                }
                if (tabSuggest == null && this.next != null) {
                    return this.next.getTabSuggest(defaultSuggests, tabSuggestMap, sender, args, idx, step);
                }
                return tabSuggest == null ? Collections.emptyList() : tabSuggest.suggest(args, step - 1);
            }
            return this.getTabSuggest(defaultSuggests, tabSuggestMap, sender, args, idx + 1, step);
        }
        if (idx == args.length - 1) {
            String prefix = args[idx];
            return this.subcommandMap.keySet().stream().filter(it -> it.startsWith(prefix) && this.children.get(it).hasPermission(sender)).collect(Collectors.toList());
        }
        CommandMethod commandMethod = this.children.get(args[idx]);
        if (commandMethod == null || !commandMethod.hasPermission(sender)) {
            return Collections.emptyList();
        }
        return commandMethod.getTabSuggest(defaultSuggests, tabSuggestMap, sender, args, idx + 1, step + 1);
    }

    private void invokeMethod(CommandSender sender, String[] args) throws InvocationTargetException, IllegalAccessException {
        Object[] params = new Object[this.method.getParameterCount()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.method.getParameterTypes()[i].isArray() ? args : sender;
        }
        this.method.invoke(this.instance, params);
    }

    private Result sendHelpInfo(CommandSender sender, String label) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format("\n&e------------&rHELP&e-----------------\n%s\n&e---------------------------------", this.getHelp(sender, label))));
        return Result.RESULT_SUCCEED;
    }

    public Result execute(CommandSender sender, String label, String[] args, int idx) throws InvocationTargetException, IllegalAccessException {
        if (!this.hasPermission(sender)) {
            return Result.RESULT_NO_PERMISSION;
        }
        if (args.length == idx + 1 && args[idx].equalsIgnoreCase("help")) {
            return this.sendHelpInfo(sender, label);
        }
        if (this.canExecute()) {
            if (args.length - idx == this.commandInfo.args().length || this.commandInfo.isUnlimitedArgs()) {
                if (this.commandInfo.needPlayer() && !(sender instanceof Player)) {
                    return Result.RESULT_NOT_PLAYER;
                }
                String[] strings = Arrays.copyOfRange(args, idx, args.length);
                this.invokeMethod(sender, strings);
                return Result.RESULT_SUCCEED;
            }
            return Result.RESULT_WRONG_COMMAND;
        }
        if (args.length == idx) {
            return this.sendHelpInfo(sender, label);
        }
        if (!this.hasChild()) {
            return Result.RESULT_WRONG_COMMAND;
        }
        CommandMethod cmd = this.children.get(args[idx].toLowerCase());
        Result result = Result.RESULT_NOT_FIND;
        while (cmd != null) {
            result = cmd.execute(sender, label, args, idx + 1);
            if (result == Result.RESULT_SUCCEED) {
                return result;
            }
            cmd = cmd.next;
        }
        if (result.getSuggestion() != null) {
            return result;
        }
        String suggestSubcommand = this.findSuggestSubcommand(sender, args[idx].toLowerCase());
        if (suggestSubcommand != null) {
            return new Result(result.getResult(), this.children.get(suggestSubcommand));
        }
        return result;
    }

    private String findSuggestSubcommand(CommandSender sender, String wrongCmd) {
        List available = this.subcommandMap.keySet().stream().filter(it -> this.children.get(it).hasPermission(sender)).collect(Collectors.toList());
        List targets = available.stream().filter(it -> it.startsWith(wrongCmd)).collect(Collectors.toList());
        if (targets.isEmpty()) {
            targets.addAll(available);
        }
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (char c : wrongCmd.toCharArray()) {
            map.put(Character.valueOf(c), map.getOrDefault(Character.valueOf(c), 0) + 1);
        }
        int min = Integer.MAX_VALUE;
        String suggest = null;
        for (String targetCommand : targets) {
            HashMap<Character, Integer> target = new HashMap<Character, Integer>(this.subcommandMap.get(targetCommand));
            for (Map.Entry c : map.entrySet()) {
                target.put((Character)c.getKey(), Math.abs(target.getOrDefault(c.getKey(), 0) - (Integer)c.getValue()));
            }
            int i = 0;
            for (Integer value : target.values()) {
                i += value.intValue();
            }
            if (i >= min) continue;
            suggest = targetCommand;
            min = i;
        }
        return suggest;
    }

    public CommandMethod getNext() {
        return this.next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandMethod that = (CommandMethod)o;
        return Objects.equals(this.commandInfo.value(), that.commandInfo.value());
    }

    public int hashCode() {
        return Objects.hash(this.commandInfo.value());
    }
}

