/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.eu.smileyik.luaInMinecraftBukkitII.util.HashUtil;

public class LibraryHashes {
    public static void main(String[] args) throws NoSuchAlgorithmException, IOException {
        if (args.length == 0) {
            return;
        }
        File nativeFolder = new File(args[0]);
        if (!nativeFolder.exists()) {
            return;
        }
        LinkedList<File> files = new LinkedList<File>();
        files.add(nativeFolder);
        while (!files.isEmpty()) {
            nativeFolder = (File)files.remove();
            File[] subs = nativeFolder.listFiles();
            if (subs == null) continue;
            for (File sub : subs) {
                if (sub.isDirectory()) {
                    files.add(sub);
                    continue;
                }
                if (sub.getName().endsWith(".hash")) continue;
                String path = sub.getAbsolutePath();
                String sha256Path = path + ".hash";
                String sha256 = HashUtil.sha256(sub);
                Files.write(Paths.get(sha256Path, new String[0]), sha256.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }
}

