/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.tools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.ILuaStateManager;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageCommonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageJsonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageLuaMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.LuaTable2Object;
import org.eu.smileyik.luaInMinecraftBukkitII.util.HashUtil;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.type.LuaTable;

public class LuacageDatabaseGenerator {
    public static final String BUILD_PATH = System.getenv("luainminecraftbukkit_luacage_build");
    private static final String NAME_PATTERN = "[a-zA-Z][a-zA-Z0-9_-]+";

    public static void run() {
        if (BUILD_PATH == null) {
            return;
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Object> stop = executorService.submit(() -> {
            while (true) {
                LuaStateFacade facade = null;
                try {
                    facade = LuacageDatabaseGenerator.getLuaStateFacade();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (facade != null) break;
                Thread.sleep(1000L);
            }
            try {
                LuacageDatabaseGenerator.run(BUILD_PATH, BUILD_PATH + "/luacage.json");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        try {
            stop.get(60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdown();
            LuaInMinecraftBukkit.instance().getScheduler().runTask((Plugin)LuaInMinecraftBukkit.instance(), () -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "stop"));
        }
    }

    public static void run(String repoPath, String outPath) throws Exception {
        try {
            LuacageDatabaseGenerator.doRun(repoPath, outPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "stop");
            throw e;
        }
    }

    protected static void doRun(String repoPath, String outPath) throws Exception {
        File repo = new File(repoPath);
        File pkgDir = new File(repoPath, "packages");
        if (!pkgDir.exists()) {
            pkgDir.mkdirs();
        }
        List<LuacageJsonMeta> database = LuacageDatabaseGenerator.getDatabase(repo);
        File[] files = pkgDir.listFiles();
        if (files == null) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            ids.add(file.getName());
        }
        ArrayList<String> remove = new ArrayList<String>();
        ArrayList<String> update = new ArrayList<String>();
        for (LuacageJsonMeta meta : database) {
            if (!ids.remove(meta.getName())) {
                remove.add(meta.getName());
                continue;
            }
            LuacageLuaMeta luacageLuaMeta = LuacageDatabaseGenerator.loadLuaMeta(LuacageDatabaseGenerator.getLuaStateFacade(), new File(pkgDir, meta.getName() + "/package.lua"));
            if (Objects.equals(luacageLuaMeta.getVersion(), meta.getVersion())) continue;
            update.add(meta.getName());
        }
        for (String id : update) {
            LuacageDatabaseGenerator.updateMetaList(repoPath, new File(repo, "luacage.json").getAbsolutePath(), id);
        }
        for (String id : ids) {
            LuacageDatabaseGenerator.updateMetaList(repoPath, new File(repo, "luacage.json").getAbsolutePath(), id);
        }
        database = LuacageDatabaseGenerator.getDatabase(repo);
        database = database.parallelStream().filter(it -> !remove.contains(it.getName())).collect(Collectors.toList());
        LuacageDatabaseGenerator.writeJson(database, outPath);
    }

    public static void updateMetaList(String repoPath, String outPath, final String name) throws Exception {
        if (!name.matches(NAME_PATTERN)) {
            throw new Exception("Invalid name " + name + ", name not matches pattern [a-zA-Z][a-zA-Z0-9_-]+");
        }
        File repo = new File(repoPath);
        File pkgDir = new File(repoPath, "packages");
        List<LuacageJsonMeta> database = LuacageDatabaseGenerator.getDatabase(repo);
        File packageDir = new File(pkgDir, name);
        if (!packageDir.exists()) {
            throw new FileNotFoundException(packageDir.getAbsolutePath());
        }
        File pkgMetaFile = new File(packageDir, "package.lua");
        LuacageLuaMeta meta = LuacageDatabaseGenerator.loadLuaMeta(LuacageDatabaseGenerator.getLuaStateFacade(), pkgMetaFile);
        LuacageCommonMeta jsonMeta = null;
        int idx = 0;
        for (LuacageJsonMeta find : database) {
            if (find.getName().equals(meta.getName())) {
                jsonMeta = find;
                break;
            }
            ++idx;
        }
        if (jsonMeta == null) {
            jsonMeta = new LuacageJsonMeta();
            ((LuacageJsonMeta)jsonMeta).setCreatedAt(System.currentTimeMillis());
            idx = -1;
        }
        jsonMeta.setName(name);
        jsonMeta.setVersion(meta.getVersion());
        jsonMeta.setAuthors(meta.getAuthors());
        jsonMeta.setDescription(meta.getDescription());
        jsonMeta.setLuaVersion(meta.getLuaVersion());
        jsonMeta.setDependPackages(meta.getDependPackages());
        jsonMeta.setDependPlugins(meta.getDependPlugins());
        final ArrayList files = new ArrayList();
        final ArrayList hashes = new ArrayList();
        Files.walkFileTree(packageDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String fileName = dir.getFileName().toString();
                if (fileName.startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isRegularFile()) {
                    return FileVisitResult.CONTINUE;
                }
                String p = file.toFile().getAbsolutePath();
                int i = p.indexOf(name);
                if (i != -1) {
                    String filePath = p.substring(i + name.length()).replace("\\", "/");
                    if (Files.isHidden(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (filePath.startsWith("/.git")) {
                        return FileVisitResult.CONTINUE;
                    }
                    files.add(filePath);
                    try {
                        String hash = HashUtil.sha256(file.toFile());
                        hashes.add(hash);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        String[] fs = new String[files.size()];
        String[] hs = new String[hashes.size()];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = ((String)files.get(i)).replace("\\", "/");
            hs[i] = (String)hashes.get(i);
        }
        ((LuacageJsonMeta)jsonMeta).setFiles(fs);
        ((LuacageJsonMeta)jsonMeta).setHashes(hs);
        ((LuacageJsonMeta)jsonMeta).setUpdateAt(System.currentTimeMillis());
        if (idx == -1) {
            database.add((LuacageJsonMeta)jsonMeta);
        } else {
            database.set(idx, (LuacageJsonMeta)jsonMeta);
        }
        LuacageDatabaseGenerator.writeJson(database, outPath);
    }

    private static LuaStateFacade getLuaStateFacade() {
        ILuaStateManager luaStateManager = LuaInMinecraftBukkit.instance().getLuaStateManager();
        if (luaStateManager == null) {
            return null;
        }
        Collection<ILuaStateEnv> scriptEnvs = luaStateManager.getScriptEnvs();
        ILuaStateEnvInner env = scriptEnvs.stream().findFirst().orElse(null);
        if (env == null) {
            throw new IllegalStateException("LuaInMinecraftBukkit has no lua env");
        }
        return env.getLuaState();
    }

    private static List<LuacageJsonMeta> getDatabase(File repo) throws FileNotFoundException {
        File file = new File(repo, "luacage.json");
        if (!file.exists()) {
            return new ArrayList<LuacageJsonMeta>();
        }
        List list = (List)new Gson().fromJson((Reader)new FileReader(file), new TypeToken<List<LuacageJsonMeta>>(){}.getType());
        return new ArrayList<LuacageJsonMeta>(list);
    }

    private static void writeJson(List<LuacageJsonMeta> list, String outPath) throws IOException, NoSuchAlgorithmException {
        list.sort(Comparator.comparing(LuacageCommonMeta::getName));
        String json = new Gson().toJson(list);
        Path path = Paths.get(outPath, new String[0]);
        Files.write(path, json.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        String hash = HashUtil.sha256(path.toFile());
        Files.write(Paths.get(outPath + ".hash", new String[0]), hash.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LuacageLuaMeta loadLuaMeta(LuaStateFacade lua, File luaFile) throws Exception {
        lua.lock();
        try {
            lua.evalFile(luaFile.getAbsolutePath()).justThrow();
            LuaTable table = (LuaTable)lua.toJavaObject(-1).getOrThrow();
            LuacageLuaMeta luacageLuaMeta = LuaTable2Object.covert(table, LuacageLuaMeta.class).getOrThrow();
            return luacageLuaMeta;
        }
        finally {
            lua.unlock();
        }
    }
}

