/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.bstats.bukkit.Metrics;
import org.eu.smileyik.luaInMinecraftBukkitII.bstats.charts.DrilldownPie;
import org.eu.smileyik.luaInMinecraftBukkitII.bstats.charts.SimplePie;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.LuaStateEnv;
import org.eu.smileyik.luajava.LuaJavaAPI;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.reflect.SimpleReflectUtil;

public class BStatsMetrics {
    private static final DrilldownPie LUA_VERSION = new DrilldownPie("lua_version", () -> {
        HashMap map = new HashMap();
        String str = System.getProperty("os.name") + "@" + System.getProperty("os.version") + "@" + System.getProperty("os.arch");
        HashMap<CallSite, Integer> entry = new HashMap<CallSite, Integer>();
        entry.put((CallSite)((Object)str), 1);
        map.put(LuaState.LUA_VERSION, entry);
        return map;
    });
    private static final SimplePie LUA_REFLECTION_TYPE = new SimplePie("lua_reflection", () -> {
        Class<?> aClass = LuaJavaAPI.getReflectUtil().getClass();
        if (aClass == SimpleReflectUtil.class) {
            return "Default";
        }
        return aClass.getSimpleName();
    });
    private static final SimplePie LUA_ENV_COUNT = new SimplePie("lua_environment_count", () -> String.valueOf((Object)LuaInMinecraftBukkit.instance().getLuaStateManager().getScriptEnvs().size()));
    private static final SimplePie LUA_SCRIPT_COUNT = new SimplePie("lua_script_count", () -> {
        int count = 0;
        for (ILuaStateEnv ienv : LuaInMinecraftBukkit.instance().getLuaStateManager().getScriptEnvs()) {
            if (!(ienv instanceof LuaStateEnv)) continue;
            LuaStateEnv env = (LuaStateEnv)ienv;
            count += env.getConfig().getInitialization().length;
        }
        return String.valueOf(count);
    });
    private static final SimplePie LUA_PACKAGE_COUNT = new SimplePie("lua_package_count", () -> {
        int count = 0;
        for (ILuaStateEnv env : LuaInMinecraftBukkit.instance().getLuaStateManager().getScriptEnvs()) {
            count += env.getLuacage().installedPackages().size();
        }
        return String.valueOf(count);
    });
    private static final DrilldownPie LUA_PACKAGE = new DrilldownPie("lua_package", () -> {
        HashMap map = new HashMap();
        for (ILuaStateEnv env : LuaInMinecraftBukkit.instance().getLuaStateManager().getScriptEnvs()) {
            env.getLuacage().installedPackages().forEach(it -> {
                Map entry = map.computeIfAbsent(it.getName(), key -> new HashMap());
                entry.put(it.getVersion(), entry.getOrDefault(it.getVersion(), 0) + 1);
            });
        }
        return map;
    });

    public static Metrics newInstance(int serviceId) {
        Metrics metrics = new Metrics(LuaInMinecraftBukkit.instance(), serviceId);
        metrics.addCustomChart(LUA_VERSION);
        metrics.addCustomChart(LUA_REFLECTION_TYPE);
        metrics.addCustomChart(LUA_ENV_COUNT);
        metrics.addCustomChart(LUA_SCRIPT_COUNT);
        metrics.addCustomChart(LUA_PACKAGE_COUNT);
        metrics.addCustomChart(LUA_PACKAGE);
        return metrics;
    }
}

