/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eu.smileyik.luaInMinecraftBukkitII.util.HexUtil;

public class StaticResourceDownloader {
    public static String download(String url, int bufferSize, int timeout, File out) throws IOException, NoSuchAlgorithmException, ExecutionException, InterruptedException, TimeoutException {
        try (FileOutputStream fos = new FileOutputStream(out);){
            String string;
            try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                StaticResourceDownloader.download(url, bufferSize, timeout, (byte[] bytes, int len) -> {
                    digest.update(bytes, 0, len);
                    bos.write(bytes, 0, len);
                });
                bos.flush();
                string = HexUtil.bytesToHex(digest.digest());
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, int bufferSize, int timeout, Callback callback) throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    URL u = new URL(url);
                    URLConnection conn = u.openConnection();
                    try (InputStream is = conn.getInputStream();
                         BufferedInputStream bis = new BufferedInputStream(is);){
                        int len;
                        byte[] buffer = new byte[bufferSize];
                        while ((len = bis.read(buffer)) > 0) {
                            callback.accept(buffer, len);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            });
            future.get(timeout, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static byte[] download(String url, int bufferSize, int timeout) throws ExecutionException, InterruptedException, TimeoutException, IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BufferedOutputStream bos = new BufferedOutputStream(baos);){
                StaticResourceDownloader.download(url, bufferSize, timeout, (byte[] bytes, int len) -> bos.write(bytes, 0, len));
                bos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static String getUrlContents(String url) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        return new String(StaticResourceDownloader.download(url, 8192, 60));
    }

    public static interface Callback {
        public void accept(byte[] var1, int var2) throws IOException;
    }
}

