/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.LuaStateFactory;

public class Console {
    public static void main(String[] args) {
        try (LuaStateFacade luaState = LuaStateFactory.newLuaState();){
            luaState.lockThrow(L -> {
                L.openLibs();
                if (args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        int res = L.LloadFile(args[i]);
                        if (res == 0) {
                            res = L.pcall(0, 0, 0);
                        }
                        if (res == 0) continue;
                        throw new LuaException("Error on file: " + args[i] + ". " + L.toString(-1));
                    }
                    return;
                }
                System.out.println("API Lua Java - console mode.");
                BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("> ");
                try {
                    String line;
                    while ((line = inp.readLine()) != null && !line.equals("exit")) {
                        int ret = L.LloadBuffer(line.getBytes(), "from console");
                        if (ret == 0) {
                            ret = L.pcall(0, 0, 0);
                        }
                        if (ret != 0) {
                            System.err.println("Error on line: " + line);
                            System.err.println(L.toString(-1));
                        }
                        System.out.print("> ");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

