/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaInvocationHandler;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.IInnerLuaObject;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.ILuaObject;
import org.eu.smileyik.luajava.type.InnerTypeHelper;
import org.eu.smileyik.luajava.util.ResourceCleaner;

public class LuaObject
implements ILuaObject,
IInnerLuaObject,
AutoCloseable {
    protected Integer ref;
    protected long luaPointer;
    protected boolean gotLuaPointer = false;
    protected final LuaStateFacade luaState;
    private final CleanTask cleanTask;

    protected LuaObject(LuaStateFacade luaState, int index) {
        this.luaState = luaState;
        LuaState L = luaState.getLuaState();
        L.pushValue(index);
        this.ref = L.Lref(LuaState.LUA_REGISTRYINDEX);
        CleanTask cleanTask = new CleanTask(luaState, this.ref);
        ResourceCleaner.getInstance().register(this, cleanTask);
        this.cleanTask = cleanTask;
    }

    protected static Result<LuaObject, ? extends LuaException> create(LuaStateFacade luaState, int index) {
        return luaState.lock(L -> LuaObject.rawCreate(luaState, index));
    }

    protected static Result<LuaObject, ? extends LuaException> rawCreate(LuaStateFacade luaState, int index) {
        return luaState.getLuaState().isNil(index) ? Result.success(null) : Result.success(InnerTypeHelper.rawCreateLuaObject(luaState, index).orElseGet(() -> new LuaObject(luaState, index)));
    }

    protected static Result<LuaObject, ? extends LuaException> create(LuaStateFacade luaState, String globalName) {
        return luaState.lockThrow(L -> {
            L.getGlobal(globalName);
            try {
                LuaObject luaObject = LuaObject.create(luaState, -1).getOrThrow(LuaException.class);
                return luaObject;
            }
            finally {
                L.pop(1);
            }
        });
    }

    protected static Result<LuaObject, ? extends LuaException> create(LuaObject parent, String name) {
        LuaStateFacade luaState = parent.getLuaState();
        return luaState.lockThrow(L -> {
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            parent.push();
            L.pushString(name);
            L.getTable(-2);
            L.remove(-2);
            try {
                LuaObject luaObject = LuaObject.create(luaState, -1).getOrThrow(LuaException.class);
                return luaObject;
            }
            finally {
                L.pop(1);
            }
        });
    }

    protected static Result<LuaObject, ? extends LuaException> create(LuaObject parent, Number name) {
        LuaStateFacade luaState = parent.getLuaState();
        return luaState.lockThrow(L -> {
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            try {
                parent.push();
                L.pushNumber(name.doubleValue());
                L.getTable(-2);
                L.remove(-2);
                LuaObject luaObject = LuaObject.create(luaState, -1).getOrThrow(LuaException.class);
                return luaObject;
            }
            finally {
                L.pop(1);
            }
        });
    }

    protected static Result<LuaObject, ? extends LuaException> create(LuaObject parent, LuaObject name) {
        if (parent.getLuaState() != name.getLuaState()) {
            return Result.failure(new LuaException("LuaStates must be the same!"));
        }
        LuaStateFacade luaState = parent.getLuaState();
        return luaState.lockThrow(L -> {
            if (!parent.isTable() && !parent.isUserdata()) {
                throw new LuaException("Object parent should be a table or userdata .");
            }
            parent.push();
            name.push();
            L.getTable(-2);
            L.remove(-2);
            try {
                LuaObject luaObject = LuaObject.create(luaState, -1).getOrThrow(LuaException.class);
                return luaObject;
            }
            finally {
                L.pop(1);
            }
        });
    }

    @Override
    public LuaStateFacade getLuaState() {
        return this.luaState;
    }

    @Override
    public void close() {
        this.cleanTask.run();
    }

    @Override
    public boolean isClosed() {
        return this.luaState == null || this.luaState.isClosed();
    }

    public boolean isCallable() {
        return !this.isClosed() && this instanceof ILuaCallable;
    }

    @Override
    public void push() {
        if (this.isClosed()) {
            return;
        }
        this.luaState.lock(l -> l.rawGetI(LuaState.LUA_REGISTRYINDEX, this.ref));
    }

    @Override
    public void rawPush() {
        this.luaState.getLuaState().rawGetI(LuaState.LUA_REGISTRYINDEX, this.ref);
    }

    public boolean isJavaObject() {
        if (this.isClosed()) {
            return false;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            boolean bool = luaState.isObject(-1);
            luaState.pop(1);
            return bool;
        });
    }

    public boolean isJavaFunction() {
        if (this.isClosed()) {
            return false;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            boolean bool = luaState.isJavaFunction(-1);
            luaState.pop(1);
            return bool;
        });
    }

    @Override
    public int type() {
        if (this.isClosed()) {
            return 0;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            int type = luaState.type(-1);
            luaState.pop(1);
            return type;
        });
    }

    public boolean getBoolean() {
        if (this.isClosed()) {
            return false;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            boolean bool = luaState.toBoolean(-1);
            luaState.pop(1);
            return bool;
        });
    }

    public double getNumber() {
        if (this.isClosed()) {
            return 0.0;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            double db = luaState.toNumber(-1);
            luaState.pop(1);
            return db;
        });
    }

    public String getString() {
        if (this.isClosed()) {
            return null;
        }
        return this.luaState.lock(luaState -> {
            this.push();
            String str = luaState.toString(-1);
            luaState.pop(1);
            return str;
        });
    }

    public Object getObject() throws LuaException {
        if (this.isClosed()) {
            return null;
        }
        return this.luaState.lockThrow(luaState -> {
            this.push();
            Object obj = luaState.getObjectFromUserdata(-1);
            luaState.pop(1);
            return obj;
        });
    }

    public String toString() {
        return this.luaState.lock(luaState -> {
            try {
                if (this.isNil()) {
                    return "nil";
                }
                if (this.isBoolean()) {
                    return String.valueOf(this.getBoolean());
                }
                if (this.isNumber()) {
                    return String.valueOf(this.getNumber());
                }
                if (this.isString()) {
                    return this.getString();
                }
                if (this.isFunction()) {
                    return "Lua Function";
                }
                if (this.isJavaObject()) {
                    return this.getObject().toString();
                }
                if (this.isUserdata()) {
                    return "Userdata";
                }
                if (this.isTable()) {
                    return "Lua Table";
                }
                if (this.isJavaFunction()) {
                    return "Java Function";
                }
                return null;
            }
            catch (LuaException e) {
                return null;
            }
        });
    }

    public boolean equals(Object object) {
        if (this.isClosed()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof LuaObject)) {
            return false;
        }
        LuaObject luaObject = (LuaObject)object;
        if (!Objects.equals(this.luaState.getCPtrPeer(), luaObject.luaState.getCPtrPeer())) {
            return false;
        }
        if (this.isLuaPointerObject() && luaObject.isLuaPointerObject()) {
            return Objects.equals(this.getLuaPointer(), luaObject.getLuaPointer());
        }
        return this.isRawEqualInLua(luaObject);
    }

    public boolean isLuaPointerObject() {
        switch (this.type()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getLuaPointer(), this.luaState);
    }

    @Override
    public long getLuaPointer() {
        if (this.isClosed()) {
            return 0L;
        }
        return this.luaState.lock(l -> this.rawGetLuaPointer());
    }

    public long rawGetLuaPointer() {
        if (!this.gotLuaPointer) {
            try {
                this.rawPush();
                long l = this.luaPointer = this.getLuaState().getLuaState().toPointer(-1);
                return l;
            }
            finally {
                this.luaState.getLuaState().pop(1);
                this.gotLuaPointer = true;
            }
        }
        return this.luaPointer;
    }

    @Override
    public boolean isRawEqualInLua(LuaObject other) {
        if (this.isClosed()) {
            return false;
        }
        return this.luaState.lock(l -> {
            try {
                this.rawPush();
                other.rawPush();
                Boolean bl = l.rawequal(-1, -2);
                return bl;
            }
            finally {
                l.pop(2);
            }
        });
    }

    public Result<Object, ? extends Exception> createProxy(String implem) throws LuaException {
        if (this.isClosed()) {
            return Result.failure(new LuaException("This lua state is closed"));
        }
        if (!this.isTable()) {
            throw new LuaException("Invalid Object. Must be Table.");
        }
        return this.luaState.lockThrowAll(L -> {
            StringTokenizer st = new StringTokenizer(implem, ",");
            Class[] interfaces = new Class[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                interfaces[i] = Class.forName(st.nextToken());
                ++i;
            }
            LuaInvocationHandler handler = new LuaInvocationHandler(this);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        });
    }

    private static final class CleanTask
    implements Runnable {
        private final LuaStateFacade luaState;
        private final Integer ref;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private CleanTask(LuaStateFacade luaState, Integer ref) {
            this.luaState = luaState;
            this.ref = ref;
        }

        @Override
        public void run() {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (this.luaState.isClosed()) {
                return;
            }
            try {
                this.luaState.lock(L -> {
                    if (L.getCPtrPeer() != 0L) {
                        L.LunRef(LuaState.LUA_REGISTRYINDEX, this.ref);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Unable to release object " + this.ref);
            }
        }
    }
}

