/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.debug.rsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.debug.LuaDebug;
import org.eu.smileyik.luajava.debug.rsp.DebugServer;
import org.eu.smileyik.luajava.debug.rsp.RspDebugServer;
import org.eu.smileyik.luajava.debug.rsp.breakPoint.BreakPoint;
import org.eu.smileyik.luajava.debug.rsp.command.hook.Command;
import org.eu.smileyik.luajava.debug.rsp.command.hook.ContinueCommand;
import org.eu.smileyik.luajava.debug.rsp.command.rsp.RspCommand;
import org.eu.smileyik.luajava.debug.util.AnsiMessageBuilder;

public class SimpleRspServer
implements BiConsumer<LuaStateFacade, LuaDebug>,
RspDebugServer {
    private static final Logger LOG = Logger.getLogger(SimpleRspServer.class.getName());
    private final int port;
    private boolean debugFlag = false;
    private final LuaStateFacade luaStateFacade;
    private final Set<BreakPoint> breakPoints = Collections.synchronizedSet(new HashSet());
    private final Lock commandLock = new ReentrantLock();
    private final LinkedList<Command> commands = new LinkedList();
    private final Condition commandReceive = this.commandLock.newCondition();
    private final Lock messageLock = new ReentrantLock();
    private final LinkedList<String> messageQueue = new LinkedList();
    private final Condition messageCondition = this.messageLock.newCondition();
    private final ExecutorService serverThread = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private OutputStream out;
    private boolean step = true;
    private Command continueType = ContinueCommand.INSTANCE;
    private LuaDebug currentDebugInfo;

    private SimpleRspServer(int port, LuaStateFacade luaStateFacade) {
        this.port = port;
        this.luaStateFacade = luaStateFacade;
        this.luaStateFacade.setDebugHook(this);
        this.luaStateFacade.getLuaState().setHook(4, 0);
    }

    public static DebugServer start(int port, LuaStateFacade luaStateFacade) throws ExecutionException, InterruptedException {
        CompletableFuture future = new CompletableFuture();
        new Thread(() -> {
            SimpleRspServer server = new SimpleRspServer(port, luaStateFacade);
            future.complete(server);
            server.start();
        }).start();
        return (DebugServer)future.get();
    }

    public RspDebugServer debug() {
        this.debugFlag = true;
        return this;
    }

    private void start() {
        this.serverThread.execute(() -> {
            try (ServerSocket server = new ServerSocket(this.port);){
                while (!Thread.currentThread().isInterrupted()) {
                    LOG.info("RSP server listening on port " + this.port);
                    Socket socket = server.accept();
                    try {
                        LOG.info("Accepted connection from " + String.valueOf(socket.getInetAddress()));
                        this.connected(socket);
                    }
                    finally {
                        if (socket == null) continue;
                        socket.close();
                    }
                }
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                LOG.info("RSP server closed");
            }
        });
    }

    private void connected(Socket socket) throws IOException {
        try (InputStream in = socket.getInputStream();
             OutputStream out = socket.getOutputStream();){
            int readByte;
            this.out = out;
            while ((readByte = in.read()) != -1) {
                if (readByte == 43 || readByte != 36) continue;
                StringBuilder commandBuilder = new StringBuilder();
                while ((readByte = in.read()) != 35) {
                    commandBuilder.append((char)readByte);
                }
                String command = commandBuilder.toString();
                this.debug("Debug Command: " + command);
                int checksumHigh = in.read();
                int checksumLow = in.read();
                out.write(43);
                this.dispatchCommand(out, command);
            }
        }
    }

    private void sendResponseAsync(String response) {
        this.executor.execute(() -> {
            try {
                this.sendResponse(this.out, response);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private synchronized void sendResponse(OutputStream out, String response) throws IOException {
        StringBuilder fullResponse = new StringBuilder("$");
        fullResponse.append(response);
        fullResponse.append("#");
        byte checksum = 0;
        for (int i = 1; i < fullResponse.length() - 1; ++i) {
            checksum = (byte)(checksum + (byte)fullResponse.charAt(i));
        }
        fullResponse.append(String.format("%02x", checksum & 0xFF));
        this.debug("Debug Response: " + String.valueOf(fullResponse));
        out.write(fullResponse.toString().getBytes(StandardCharsets.US_ASCII));
        out.flush();
    }

    private void dispatchCommand(OutputStream out, String command) throws IOException {
        String response = RspCommand.SIM_COMMAND_RESP.getOrDefault(command, "");
        if (!response.isEmpty()) {
            this.sendResponse(out, response);
            return;
        }
        try {
            Object innerCommand = command;
            String[] innerParams = null;
            if (command.startsWith("qRcmd")) {
                String[] innerArgs;
                String[] args = this.decodeFromHex(command.substring("qRcmd,".length())).split(" ");
                String[] stringArray = innerArgs = args.length > 1 ? args[1].split(",") : new String[]{};
                if (innerArgs.length > 0) {
                    String path = args[0] + "." + innerArgs[0];
                    innerParams = innerArgs;
                    innerCommand = RspCommand.COMMAND_MAP.containsKey(path) ? path : args[0];
                }
            } else if (command.startsWith("p")) {
                innerCommand = "p";
            }
            if (RspCommand.COMMAND_MAP.containsKey(innerCommand)) {
                response = RspCommand.COMMAND_MAP.get(innerCommand).handle(this, (String)innerCommand, innerParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendMessage("ERROR: " + e.getMessage() + "\n");
            response = "";
        }
        this.sendResponse(out, response);
    }

    private String message(String message) {
        if (!((String)message).replace("\u001b[0m", "").endsWith("\n")) {
            message = (String)message + "\n";
        }
        if (!((String)message).trim().startsWith("\u001b")) {
            message = "\u001b[34m" + (String)message + "\u001b[0m";
        }
        StringBuilder messageBuilder = new StringBuilder("O");
        ((String)message).chars().forEach(c -> messageBuilder.append(String.format("%02x", c)));
        return messageBuilder.toString();
    }

    private String decodeFromHex(String hex) {
        StringBuilder sb = new StringBuilder();
        int len = hex.length();
        for (int i = 0; i < len; i += 2) {
            sb.append((char)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(LuaStateFacade luaStateFacade, LuaDebug luaDebug) {
        boolean flag = this.step;
        if (!flag) {
            for (BreakPoint breakPoint : new HashSet<BreakPoint>(this.breakPoints)) {
                if (!breakPoint.enable() || !breakPoint.isInBreakPoint(luaStateFacade, luaDebug)) continue;
                flag = true;
                if (breakPoint.countDownRepeatTimes()) {
                    this.breakPoints.remove(breakPoint);
                }
                this.sendResponseAsync(this.message("BreakPoint: " + String.valueOf(breakPoint)));
                break;
            }
        }
        this.debug("----" + Objects.toString(luaDebug).replace("\n", "\\n"));
        if (flag) {
            SimpleRspServer simpleRspServer = this;
            synchronized (simpleRspServer) {
                this.currentDebugInfo = luaDebug;
                this.sendMessageAsync(this.getSourceLine(luaDebug));
            }
            this.sendResponseAsync("T05");
        }
        while (flag) {
            Command command = null;
            this.commandLock.lock();
            try {
                if (this.commands.isEmpty()) {
                    this.commandReceive.await();
                }
                command = this.commands.removeFirst();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.commandLock.unlock();
            }
            flag = command == null || !command.handle(this, luaStateFacade, luaDebug);
        }
    }

    private void debug(String message) {
        if (this.debugFlag) {
            LOG.info(message);
        }
    }

    private String getSourceLine(LuaDebug ar) {
        if (ar == null || ar.getSource() == null) {
            return AnsiMessageBuilder.builder().red("No debug info or no source info.").toMessage();
        }
        String message = AnsiMessageBuilder.builder().green("line ").bold().append(ar.getCurrentLine()).resetColor().green(": ").red("Could not find target source line.").newLine().toMessage();
        String source = ar.getSource();
        int idx = ar.getCurrentLine() - 1;
        if (idx < 0) {
            return message;
        }
        boolean flag = false;
        if (source.startsWith("@")) {
            try (Stream<String> lines = Files.lines(Paths.get(source.substring(1), new String[0]));){
                source = lines.skip(idx).findFirst().orElse(message);
                flag = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String[] split = source.split("\n");
            if (split.length > idx) {
                source = split[idx];
                flag = true;
            }
        }
        if (flag) {
            message = AnsiMessageBuilder.builder().green("line ").bold().append(ar.getCurrentLine()).resetColor().green(": ").bold().append(source).resetColor().newLine().toMessage();
        }
        return message;
    }

    @Override
    public LuaDebug getCurrentDebugInfo() {
        return this.currentDebugInfo;
    }

    @Override
    public void addCommand(Command command) {
        this.commandLock.lock();
        try {
            this.commands.addLast(command);
            this.commandReceive.signalAll();
        }
        finally {
            this.commandLock.unlock();
        }
    }

    @Override
    public void sendMessage(String message) throws IOException {
        this.sendResponse(this.message(message));
    }

    @Override
    public void sendMessageAsync(String message) {
        this.sendResponseAsync(this.message(message));
    }

    @Override
    public void sendResponse(String payload) throws IOException {
        this.sendResponse(this.out, payload);
    }

    @Override
    public void setContinueType(Command continueType) {
        this.continueType = continueType;
    }

    @Override
    public Command getContinueType() {
        return this.continueType;
    }

    @Override
    public void waitFillMessage() throws InterruptedException, IOException {
        this.messageLock.lock();
        try {
            this.messageCondition.await();
            while (!this.messageQueue.isEmpty()) {
                this.sendMessage(this.messageQueue.removeFirst());
            }
        }
        finally {
            this.messageLock.unlock();
        }
    }

    @Override
    public void finishedFillMessage() {
        this.messageLock.lock();
        try {
            this.messageCondition.signalAll();
        }
        finally {
            this.messageLock.unlock();
        }
    }

    @Override
    public void fillMessageQueue(String message) {
        this.messageQueue.addLast(message);
    }

    @Override
    public void close() {
        this.serverThread.shutdown();
    }

    @Override
    public DebugServer waitConnection() throws InterruptedException {
        this.commandLock.lock();
        try {
            this.commandReceive.await();
        }
        finally {
            this.commandLock.unlock();
        }
        return this;
    }

    @Override
    public boolean step() {
        return this.step;
    }

    @Override
    public void step(boolean flag) {
        this.step = flag;
    }

    @Override
    public void addBreakPoint(BreakPoint breakPoint) {
        this.breakPoints.add(breakPoint);
    }

    @Override
    public void removeBreakPoint(BreakPoint breakPoint) {
        this.breakPoints.remove(breakPoint);
    }

    @Override
    public LuaStateFacade getLuaStateFacade() {
        return this.luaStateFacade;
    }
}

