/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.debug.rsp.command.hook;

import java.util.Collections;
import java.util.Map;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.debug.LuaDebug;
import org.eu.smileyik.luajava.debug.rsp.RspDebugServer;
import org.eu.smileyik.luajava.debug.rsp.command.hook.Command;
import org.eu.smileyik.luajava.debug.util.AnsiMessageBuilder;
import org.eu.smileyik.luajava.debug.util.DebugUtils;

public class PrintVariableCommand
implements Command {
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_LOCAL = "local";
    public static final String SCOPE_UPVALUE = "upvalue";
    private final String scope;
    private final String variableName;
    private static final String[] DEEP_COLOR = new String[]{"\u001b[31m", "\u001b[32m", "\u001b[33m", "\u001b[34m", "\u001b[35m", "\u001b[36m", "\u001b[37m"};

    public PrintVariableCommand(String scope) {
        this(scope, null);
    }

    public PrintVariableCommand(String scope, String variableName) {
        this.scope = scope;
        this.variableName = variableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(RspDebugServer debugServer, LuaStateFacade facade, LuaDebug ar) {
        try {
            if (ar == null) {
                debugServer.fillMessageQueue(AnsiMessageBuilder.builder().red("Lua Debug info is not found!").toMessage());
            } else {
                Map<String, Object> variables = null;
                switch (this.scope) {
                    case "global": {
                        variables = DebugUtils.getGlobalVariable(facade, ar);
                        break;
                    }
                    case "local": {
                        variables = DebugUtils.getLocalVariable(facade, ar);
                        break;
                    }
                    case "upvalue": {
                        LuaState luaState = facade.getLuaState();
                        LuaDebug newAr = luaState.getInfo(ar, "f");
                        if (newAr != null) {
                            try {
                                variables = DebugUtils.getUpValues(facade, newAr);
                                break;
                            }
                            finally {
                                luaState.pop(1);
                            }
                        }
                        variables = Collections.emptyMap();
                        debugServer.fillMessageQueue(AnsiMessageBuilder.builder().red("Not in a closure!").toMessage());
                        break;
                    }
                }
                if (variables == null) {
                    debugServer.fillMessageQueue(AnsiMessageBuilder.builder().red("Not a valid variable scope!").toMessage());
                } else if (this.variableName == null) {
                    debugServer.fillMessageQueue(this.buildVariableMessage(variables, this.scope));
                } else {
                    debugServer.fillMessageQueue(this.buildVariableMessage(variables, this.scope, this.variableName));
                }
            }
        }
        finally {
            debugServer.finishedFillMessage();
        }
        return false;
    }

    protected String buildVariableMessage(Map<String, Object> variables, String type) {
        AnsiMessageBuilder message = new AnsiMessageBuilder();
        message.cyan("Currently has ").green().bold().append(variables.size()).resetColor().cyan(" ").purple(type).cyan(" variables.").newLine().resetColor();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            message.append("  ").purple(entry.getKey()).resetColor(" = ").green(this.colorVariableValue(entry.getValue())).newLine();
        }
        return message.resetColor().toMessage();
    }

    protected String buildVariableMessage(Map<String, Object> variables, String type, String name) {
        return AnsiMessageBuilder.builder().append("  ").cyan(type).resetColor(" ").purple(name).resetColor(" = ").green(this.colorVariableValue(variables.get(name))).resetColor().newLine().toMessage();
    }

    private static String getDeepColor(int idx) {
        return DEEP_COLOR[idx % DEEP_COLOR.length];
    }

    private String colorVariableValue(Object value) {
        String s = DebugUtils.variableToString(value).replace("\n", "\\n");
        if (!s.startsWith("{") || !s.endsWith("}")) {
            return s;
        }
        AnsiMessageBuilder message = new AnsiMessageBuilder();
        int len = s.length();
        int deep = 0;
        boolean inString = false;
        boolean equalsRight = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            Object afterAppend = null;
            if (c == '{') {
                message.append(PrintVariableCommand.getDeepColor(deep));
                afterAppend = "\u001b[0m";
                if (++deep > 1) {
                    afterAppend = (String)afterAppend + new AnsiMessageBuilder().append("\n  ").repeat(' ', deep << 1).purple().toMessage();
                }
            } else if (c == '}') {
                if (!inString) {
                    --deep;
                    if (i > 0 && s.charAt(i - 1) == '{') {
                        StringBuilder stringBuilder = message.getStringBuilder();
                        int length = stringBuilder.length() - 1;
                        while (stringBuilder.charAt(length) != '{') {
                            stringBuilder.deleteCharAt(length--);
                        }
                    } else {
                        message.append("\n  ").repeat(' ', deep << 1).append(PrintVariableCommand.getDeepColor(deep));
                    }
                }
            } else if (c == '\"') {
                if (inString) {
                    int j;
                    for (j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    }
                    if ((j - i & 1) == 1) {
                        inString = false;
                    }
                } else {
                    inString = true;
                }
            } else if (c == '=') {
                if (!inString) {
                    equalsRight = true;
                    message.resetColor();
                    afterAppend = "\u001b[32m";
                }
            } else if (c == ',') {
                if (!inString) {
                    equalsRight = false;
                    message.resetColor();
                }
            } else if (c == '[' && !inString && !equalsRight) {
                message.append("\n  ").repeat(' ', deep << 1).purple();
            }
            message.append(c);
            if (afterAppend == null) continue;
            message.append((String)afterAppend);
        }
        return message.resetColor().toMessage();
    }
}

