/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.debug.util;

public class AnsiMessageBuilder {
    public static final String ANSI_START = "\u001b";
    public static final String ANSI_BOLD = "\u001b[1m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BLACK_BACKGROUND = "\u001b[40m";
    public static final String ANSI_RED_BACKGROUND = "\u001b[41m";
    public static final String ANSI_GREEN_BACKGROUND = "\u001b[42m";
    public static final String ANSI_YELLOW_BACKGROUND = "\u001b[43m";
    public static final String ANSI_BLUE_BACKGROUND = "\u001b[44m";
    public static final String ANSI_PURPLE_BACKGROUND = "\u001b[45m";
    public static final String ANSI_CYAN_BACKGROUND = "\u001b[46m";
    public static final String ANSI_WHITE_BACKGROUND = "\u001b[47m";
    private final StringBuilder message = new StringBuilder();

    public static AnsiMessageBuilder builder() {
        return new AnsiMessageBuilder();
    }

    public StringBuilder getStringBuilder() {
        return this.message;
    }

    public AnsiMessageBuilder append(char c) {
        this.message.append(c);
        return this;
    }

    public AnsiMessageBuilder append(String message) {
        this.message.append(message);
        return this;
    }

    public AnsiMessageBuilder append(Object message) {
        this.message.append(message);
        return this;
    }

    public AnsiMessageBuilder append(AnsiMessageBuilder messageBuilder) {
        this.message.append((CharSequence)messageBuilder.message);
        return this.resetColor();
    }

    public AnsiMessageBuilder repeat(char c, int times) {
        return this.repeat("" + c, times);
    }

    public AnsiMessageBuilder repeat(String str, int times) {
        if (times <= 0) {
            return this;
        }
        StringBuilder append = new StringBuilder(str);
        StringBuilder result = new StringBuilder();
        while (times > 0) {
            if ((times & 1) == 1) {
                result.append((CharSequence)append);
            }
            append.append((CharSequence)append);
            times >>= 1;
        }
        return this.append(result.toString());
    }

    public String toMessage() {
        return this.message.toString();
    }

    public AnsiMessageBuilder resetColor() {
        return this.append(ANSI_RESET);
    }

    public AnsiMessageBuilder resetColor(String message) {
        return this.resetColor().append(message);
    }

    public AnsiMessageBuilder bold() {
        return this.append(ANSI_BOLD);
    }

    public AnsiMessageBuilder newLine() {
        return this.append("\n");
    }

    public AnsiMessageBuilder red() {
        return this.append(ANSI_RED);
    }

    public AnsiMessageBuilder red(String message) {
        return this.red().append(message);
    }

    public AnsiMessageBuilder green() {
        return this.append(ANSI_GREEN);
    }

    public AnsiMessageBuilder green(String message) {
        return this.green().append(message);
    }

    public AnsiMessageBuilder yellow() {
        return this.append(ANSI_YELLOW);
    }

    public AnsiMessageBuilder yellow(String message) {
        return this.yellow().append(message);
    }

    public AnsiMessageBuilder blue() {
        return this.append(ANSI_BLUE);
    }

    public AnsiMessageBuilder blue(String message) {
        return this.blue().append(message);
    }

    public AnsiMessageBuilder purple() {
        return this.append(ANSI_PURPLE);
    }

    public AnsiMessageBuilder purple(String message) {
        return this.purple().append(message);
    }

    public AnsiMessageBuilder cyan() {
        return this.append(ANSI_CYAN);
    }

    public AnsiMessageBuilder cyan(String message) {
        return this.cyan().append(message);
    }

    public AnsiMessageBuilder white() {
        return this.append(ANSI_WHITE);
    }

    public AnsiMessageBuilder white(String message) {
        return this.white().append(message);
    }

    public AnsiMessageBuilder blackBackground() {
        return this.append(ANSI_BLACK_BACKGROUND);
    }

    public AnsiMessageBuilder blackBackground(String message) {
        return this.blackBackground().append(message);
    }

    public AnsiMessageBuilder redBackground() {
        return this.append(ANSI_RED_BACKGROUND);
    }

    public AnsiMessageBuilder redBackground(String message) {
        return this.redBackground().append(message);
    }

    public AnsiMessageBuilder greenBackground() {
        return this.append(ANSI_GREEN_BACKGROUND);
    }

    public AnsiMessageBuilder greenBackground(String message) {
        return this.greenBackground().append(message);
    }

    public AnsiMessageBuilder yellowBackground() {
        return this.append(ANSI_YELLOW_BACKGROUND);
    }

    public AnsiMessageBuilder yellowBackground(String message) {
        return this.yellowBackground().append(message);
    }

    public AnsiMessageBuilder blueBackground() {
        return this.append(ANSI_BLUE_BACKGROUND);
    }

    public AnsiMessageBuilder blueBackground(String message) {
        return this.blueBackground().append(message);
    }

    public AnsiMessageBuilder purpleBackground() {
        return this.append(ANSI_PURPLE_BACKGROUND);
    }

    public AnsiMessageBuilder purpleBackground(String message) {
        return this.purpleBackground().append(message);
    }

    public AnsiMessageBuilder cyanBackground() {
        return this.append(ANSI_CYAN_BACKGROUND);
    }

    public AnsiMessageBuilder cyanBackground(String message) {
        return this.cyanBackground().append(message);
    }

    public AnsiMessageBuilder whiteBackground() {
        return this.append(ANSI_WHITE_BACKGROUND);
    }

    public AnsiMessageBuilder whiteBackground(String message) {
        return this.whiteBackground().append(message);
    }
}

