/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eu.smileyik.luajava.reflect.ConvertablePriority;
import org.eu.smileyik.luajava.reflect.IExecutable;
import org.eu.smileyik.luajava.reflect.IFieldAccessor;
import org.eu.smileyik.luajava.reflect.LuaInvokedMethod;
import org.eu.smileyik.luajava.reflect.ReflectExecutableCacheKey;
import org.eu.smileyik.luajava.util.ParamRef;

public interface ReflectUtil {
    public IFieldAccessor findFieldByName(Class<?> var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6);

    public LuaInvokedMethod<IExecutable<Constructor<?>>> findConstructorByParams(Class<?> var1, Object[] var2, boolean var3, boolean var4, boolean var5);

    public LinkedList<LuaInvokedMethod<IExecutable<Method>>> findMethodByParams(Class<?> var1, String var2, Object[] var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public boolean existsMethodByName(Class<?> var1, String var2, boolean var3, boolean var4, boolean var5);

    public LinkedList<LuaInvokedMethod<IExecutable<Method>>> findMethodByParams(ReflectExecutableCacheKey var1, Class<?> var2, String var3, Object[] var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public static void findSuperclasses(LinkedList<Class<?>> queue, Class<?> clazz) {
        Class<?>[] interfaces;
        if (clazz.getSuperclass() != null) {
            queue.addLast(clazz.getSuperclass());
        }
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i == null) continue;
            queue.addLast(i);
        }
    }

    public static boolean checkExecutableModifiers(Executable method, boolean ignoreNotPublic, boolean ignoreStatic, boolean ignoreNotStatic) {
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        if (ignoreStatic && isStatic) {
            return true;
        }
        if (ignoreNotStatic && !isStatic) {
            return true;
        }
        boolean isPublic = Modifier.isPublic(modifiers);
        return ignoreNotPublic && !isPublic;
    }

    public static <T extends Executable> int checkMethodPriority(T method, IExecutable<T> wrapperedMethod, LuaInvokedMethod<IExecutable<T>> currentMethod, List<LuaInvokedMethod<IExecutable<T>>> matchedList, int paramsCount, Object[] params, int priority, ParamRef<Object> overwrite) {
        int currentPriority = 0;
        Class<?>[] parameters = method.getParameterTypes();
        currentMethod.reset(wrapperedMethod);
        for (int i = 0; i < paramsCount; ++i) {
            if (currentPriority >= priority) {
                currentPriority = -1;
                break;
            }
            byte p = ConvertablePriority.isConvertableType(priority - currentPriority, params[i], parameters[i], overwrite);
            if (p == -1) {
                currentPriority = -1;
                overwrite.clear();
                break;
            }
            currentPriority += p;
            if (overwrite.isEmpty()) continue;
            currentMethod.overwriteParam(i, overwrite.getParamAndClear());
        }
        if (currentPriority != -1) {
            if (currentPriority < priority) {
                matchedList.clear();
                method.setAccessible(true);
                matchedList.add(currentMethod.done());
                return currentPriority;
            }
            if (currentPriority == priority) {
                method.setAccessible(true);
                matchedList.add(currentMethod.done());
                return currentPriority;
            }
        }
        return -1;
    }

    public static <T> T foreachClass(Class<?> clazz, boolean foreachInterface, Function<Class<?>, T> function) {
        HashSet visited = new HashSet();
        LinkedList stack = new LinkedList();
        stack.add(clazz);
        while (!stack.isEmpty()) {
            Class superclass;
            clazz = (Class)stack.pop();
            T apply = function.apply(clazz);
            if (apply != null) {
                return apply;
            }
            if (foreachInterface) {
                for (Class<?> i : clazz.getInterfaces()) {
                    if (!visited.add(i)) continue;
                    stack.push(i);
                }
            }
            if ((superclass = clazz.getSuperclass()) == null || !visited.add(superclass)) continue;
            stack.push(superclass);
        }
        return null;
    }
}

