/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eu.smileyik.luajava.reflect.ConvertablePriority;
import org.eu.smileyik.luajava.reflect.IExecutable;
import org.eu.smileyik.luajava.reflect.IFieldAccessor;
import org.eu.smileyik.luajava.reflect.LuaInvokedMethod;
import org.eu.smileyik.luajava.reflect.ReflectConstructor;
import org.eu.smileyik.luajava.reflect.ReflectExecutableCacheKey;
import org.eu.smileyik.luajava.reflect.ReflectField;
import org.eu.smileyik.luajava.reflect.ReflectFieldCacheKey;
import org.eu.smileyik.luajava.reflect.ReflectMethod;
import org.eu.smileyik.luajava.reflect.ReflectUtil;
import org.eu.smileyik.luajava.type.LuaArray;
import org.eu.smileyik.luajava.util.LRUCache;
import org.eu.smileyik.luajava.util.ParamRef;

public class SimpleReflectUtil
implements ReflectUtil {
    private static final Object EMPTY = new Object();
    private static final Function<Class<?>, Boolean> isAllowCache = clazz -> clazz != LuaArray.class;
    private final Map<ReflectExecutableCacheKey, Set<IExecutable<Method>>> cachedMethods;
    private final Map<ReflectExecutableCacheKey, Optional<IExecutable<Constructor<?>>>> cachedConstructors;
    private final Map<ReflectFieldCacheKey, IFieldAccessor> cachedFields;
    private final Map<ReflectExecutableCacheKey, Boolean> cachedExistsMethod;
    private final Map<Class<?>, Map<String, Set<Method>>> classMethods;
    private final Map<Class<?>, Map<String, Field>> classFields;

    public SimpleReflectUtil(int cacheCapacity) {
        this.cachedMethods = Collections.synchronizedMap(new LRUCache(cacheCapacity));
        this.cachedConstructors = Collections.synchronizedMap(new LRUCache(cacheCapacity));
        this.cachedFields = Collections.synchronizedMap(new LRUCache(cacheCapacity));
        this.cachedExistsMethod = Collections.synchronizedMap(new LRUCache(cacheCapacity));
        this.classMethods = Collections.synchronizedMap(new LRUCache(cacheCapacity));
        this.classFields = Collections.synchronizedMap(new LRUCache(cacheCapacity));
    }

    @Override
    public IFieldAccessor findFieldByName(Class<?> clazz, String name, boolean ignoreFinal, boolean ignoreStatic, boolean ignoreNotStatic, boolean ignoreNotPublic) {
        ReflectFieldCacheKey cacheKey = new ReflectFieldCacheKey(clazz, name, ignoreFinal, ignoreStatic, ignoreNotStatic, ignoreNotPublic);
        if (this.cachedFields.containsKey(cacheKey)) {
            return this.cachedFields.get(cacheKey);
        }
        Object target = ReflectUtil.foreachClass(clazz, false, currentClass -> {
            Field field = this.findFieldsByName(clazz, name);
            if (field != null) {
                int modifiers = field.getModifiers();
                if (ignoreFinal && Modifier.isFinal(modifiers)) {
                    return EMPTY;
                }
                if (ignoreStatic && Modifier.isStatic(modifiers)) {
                    return EMPTY;
                }
                if (ignoreNotStatic && !Modifier.isStatic(modifiers)) {
                    return EMPTY;
                }
                if (ignoreNotPublic && !Modifier.isPublic(modifiers)) {
                    return EMPTY;
                }
                return field;
            }
            return null;
        });
        if (target != null && target != EMPTY) {
            Field field = (Field)target;
            field.setAccessible(true);
            ReflectField reflectField = new ReflectField((Field)target);
            this.cachedFields.putIfAbsent(cacheKey, reflectField);
            return reflectField;
        }
        return null;
    }

    @Override
    public LuaInvokedMethod<IExecutable<Constructor<?>>> findConstructorByParams(Class<?> clazz, Object[] params, boolean ignoreNotPublic, boolean ignoreStatic, boolean ignoreNotStatic) {
        Optional<IExecutable<Constructor<?>>> result;
        boolean allowCache = true;
        int paramsCount = params == null ? 0 : params.length;
        Class[] paramTypes = new Class[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            Class clazz2 = paramTypes[i] = params[i] == null ? null : params[i].getClass();
            if (!allowCache) continue;
            allowCache = isAllowCache.apply(paramTypes[i]);
        }
        ReflectExecutableCacheKey cacheKey = null;
        if (allowCache && (result = this.cachedConstructors.get(cacheKey = new ReflectExecutableCacheKey(clazz, null, paramTypes, ignoreNotPublic, ignoreStatic, ignoreNotStatic))) != null) {
            if (result.isPresent()) {
                LuaInvokedMethod currentConst = new LuaInvokedMethod();
                currentConst.reset(result.get());
                Class<?>[] parameterTypes = ((Constructor)((IExecutable)currentConst.getExecutable()).getExecutable()).getParameterTypes();
                ParamRef<Object> overwrite = ParamRef.wrapper();
                for (int i = 0; i < paramsCount; ++i) {
                    ConvertablePriority.isConvertableType(Integer.MAX_VALUE, params[i], parameterTypes[i], overwrite);
                    if (overwrite.isEmpty()) continue;
                    currentConst.overwriteParam(i, overwrite.getParamAndClear());
                }
                return currentConst;
            }
            return null;
        }
        int priority = Integer.MAX_VALUE;
        ParamRef<Object> overwrite = ParamRef.wrapper();
        ReflectConstructor wrapper = new ReflectConstructor();
        LuaInvokedMethod currentConst = new LuaInvokedMethod();
        LinkedList matchedList = new LinkedList();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != paramsCount || ReflectUtil.checkExecutableModifiers(constructor, ignoreNotPublic, ignoreStatic, ignoreNotStatic)) continue;
            wrapper.setConstructor(constructor);
            int p = ReflectUtil.checkMethodPriority(constructor, wrapper, currentConst, matchedList, paramsCount, params, priority, overwrite);
            if (p != -1 && (priority = p) == 0) break;
        }
        LuaInvokedMethod target = null;
        if (!matchedList.isEmpty()) {
            target = (LuaInvokedMethod)matchedList.getFirst();
        }
        if (allowCache) {
            this.cachedConstructors.put(cacheKey, Optional.ofNullable(target == null ? null : (IExecutable)target.getExecutable()));
        }
        return target;
    }

    @Override
    public LinkedList<LuaInvokedMethod<IExecutable<Method>>> findMethodByParams(Class<?> clazz, String methodName, Object[] params, boolean justFirst, boolean ignoreNotPublic, boolean ignoreStatic, boolean ignoreNotStatic) {
        boolean allowCache = true;
        int paramsCount = params.length;
        Class[] paramTypes = new Class[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            Class clazz2 = paramTypes[i] = params[i] == null ? null : params[i].getClass();
            if (!allowCache) continue;
            allowCache = isAllowCache.apply(paramTypes[i]);
        }
        ReflectExecutableCacheKey cacheKey = null;
        LinkedList matchedList = new LinkedList();
        if (allowCache) {
            int currentPriority;
            IExecutable<Method> methodWrapper;
            Method method;
            cacheKey = new ReflectExecutableCacheKey(clazz, methodName, paramTypes);
            Set<IExecutable<Method>> cachedMethods = this.cachedMethods.get(cacheKey);
            if (cachedMethods == null) {
                return this.findMethodByParams(cacheKey, clazz, methodName, params, justFirst, ignoreNotPublic, ignoreStatic, ignoreNotStatic);
            }
            int priority = Integer.MAX_VALUE;
            ParamRef<Object> overwrite = ParamRef.wrapper();
            LuaInvokedMethod currentMethod = new LuaInvokedMethod();
            Iterator<IExecutable<Method>> iterator = cachedMethods.iterator();
            while (iterator.hasNext() && (ReflectUtil.checkExecutableModifiers(method = (methodWrapper = iterator.next()).getExecutable(), ignoreNotPublic, ignoreStatic, ignoreNotStatic) || (currentPriority = ReflectUtil.checkMethodPriority(method, methodWrapper, currentMethod, matchedList, paramsCount, params, priority, overwrite)) == -1 || (priority = currentPriority) != 0)) {
            }
        }
        if (matchedList.isEmpty()) {
            return this.findMethodByParams(cacheKey, clazz, methodName, params, justFirst, ignoreNotPublic, ignoreStatic, ignoreNotStatic);
        }
        if (justFirst && matchedList.size() > 1) {
            matchedList.subList(1, matchedList.size()).clear();
        }
        return matchedList;
    }

    @Override
    public boolean existsMethodByName(Class<?> clazz, String name, boolean ignoreNotPublic, boolean ignoreStatic, boolean ignoreNotStatic) {
        ReflectExecutableCacheKey cacheKey = new ReflectExecutableCacheKey(clazz, name, null, ignoreNotPublic, ignoreStatic, ignoreNotStatic);
        Boolean result = this.cachedExistsMethod.getOrDefault(cacheKey, null);
        if (result != null) {
            return result;
        }
        result = null != ReflectUtil.foreachClass(clazz, true, currentClass -> {
            for (Method method : this.findMethodsByName((Class<?>)currentClass, name)) {
                if (ReflectUtil.checkExecutableModifiers(method, ignoreNotPublic, ignoreStatic, ignoreNotStatic)) continue;
                return true;
            }
            return null;
        });
        this.cachedExistsMethod.putIfAbsent(cacheKey, result);
        return result;
    }

    @Override
    public LinkedList<LuaInvokedMethod<IExecutable<Method>>> findMethodByParams(ReflectExecutableCacheKey cacheKey, Class<?> clazz, final String methodName, final Object[] params, boolean justFirst, final boolean ignoreNotPublic, final boolean ignoreStatic, final boolean ignoreNotStatic) {
        if (cacheKey != null) {
            this.cachedMethods.computeIfAbsent(cacheKey, it -> new HashSet());
        }
        final ParamRef overwrite = ParamRef.wrapper();
        final LuaInvokedMethod currentMethod = new LuaInvokedMethod();
        final HashSet visited = new HashSet();
        final ReflectMethod wrapper = new ReflectMethod();
        final int paramsCount = params.length;
        final LinkedList<LuaInvokedMethod<IExecutable<Method>>> matchedList = new LinkedList<LuaInvokedMethod<IExecutable<Method>>>();
        ReflectUtil.foreachClass(clazz, true, new Function<Class<?>, Boolean>(){
            int priority = Integer.MAX_VALUE;

            @Override
            public Boolean apply(Class<?> currentClass) {
                for (Method method : SimpleReflectUtil.this.findMethodsByName(currentClass, methodName)) {
                    ReflectExecutableCacheKey check;
                    if (method.getParameterCount() != paramsCount || ReflectUtil.checkExecutableModifiers(method, ignoreNotPublic, ignoreStatic, ignoreNotStatic) || visited.contains(check = new ReflectExecutableCacheKey(null, methodName, method.getParameterTypes()))) continue;
                    wrapper.setMethod(method);
                    int currentPriority = ReflectUtil.checkMethodPriority(method, wrapper, currentMethod, matchedList, paramsCount, params, this.priority, overwrite);
                    if (currentPriority == -1) continue;
                    visited.add(check);
                    this.priority = currentPriority;
                    if (this.priority != 0) continue;
                    return true;
                }
                return null;
            }
        });
        if (cacheKey != null) {
            this.cachedMethods.get(cacheKey).addAll(matchedList.stream().map(LuaInvokedMethod::getExecutable).collect(Collectors.toSet()));
        }
        if (justFirst && matchedList.size() > 1) {
            matchedList.subList(1, matchedList.size()).clear();
        }
        return matchedList;
    }

    protected Set<Method> findMethodsByName(Class<?> clazz, String name) {
        Map<String, Set<Method>> map = this.classMethods.get(clazz);
        if (map != null) {
            return map.getOrDefault(name, Collections.emptySet());
        }
        HashMap methods = new HashMap();
        for (Method method : clazz.getDeclaredMethods()) {
            methods.computeIfAbsent(method.getName(), k -> new HashSet()).add(method);
        }
        this.classMethods.put(clazz, methods);
        return methods.getOrDefault(name, Collections.emptySet());
    }

    protected Field findFieldsByName(Class<?> clazz, String name) {
        Map<String, Field> map = this.classFields.get(clazz);
        if (map != null) {
            return map.getOrDefault(name, null);
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        this.classFields.put(clazz, fields);
        return fields.getOrDefault(name, null);
    }
}

