/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.type;

import java.util.Optional;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.type.LuaBoolean;
import org.eu.smileyik.luajava.type.LuaFunction;
import org.eu.smileyik.luajava.type.LuaNumber;
import org.eu.smileyik.luajava.type.LuaString;
import org.eu.smileyik.luajava.type.LuaTable;
import org.eu.smileyik.luajava.type.LuaUserdata;

public class InnerTypeHelper {
    public static Optional<LuaObject> createLuaObject(LuaStateFacade luaState, int idx) {
        return luaState.lock(l -> InnerTypeHelper.rawCreateLuaObject(luaState, idx));
    }

    public static Optional<LuaObject> rawCreateLuaObject(LuaStateFacade luaState, int idx) {
        int type = luaState.getLuaState().type(idx);
        switch (type) {
            case 6: {
                return Optional.of(new LuaFunction(luaState, idx));
            }
            case 5: {
                return Optional.of(LuaTable.rawCreateTable(luaState, idx));
            }
            case 1: {
                return Optional.of(new LuaBoolean(luaState, idx));
            }
            case 3: {
                return Optional.of(new LuaNumber(luaState, idx));
            }
            case 7: {
                return Optional.of(new LuaUserdata(luaState, idx));
            }
            case 4: {
                return Optional.of(new LuaString(luaState, idx));
            }
        }
        return Optional.empty();
    }
}

