/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class BoxedTypeHelper {
    private static final Set<Class<?>> UNBOXED_NUMBER_TYPE;
    private static final Map<Class<?>, Class<?>> BOXED_2_UNBOXED_TYPES;
    private static final Map<Class<?>, Class<?>> UNBOXED_2_BOXED_TYPES;
    private static final Map<Class<?>, Function<Double, Number>> NUMBER_TRANSFORM;
    private static final Map<Class<?>, Function<Object, String>> ARRAY_TO_STRING;

    public static boolean isBoxedType(Class<?> type) {
        return BOXED_2_UNBOXED_TYPES.containsKey(type);
    }

    public static boolean isUnboxedType(Class<?> type) {
        return UNBOXED_2_BOXED_TYPES.containsKey(type);
    }

    public static Class<?> getUnboxedType(Class<?> type) {
        return BOXED_2_UNBOXED_TYPES.getOrDefault(type, type);
    }

    public static Class<?> getBoxedType(Class<?> type) {
        return UNBOXED_2_BOXED_TYPES.getOrDefault(type, type);
    }

    public static boolean isNumberType(Class<?> type) {
        return BoxedTypeHelper.isBoxedNumberType(type) || BoxedTypeHelper.isUnboxedNumberType(type);
    }

    public static boolean isBoxedNumberType(Class<?> type) {
        return Number.class.isAssignableFrom(type);
    }

    public static boolean isUnboxedNumberType(Class<?> type) {
        return UNBOXED_NUMBER_TYPE.contains(type);
    }

    public static Number covertNumberTo(Double db, Class<?> target) {
        Function<Double, Number> function = NUMBER_TRANSFORM.get(target);
        return function == null ? (Number)null : (Number)function.apply(db);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> aClass = obj.getClass();
        if (aClass.isArray()) {
            Function<Object, String> func;
            Class<?> componentType = aClass.getComponentType();
            boolean flag = true;
            while (componentType.isArray()) {
                flag = false;
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive() && flag && (func = ARRAY_TO_STRING.get(componentType)) != null) {
                return func.apply(obj);
            }
            if (!componentType.isPrimitive()) {
                return Arrays.deepToString((Object[])obj);
            }
        }
        return Objects.toString(obj);
    }

    static {
        ARRAY_TO_STRING = new HashMap();
        HashMap<Class, Class> boxed2UnboxedType = new HashMap<Class, Class>();
        boxed2UnboxedType.put(Boolean.class, Boolean.TYPE);
        boxed2UnboxedType.put(Byte.class, Byte.TYPE);
        boxed2UnboxedType.put(Character.class, Character.TYPE);
        boxed2UnboxedType.put(Double.class, Double.TYPE);
        boxed2UnboxedType.put(Float.class, Float.TYPE);
        boxed2UnboxedType.put(Integer.class, Integer.TYPE);
        boxed2UnboxedType.put(Long.class, Long.TYPE);
        boxed2UnboxedType.put(Short.class, Short.TYPE);
        BOXED_2_UNBOXED_TYPES = Collections.unmodifiableMap(boxed2UnboxedType);
        HashMap unboxed2boxedType = new HashMap();
        boxed2UnboxedType.forEach((k, v) -> unboxed2boxedType.put(v, k));
        UNBOXED_2_BOXED_TYPES = Collections.unmodifiableMap(unboxed2boxedType);
        HashSet<Class<Number>> unboxedNumberType = new HashSet<Class<Number>>();
        unboxedNumberType.add(Integer.TYPE);
        unboxedNumberType.add(Long.TYPE);
        unboxedNumberType.add(Float.TYPE);
        unboxedNumberType.add(Double.TYPE);
        unboxedNumberType.add(Short.TYPE);
        unboxedNumberType.add(Byte.TYPE);
        UNBOXED_NUMBER_TYPE = Collections.unmodifiableSet(unboxedNumberType);
        HashMap<Class<Number>, Function> numberTransform = new HashMap<Class<Number>, Function>();
        numberTransform.put(Double.class, Number::doubleValue);
        numberTransform.put(Float.class, Number::floatValue);
        numberTransform.put(Integer.class, Number::intValue);
        numberTransform.put(Long.class, Number::longValue);
        numberTransform.put(Short.class, Number::shortValue);
        numberTransform.put(Byte.class, Number::byteValue);
        numberTransform.put(Double.TYPE, (Function)numberTransform.get(Double.class));
        numberTransform.put(Float.TYPE, (Function)numberTransform.get(Float.class));
        numberTransform.put(Integer.TYPE, (Function)numberTransform.get(Integer.class));
        numberTransform.put(Long.TYPE, (Function)numberTransform.get(Long.class));
        numberTransform.put(Short.TYPE, (Function)numberTransform.get(Short.class));
        numberTransform.put(Byte.TYPE, (Function)numberTransform.get(Byte.class));
        NUMBER_TRANSFORM = Collections.unmodifiableMap(numberTransform);
        ARRAY_TO_STRING.put(Integer.TYPE, obj -> Arrays.toString((int[])obj));
        ARRAY_TO_STRING.put(Long.TYPE, obj -> Arrays.toString((long[])obj));
        ARRAY_TO_STRING.put(Double.TYPE, obj -> Arrays.toString((double[])obj));
        ARRAY_TO_STRING.put(Boolean.TYPE, obj -> Arrays.toString((boolean[])obj));
        ARRAY_TO_STRING.put(Byte.TYPE, obj -> Arrays.toString((byte[])obj));
        ARRAY_TO_STRING.put(Character.TYPE, obj -> Arrays.toString((char[])obj));
        ARRAY_TO_STRING.put(Short.TYPE, obj -> Arrays.toString((short[])obj));
        ARRAY_TO_STRING.put(Float.TYPE, obj -> Arrays.toString((float[])obj));
    }
}

