/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava.util;

import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.LinkedList;

public class ResourceCleaner
implements Runnable,
Closeable {
    private static final ResourceCleaner INSTANCE = new ResourceCleaner();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final LinkedList<Ref> refs = new LinkedList();
    private final Thread cleanerThread = new Thread(this);

    public static ResourceCleaner getInstance() {
        return INSTANCE;
    }

    public ResourceCleaner() {
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.setName("ResourceCleaner");
        this.cleanerThread.start();
    }

    @Override
    public void run() {
        this.monitorTask();
    }

    public synchronized PhantomReference<Object> register(Object o, Runnable finalizer) {
        Ref ref = new Ref(o, this.referenceQueue, finalizer);
        this.refs.add(ref);
        return ref;
    }

    @Override
    public synchronized void close() {
        this.cleanerThread.interrupt();
    }

    private void monitorTask() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Ref removed = (Ref)this.referenceQueue.remove();
                removed.clean();
                this.refs.remove(removed);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private static final class Ref
    extends PhantomReference<Object> {
        private final Runnable finalizer;

        public Ref(Object referent, ReferenceQueue<? super Object> q, Runnable finalizer) {
            super(referent, q);
            this.finalizer = finalizer;
        }

        public void clean() {
            this.finalizer.run();
        }
    }
}

