/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.common.GuitaBackpacks;
import org.jetbrains.annotations.NotNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(EnvType.CLIENT)
public class EquipmentScreen extends class_465<EquipmentScreenHandler> {

	private static final class_2960 BACKGROUND_TEXTURE = GuitaBackpacks.id("background");
	private static final class_2960 INVENTORY_AND_HOTBAR_TEXTURE = GuitaBackpacks.id("inventory/inventory_and_hotbar");
	private static final class_2960 SLOT_TEXTURE = class_2960.method_60656("container/slot");

	public EquipmentScreen(EquipmentScreenHandler handler, class_1661 inventory, class_2561 title) {
		super(handler, inventory, title);
	}

	@Override
	protected void method_2389(@NotNull class_332 context, float delta, int mouseX, int mouseY) {
		int guiX = (this.field_22789 - this.field_2792) / 2;
		int guiY = (this.field_22790 - this.field_2779) / 2;

		int yDisplacement = 66;
		context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, guiX, guiY + yDisplacement, this.field_2792, this.field_2779 - yDisplacement);
		context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, guiX + 75, guiY + 38, 26, 26);
		context.method_52706(class_10799.field_56883, INVENTORY_AND_HOTBAR_TEXTURE, guiX + 7, guiY + 83, 162, 76);
		context.method_52706(class_10799.field_56883, SLOT_TEXTURE, guiX + 79, guiY + 42, 18, 18);
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		method_25420(context, mouseX, mouseY, delta);
		super.method_25394(context, mouseX, mouseY, delta);
		method_2380(context, mouseX, mouseY);
	}
}
