/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui.widgets;

import com.macuguita.backpacks.client.gui.BackpackCustomizationScreen;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

@Environment(EnvType.CLIENT)
public class CustomizationWidget extends class_339 {

	public static final class_2960 WIDGET_ICON = GuitaBackpacks.id("textures/gui/widget/customize.png");
	private final int slotIndex;
	private final class_1799 backpack;
	public final class_437 parent;

	public CustomizationWidget(int x, int y, int width, int height, class_2561 message, class_437 parent, int slotIndex) {
		super(x, y, width, height, message);
		this.parent = parent;
		this.slotIndex = slotIndex;
		this.backpack = EquipmentUtils.getBackpackFromSlotIndex(class_310.method_1551().field_1724, slotIndex);
	}

	@Override
	protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		if (backpack.method_7960()) return;
		context.method_25290(class_10799.field_56883, WIDGET_ICON, method_46426(), method_46427(), 0, 0,
				this.field_22758, this.field_22759, 10, 10);
	}

	@Override
	protected void method_47399(class_6382 builder) {
		if (backpack.method_7960()) return;
		builder.method_37034(class_6381.field_33788, class_2561.method_43471("narration.gbackpacks.customization_widget"));
	}

	@Override
	public void method_25348(class_11909 click, boolean doubled) {
		if (backpack.method_7960()) return;
		super.method_25348(click, doubled);
		class_310 client = class_310.method_1551();
		client.method_1507(new BackpackCustomizationScreen(class_2561.method_43471("gui.gbackpacks.customization"), parent, slotIndex));
	}
}
