/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.model;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public class GBModelReloadListener implements class_4013 {
	public static final GBModelReloadListener INSTANCE = new GBModelReloadListener();
	public static final class_2960 ID = class_2960.method_60655("backpacks", "model_reload_listener");

	private final Map<class_2960, class_1087> loadedModels = new HashMap<>();

	@Override
	public void method_14491(class_3300 manager) {
		loadedModels.clear();

		var client = class_310.method_1551();

		for (var entry : GBModelLoadingPlugin.getBlockStateModels().entrySet()) {
			class_2960 id = entry.getKey();
			var key = entry.getValue();
			class_1087 model = client.method_1554().getModel(key);
			if (model != null) {
				loadedModels.put(id, model);
			}
		}
	}

	public class_1087 getModel(class_2960 id) {
		return loadedModels.get(id);
	}
}
