/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.payload;

import java.util.List;

import com.macuguita.backpacks.client.GuitaBackpacksClient;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.resourcereloader.BackpacksResourceReloadListener;
import org.jetbrains.annotations.NotNull;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BackpackListSyncPayload(
		List<BackpacksResourceReloadListener.Backpack> list) implements class_8710 {

	public static final class_8710.class_9154<BackpackListSyncPayload> ID = new class_8710.class_9154<>(GuitaBackpacks.id("backpack_list_sync"));

	public static final class_9139<class_9129, BackpackListSyncPayload> CODEC = class_9135.method_58002(
			BackpacksResourceReloadListener.Backpack.CODEC.listOf()
	).method_56432(
			BackpackListSyncPayload::new,
			BackpackListSyncPayload::list
	);

	@Override
	public class_8710.@NotNull class_9154<? extends class_8710> method_56479() {
		return ID;
	}

	public static void send(class_3222 player, List<BackpacksResourceReloadListener.Backpack> list) {
		ServerPlayNetworking.send(player, new BackpackListSyncPayload(list));
	}

	public static class Receiver implements ClientPlayNetworking.PlayPayloadHandler<BackpackListSyncPayload> {

		@Override
		public void receive(@NotNull BackpackListSyncPayload payload, ClientPlayNetworking.Context context) {
			GuitaBackpacksClient.BACKPACKS.clear();
			GuitaBackpacksClient.BACKPACKS.addAll(payload.list());
		}
	}
}
