/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_2350;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import com.macuguita.backpacks.client.model.GBModelReloadListener;
import com.macuguita.backpacks.client.render.state.BlockStateGuiElementRenderState;
import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.NotNull;

// sources: https://github.com/ZurrTum/Create-Fly/blob/v6.0.7-15/src/client/java/com/zurrtum/create/client/foundation/gui/render/ManualBlockRenderer.java
public class BlockStateGuiRenderer extends class_11239<BlockStateGuiElementRenderState> {
	public static final int MAX = 6;
	private int allocate = MAX;
	private static final Deque<GpuTexture> TEXTURES = new ArrayDeque<>(MAX);
	private final class_4587 matrices = new class_4587();
	private int windowScaleFactor;

	public BlockStateGuiRenderer(class_4597.class_4598 vertexConsumers) {
		super(vertexConsumers);
	}

	@Override
	public @NotNull Class<BlockStateGuiElementRenderState> method_70903() {
		return BlockStateGuiElementRenderState.class;
	}

	@Override
	public void prepare(BlockStateGuiElementRenderState renderState, class_11246 guiRenderState, int guiScale) {
		class_310 mc = class_310.method_1551();

		// Manage framebuffer reuse (same logic as Create)
		if (this.windowScaleFactor != guiScale) {
			this.windowScaleFactor = guiScale;
			TEXTURES.forEach(GpuTexture::close);
			TEXTURES.clear();
			allocate = MAX;
		}

		int size = 27 * guiScale;
		GpuTexture texture;
		if (allocate > 0) {
			allocate--;
			texture = GpuTexture.create(size);
		} else {
			texture = TEXTURES.poll();
			assert texture != null;
		}

		RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
		texture.prepare();

		matrices.method_22903();
		matrices.method_46416(size / 2.0F, size, 0.0F);
		float scale = 20 * guiScale;
		matrices.method_22905(scale, scale, scale);

		mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);

		// Fancy camera transform for the model
		matrices.method_22907(class_7833.field_40714.rotationDegrees(-30));
		matrices.method_22907(class_7833.field_40716.rotationDegrees(45));
		matrices.method_46416(-0.5f, -0.5f, -0.5f);
		matrices.method_22905(1, -1, 1);

		var model = GBModelReloadListener.INSTANCE.getModel(renderState.modelId());
		if (model != null) {
			class_4588 buffer = field_59933.method_73477(class_4722.method_24074());
			int light = 0xF000F0;
			int overlay = class_4608.field_21444;

			for (var part : model.method_68512(mc.field_1687 != null ? mc.field_1687.field_9229 : class_5819.method_43047())) {
				for (var dir : class_2350.values()) {
					for (var quad : part.method_68509(dir)) {
						buffer.method_22919(matrices.method_23760(), quad, 1f, 1f, 1f, 1f, light, overlay);
					}
				}
				for (var quad : part.method_68509(null)) {
					buffer.method_22919(matrices.method_23760(), quad, 1f, 1f, 1f, 1f, light, overlay);
				}
			}

			field_59933.method_22993();
		}

		matrices.method_22909();
		texture.clear();

		guiRenderState.method_71996(new class_11241(
				class_10799.field_59968,
				class_11231.method_70900(texture.textureView()),
				renderState.method_72127(),
				renderState.comp_4122(),
				renderState.comp_4123(),
				renderState.comp_4124(),
				renderState.comp_4125(),
				0.0F,
				1.0F,
				1.0F,
				0.0F,
				-1,
				null,
				null
		));

		TEXTURES.add(texture);
	}

	@Override
	protected void renderToTexture(BlockStateGuiElementRenderState renderState, class_4587 poseStack) {}

	@Override
	protected @NotNull String method_70906() {
		return "blockstate gui renderer";
	}
}
