/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.block;

import java.util.Map;
import java.util.UUID;

import com.macuguita.backpacks.common.block.entity.BackpackBlockEntity;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.item.BackpackItem;
import com.macuguita.backpacks.common.reg.GBComponents;
import com.macuguita.backpacks.common.reg.GBObjects;
import com.macuguita.backpacks.common.resourcereloader.BackpacksResourceReloadListener;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public class BackpackBlock extends class_2237 implements class_2343 {

	public static final class_2754<class_2350> FACING = class_2741.field_12481;

	public BackpackBlock(class_2251 settings) {
		super(settings);
		this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
	}

	@Override
	protected @NotNull MapCodec<? extends class_2237> method_53969() {
		return method_54094(BackpackBlock::new);
	}

	@Override
	public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new BackpackBlockEntity(pos, state);
	}

	@Override
	public @NotNull class_2680 method_9576(@NotNull class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
		class_2586 be = level.method_8321(pos);
		if (be instanceof BackpackBlockEntity backpack) {
			class_1799 stack = new class_1799(GBObjects.BACKPACK.get());

			stack.method_57379(GBComponents.BACKPACK_MODEL_ID.get(), backpack.getItemModelId());
			stack.method_57379(GBComponents.BACKPACK_UUID.get(), backpack.getUuid());
			class_1542 itemEntity = new class_1542(level, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, stack);

			itemEntity.method_6988();
			level.method_8649(itemEntity);
		}
		return super.method_9576(level, pos, state, player);
	}

	@Override
	protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING);
	}

	@Override
	protected boolean method_9579(class_2680 state) {
		return true;
	}

	@Override
	public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
		return 1.0F;
	}

	@Override
	public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
		return false;
	}

	@Override
	protected int method_9572(class_2680 state, class_1937 level, class_2338 pos, class_2350 direction) {
		return class_1703.method_7618(getInventory(level, pos, level.method_8503()));
	}

	@Override
	protected boolean method_9498(class_2680 state) {
		return true;
	}

	private @Nullable class_1277 getInventory(@NotNull class_1922 level, class_2338 pos, MinecraftServer server) {
		class_2586 be = level.method_8321(pos);
		if (be instanceof BackpackBlockEntity backpack) {
			UUID uuid = backpack.getUuid();
			if (server != null) {
				return GuitaBackpacksComponents.BACKPACKS_COMPONENT.get(server.method_3845()).getInventory(uuid);
			}
		}
		return null;
	}

	@Override
	public class_2680 method_9605(@NotNull class_1750 ctx) {
		return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
	}

	@Override
	protected @NotNull class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
		if (level instanceof class_3218 serverLevel) {
			class_2586 be = level.method_8321(pos);
			if (be instanceof BackpackBlockEntity backpackBe) {
				UUID uuid = backpackBe.getUuid();
				if (uuid != null) {
					class_1277 inventory = getInventory(level, pos, player.method_73183().method_8503());
					if (inventory == null) {
						GuitaBackpacksComponents.BACKPACKS_COMPONENT.get(serverLevel.method_14170()).addInventory(uuid);
						inventory = getInventory(level, pos, player.method_73183().method_8503());
					}
					BackpackItem.openBackpack(player, inventory, -1);
					return class_1269.field_52422;
				}
			}
		}
		return class_1269.field_5812;
	}

	@Override
	protected @NotNull class_2680 method_9598(@NotNull class_2680 state, @NotNull class_2470 rotation) {
		return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
	}

	@Override
	protected @NotNull class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
		return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
	}

	private class_265 getVoxelShape(@NotNull class_1922 level, class_2338 pos) {
		class_2586 be = level.method_8321(pos);
		if (be instanceof BackpackBlockEntity backpack && backpack.getItemModelId() != null) {
			class_2960 modelId = backpack.getItemModelId();

			class_265 shape = class_259.method_1078(
					BackpacksResourceReloadListener.BACKPACKS.stream()
							.filter(bp -> bp.id().equals(modelId))
							.findFirst()
							.map(BackpacksResourceReloadListener.Backpack::blockCollisionShape)
							.orElse(new class_238(0, 0, 0, 1, 1, 1))
			);

			Map<class_2350, class_265> shapes = class_259.method_66501(shape);

			return shapes.get(level.method_8320(pos).method_11654(FACING));
		}
		return class_259.method_1077();
	}

	@Override
	protected @NotNull class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
		return getVoxelShape(level, pos);
	}

	@Override
	protected @NotNull class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
		return getVoxelShape(level, pos);
	}
}
