/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.item;

import java.util.UUID;

import com.macuguita.backpacks.GBConfig;
import com.macuguita.backpacks.client.gui.BackpackScreenHandler;
import com.macuguita.backpacks.client.gui.payload.BackpackInventoryPayload;
import com.macuguita.backpacks.common.block.entity.BackpackBlockEntity;
import com.macuguita.backpacks.common.components.BackpacksComponent;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.reg.GBComponents;
import com.macuguita.backpacks.common.utils.BackpackUtils;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_638;

public class BackpackItem extends class_1747 {

	public BackpackItem(class_2248 block, class_1793 settings) {
		super(block, settings);
	}

	private static void toggleVisibility(@NotNull class_1799 stack) {
		Boolean visible = stack.method_58694(GBComponents.VISIBLE.get());
		boolean newValue = visible == null || !visible;
		stack.method_57379(GBComponents.VISIBLE.get(), newValue);
	}

	public static void openOrCreateBackpackIfNotExists(class_1657 player, int slotIndex) {
		class_1799 backpack = EquipmentUtils.getBackpackFromSlotIndex(player, slotIndex);

		if (backpack.method_7960()) {
			return;
		}

		UUID uuid = backpack.method_58694(GBComponents.BACKPACK_UUID.get());
		if (uuid == null && player.method_73183() instanceof class_3218) {
			if (!backpack.method_57826(GBComponents.BACKPACK_UUID.get())) {
				backpack.method_57379(GBComponents.BACKPACK_UUID.get(), UUID.randomUUID());
			}
			uuid = backpack.method_58694(GBComponents.BACKPACK_UUID.get());
		}

		BackpacksComponent backpacksComponent = GuitaBackpacksComponents.BACKPACKS_COMPONENT.get(player.method_73183().method_8428());
		class_1277 inventory = backpacksComponent.getInventory(uuid);
		if (inventory == null) {
			backpacksComponent.addInventory(uuid);
			inventory = backpacksComponent.getInventory(uuid);
		}
		openBackpack(player, inventory, slotIndex);
	}

	@SuppressWarnings("rawtypes")
	public static void openBackpack(@NotNull class_1657 player, class_1277 inventory, int slotIndex) {
		var factory = new ExtendedScreenHandlerFactory() {

			@Override
			public @NotNull class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
				return new BackpackScreenHandler(syncId, playerInventory, inventory, slotIndex);
			}

			@Contract(value = " -> new", pure = true)
			@Override
			public @NotNull class_2561 method_5476() {
				return class_2561.method_43471("gui.gbackpacks.backpack");
			}

			@Contract("_ -> new")
			@Override
			public @NotNull Object getScreenOpeningData(class_3222 player) {
				return new BackpackInventoryPayload(inventory.method_5439(), slotIndex);
			}
		};

		player.method_17355(factory);
	}

	@Override
	public void method_7888(class_1799 stack, class_3218 level, class_1297 entity, @Nullable class_1304 slot) {
		super.method_7888(stack, level, entity, slot);
		if (level instanceof class_3218) {
			if (!stack.method_7960() && !stack.method_57826(GBComponents.BACKPACK_UUID.get())) {
				stack.method_57379(GBComponents.BACKPACK_UUID.get(), UUID.randomUUID());
			}
			if (entity instanceof class_1657 player)
				BackpackUtils.checkForDuplicateBackpacks(player, stack.method_58694(GBComponents.BACKPACK_UUID.get()), stack);
		}
	}

	@Override
	public @NotNull class_1269 method_7836(class_1937 level, @NotNull class_1657 user, class_1268 hand) {
		class_1799 stack = user.method_5998(hand);
		if (stack.method_57826(GBComponents.BACKPACK_UUID.get())) {
			if (level instanceof class_3218) {
				// Find the slot index of the backpack
				int slotIndex = user.method_31548().method_7395(stack);
				if (slotIndex != -1) {
					openOrCreateBackpackIfNotExists(user, slotIndex);
				}
			} else if (level instanceof class_638 clientLevel) {
				class_243 pos = user.method_73189();
				clientLevel.method_8486(
						pos.field_1352, pos.field_1351, pos.field_1350,
						class_3417.field_34376,
						class_3419.field_15248,
						1.0f, 1.0f,
						false
				);
			}
		} else {
			return class_1269.field_5814;
		}
		return super.method_7836(level, user, hand);
	}

	@Override
	protected boolean method_7710(class_2338 pos, @NotNull class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
		class_2586 be = level.method_8321(pos);
		if (be instanceof BackpackBlockEntity backpack) {
			if (stack.method_57826(GBComponents.BACKPACK_UUID.get())) {
				backpack.setUuid(stack.method_58694(GBComponents.BACKPACK_UUID.get()));
			}
			if (stack.method_57826(GBComponents.BACKPACK_MODEL_ID.get())) {
				class_2960 modelId = stack.method_58694(GBComponents.BACKPACK_MODEL_ID.get());
				if (modelId == null) return super.method_7710(pos, level, player, stack, state);
				backpack.setItemModelId(modelId);

				String namespace = modelId.method_12836();
				String path = modelId.method_12832();
				path = path.replaceFirst("^backpacks/", "backpacks/blocks/");

				class_2960 newModelId = class_2960.method_60655(namespace, path);

				backpack.setBlockModelId(newModelId);
			}
		}
		return super.method_7710(pos, level, player, stack, state);
	}

	@Override
	public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
		if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
			toggleVisibility(stack);
			return true;
		}
		return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
	}

	@Override
	public void method_33261(class_1542 entity) {
		super.method_33261(entity);
		class_1799 stack = entity.method_6983();
		if (stack.method_57826(GBComponents.BACKPACK_UUID.get())) {
			UUID uuid = stack.method_58694(GBComponents.BACKPACK_UUID.get());
			if (Boolean.TRUE.equals(GBConfig.getBackpackDropItemsOnDestroyed())) {
				class_1277 inv = GuitaBackpacksComponents.BACKPACKS_COMPONENT.get(entity.method_73183().method_8428()).getInventory(uuid);
				class_5328.method_33263(entity, inv.field_5828);
			}
			if (Boolean.TRUE.equals(GBConfig.getBackpackEntriesGetRemoved())) {
				GuitaBackpacksComponents.BACKPACKS_COMPONENT.get(entity.method_73183().method_8428()).removeBackpack(uuid);
			}
		}
	}
}
