/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.payload;

import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.reg.GBComponents;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import org.jetbrains.annotations.NotNull;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record BackpackCosmeticSyncPayload(int slotIndex, class_2960 newId) implements class_8710 {

	public static final class_8710.class_9154<BackpackCosmeticSyncPayload> ID = new class_8710.class_9154<>(GuitaBackpacks.id("backpack_cosmetic_sync"));

	public static final class_9139<class_9129, BackpackCosmeticSyncPayload> CODEC = class_9139.method_56435(
			class_9135.field_49675,
			BackpackCosmeticSyncPayload::slotIndex,
			class_2960.field_48267,
			BackpackCosmeticSyncPayload::newId,
			BackpackCosmeticSyncPayload::new
	);

	@Override
	public @NotNull class_9154<? extends class_8710> method_56479() {
		return ID;
	}

	public static void send(int slotIndex, class_2960 newId) {
		ClientPlayNetworking.send(new BackpackCosmeticSyncPayload(slotIndex, newId));
	}

	public static class Receiver implements ServerPlayNetworking.PlayPayloadHandler<BackpackCosmeticSyncPayload> {

		@Override
		public void receive(BackpackCosmeticSyncPayload payload, ServerPlayNetworking.@NotNull Context context) {
			class_3222 player = context.player();

			if (payload.slotIndex == -1) {
				return;
			}

			class_1799 backpack = EquipmentUtils.getBackpackFromSlotIndex(player, payload.slotIndex);
			if (backpack.method_7960() || !backpack.method_57826(GBComponents.BACKPACK_MODEL_ID.get())) {
				return;
			}

			backpack.method_57379(GBComponents.BACKPACK_MODEL_ID.get(), payload.newId());

			if (!EquipmentUtils.isTrinketsLoaded() && payload.slotIndex >= 20000) {
				GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get(player).getInventory().method_5431();
			}
		}
	}
}
