/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.payload;

import com.macuguita.backpacks.client.gui.EquipmentScreenHandler;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record OpenEquipmentPayload() implements class_8710 {

	public static final class_9154<OpenEquipmentPayload> ID = new class_9154<>(GuitaBackpacks.id("open_equipment"));

	public static final class_9139<class_9129, OpenEquipmentPayload> CODEC = class_9139.method_56431(new OpenEquipmentPayload());

	@Override
	public @NotNull class_9154<? extends class_8710> method_56479() {
		return ID;
	}

	public static void send() {
		ClientPlayNetworking.send(new OpenEquipmentPayload());
	}

	public static class Receiver implements ServerPlayNetworking.PlayPayloadHandler<OpenEquipmentPayload> {

		@Override
		public void receive(OpenEquipmentPayload payload, ServerPlayNetworking.Context context) {
			if (EquipmentUtils.isTrinketsLoaded()) return;
			class_3222 player = context.player();
			var factory = new class_3908() {

				@Contract(value = " -> new", pure = true)
				@Override
				public @NotNull class_2561 method_5476() {
					return class_2561.method_43473();
				}

				@Override
				public @NotNull class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
					return new EquipmentScreenHandler(syncId, playerInventory, GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get(player).getInventory());
				}
			};

			player.method_17355(factory);
		}
	}
}
