/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.common.item;

import com.macuguita.backpacks.GBConfig;
import com.macuguita.backpacks.client.gui.BackpackScreenHandler;
import com.macuguita.backpacks.client.gui.payload.BackpackInventoryPayload;
import com.macuguita.backpacks.common.block.entity.BackpackBlockEntity;
import com.macuguita.backpacks.common.components.BackpacksComponent;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.reg.GBComponents;
import com.macuguita.backpacks.common.utils.BackpackUtils;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_638;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends class_1747 {
    public BackpackItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    private static void toggleVisibility(@NotNull class_1799 stack) {
        Boolean visible = (Boolean)stack.method_58694((class_9331)GBComponents.VISIBLE.get());
        boolean newValue = visible == null || visible == false;
        stack.method_57379((class_9331)GBComponents.VISIBLE.get(), (Object)newValue);
    }

    public static void openOrCreateBackpackIfNotExists(class_1657 player, int slotIndex) {
        BackpacksComponent backpacksComponent;
        class_1277 inventory;
        class_1799 backpack = EquipmentUtils.getBackpackFromSlotIndex(player, slotIndex);
        if (backpack.method_7960()) {
            return;
        }
        UUID uuid = (UUID)backpack.method_58694((class_9331)GBComponents.BACKPACK_UUID.get());
        if (uuid == null && player.method_73183() instanceof class_3218) {
            if (!backpack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
                backpack.method_57379((class_9331)GBComponents.BACKPACK_UUID.get(), (Object)UUID.randomUUID());
            }
            uuid = (UUID)backpack.method_58694((class_9331)GBComponents.BACKPACK_UUID.get());
        }
        if ((inventory = (backpacksComponent = (BackpacksComponent)GuitaBackpacksComponents.BACKPACKS_COMPONENT.get((Object)player.method_73183().method_8428())).getInventory(uuid)) == null) {
            backpacksComponent.addInventory(uuid);
            inventory = backpacksComponent.getInventory(uuid);
        }
        BackpackItem.openBackpack(player, inventory, slotIndex);
    }

    public static void openBackpack(@NotNull class_1657 player, final class_1277 inventory, final int slotIndex) {
        ExtendedScreenHandlerFactory factory = new ExtendedScreenHandlerFactory(){

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return new BackpackScreenHandler(syncId, playerInventory, (class_1263)inventory, slotIndex);
            }

            @Contract(value=" -> new", pure=true)
            @NotNull
            public class_2561 method_5476() {
                return class_2561.method_43471((String)"gui.gbackpacks.backpack");
            }

            @Contract(value="_ -> new")
            @NotNull
            public Object getScreenOpeningData(class_3222 player) {
                return new BackpackInventoryPayload(inventory.method_5439(), slotIndex);
            }
        };
        player.method_17355((class_3908)factory);
    }

    public void method_7888(class_1799 stack, class_3218 level, class_1297 entity, @Nullable class_1304 slot) {
        super.method_7888(stack, level, entity, slot);
        if (level instanceof class_3218) {
            if (!stack.method_7960() && !stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
                stack.method_57379((class_9331)GBComponents.BACKPACK_UUID.get(), (Object)UUID.randomUUID());
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                BackpackUtils.checkForDuplicateBackpacks(player, (UUID)stack.method_58694((class_9331)GBComponents.BACKPACK_UUID.get()), stack);
            }
        }
    }

    @NotNull
    public class_1269 method_7836(class_1937 level, @NotNull class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
            if (level instanceof class_3218) {
                int slotIndex = user.method_31548().method_7395(stack);
                if (slotIndex != -1) {
                    BackpackItem.openOrCreateBackpackIfNotExists(user, slotIndex);
                }
            } else if (level instanceof class_638) {
                class_638 clientLevel = (class_638)level;
                class_243 pos = user.method_73189();
                clientLevel.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_34376, class_3419.field_15248, 1.0f, 1.0f, false);
            }
        } else {
            return class_1269.field_5814;
        }
        return super.method_7836(level, user, hand);
    }

    protected boolean method_7710(class_2338 pos, @NotNull class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpack = (BackpackBlockEntity)be;
            if (stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
                backpack.setUuid((UUID)stack.method_58694((class_9331)GBComponents.BACKPACK_UUID.get()));
            }
            if (stack.method_57826((class_9331)GBComponents.BACKPACK_MODEL_ID.get())) {
                class_2960 modelId = (class_2960)stack.method_58694((class_9331)GBComponents.BACKPACK_MODEL_ID.get());
                if (modelId == null) {
                    return super.method_7710(pos, level, player, stack, state);
                }
                backpack.setItemModelId(modelId);
                String namespace = modelId.method_12836();
                String path = modelId.method_12832();
                path = path.replaceFirst("^backpacks/", "backpacks/blocks/");
                class_2960 newModelId = class_2960.method_60655((String)namespace, (String)path);
                backpack.setBlockModelId(newModelId);
            }
        }
        return super.method_7710(pos, level, player, stack, state);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            BackpackItem.toggleVisibility(stack);
            return true;
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public void method_33261(class_1542 entity) {
        super.method_33261(entity);
        class_1799 stack = entity.method_6983();
        if (stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
            UUID uuid = (UUID)stack.method_58694((class_9331)GBComponents.BACKPACK_UUID.get());
            if (Boolean.TRUE.equals(GBConfig.getBackpackDropItemsOnDestroyed())) {
                class_1277 inv = ((BackpacksComponent)GuitaBackpacksComponents.BACKPACKS_COMPONENT.get((Object)entity.method_73183().method_8428())).getInventory(uuid);
                class_5328.method_33263((class_1542)entity, (Iterable)inv.field_5828);
            }
            if (Boolean.TRUE.equals(GBConfig.getBackpackEntriesGetRemoved())) {
                ((BackpacksComponent)GuitaBackpacksComponents.BACKPACKS_COMPONENT.get((Object)entity.method_73183().method_8428())).removeBackpack(uuid);
            }
        }
    }
}

