/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

public class GBConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("gbackpacks.json");
    private static Configuration CONFIG = null;

    public static Integer getDefaultBackpackSize() {
        return CONFIG != null ? Integer.valueOf(GBConfig.CONFIG.defaultBackpackSize) : null;
    }

    public static Boolean getBackpackEntriesGetRemoved() {
        return CONFIG != null ? Boolean.valueOf(GBConfig.CONFIG.backpackEntriesGetRemoved) : null;
    }

    public static Boolean getBackpackDropItemsOnDestroyed() {
        return CONFIG != null ? Boolean.valueOf(GBConfig.CONFIG.backpackDropItemsOnDestroyed) : null;
    }

    public static Boolean getBackpackDropsOnDeath() {
        return CONFIG != null ? Boolean.valueOf(GBConfig.CONFIG.backpackDropsOnDeath) : null;
    }

    public static void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                GBConfig.createDefaultConfig();
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                JsonObject json = class_3518.method_15255((Reader)reader);
                DataResult result = Configuration.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (result.error().isPresent()) {
                    GuitaBackpacks.LOGGER.warn("Config file is invalid or missing fields: {}", (Object)((DataResult.Error)result.error().get()).message());
                    GuitaBackpacks.LOGGER.warn("Regenerating config...");
                    GBConfig.createDefaultConfig();
                    try (BufferedReader newReader = Files.newBufferedReader(CONFIG_PATH);){
                        json = class_3518.method_15255((Reader)newReader);
                        result = Configuration.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    }
                }
                CONFIG = result.resultOrPartial(msg -> GuitaBackpacks.LOGGER.error("Config parse error after regeneration: {}", msg)).orElse(null);
            }
        }
        catch (Exception e) {
            GuitaBackpacks.LOGGER.error("Failed to load config:");
            e.printStackTrace();
        }
    }

    private static void createDefaultConfig() throws IOException {
        Configuration defaultConfig = new Configuration(27, true, true, true);
        DataResult result = Configuration.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)defaultConfig);
        JsonElement jsonElement = (JsonElement)result.getOrThrow();
        if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        GBConfig.writePrettyJson(jsonElement, CONFIG_PATH);
        GuitaBackpacks.LOGGER.info("Created default config: {}", (Object)CONFIG_PATH);
    }

    private static void writePrettyJson(JsonElement element, Path path) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            gson.toJson(element, (Appendable)writer);
        }
    }

    public record Configuration(int defaultBackpackSize, boolean backpackEntriesGetRemoved, boolean backpackDropItemsOnDestroyed, boolean backpackDropsOnDeath) {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("default_backpack_size").flatXmap(size -> size > 0 && size <= 247 ? DataResult.success((Object)size) : DataResult.error(() -> "default_backpack_size must be between 1 and 247, got " + size), DataResult::success).forGetter(Configuration::defaultBackpackSize), (App)Codec.BOOL.fieldOf("backpack_entries_get_removed").forGetter(Configuration::backpackEntriesGetRemoved), (App)Codec.BOOL.fieldOf("backpack_drop_items_on_destroyed").forGetter(Configuration::backpackDropItemsOnDestroyed), (App)Codec.BOOL.fieldOf("backpack_drops_on_death").forGetter(Configuration::backpackDropsOnDeath)).apply((Applicative)instance, Configuration::new));
    }
}

