/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.client.gui.BackpackScreenHandler;
import com.macuguita.backpacks.client.gui.widgets.CustomizationWidget;
import com.macuguita.backpacks.client.gui.widgets.ScrollBarWidget;
import com.macuguita.backpacks.common.GuitaBackpacks;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class BackpackScreen
extends class_465<BackpackScreenHandler> {
    private static final class_2960 BACKGROUND_TEXTURE = GuitaBackpacks.id("background");
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60656((String)"container/slot");
    private static final class_2960 SCROLL_ADDON_TEXTURE = GuitaBackpacks.id("scroll_addon");
    private static final class_2960 INVENTORY_AND_HOTBAR_TEXTURE = GuitaBackpacks.id("inventory/inventory_and_hotbar");
    private static final class_2960 SLOTS_ROW1_TEXTURE = GuitaBackpacks.id("inventory/slots_row1");
    private static final class_2960 SLOTS_ROW2_TEXTURE = GuitaBackpacks.id("inventory/slots_row2");
    private static final class_2960 SLOTS_ROW3_TEXTURE = GuitaBackpacks.id("inventory/slots_row3");
    private static final class_2960 SLOTS_ROW4_TEXTURE = GuitaBackpacks.id("inventory/slots_row4");
    private static final class_2960 SLOTS_ROW5_TEXTURE = GuitaBackpacks.id("inventory/slots_row5");
    private static final class_2960 SLOTS_ROW6_TEXTURE = GuitaBackpacks.id("inventory/slots_row6");
    private static final class_2960[] SLOTS_ROW = new class_2960[]{SLOTS_ROW1_TEXTURE, SLOTS_ROW2_TEXTURE, SLOTS_ROW3_TEXTURE, SLOTS_ROW4_TEXTURE, SLOTS_ROW5_TEXTURE, SLOTS_ROW6_TEXTURE};
    private static final int VISIBLE_ROWS = 6;
    private static final int SLOT_SIZE = 18;
    private static final int SIDE_PADDING = 7;
    private static final int TOP_PADDING = 14;
    private static final int BOTTOM_PADDING = 7;
    private static final int GAP_BETWEEN_BACKPACK_AND_PLAYER = 13;
    private final int backpackSize;
    private final int visibleBackpackRows;
    private final int backpackStartY;
    private final int playerInventoryStartY;
    private ScrollBarWidget scrollBar;

    public BackpackScreen(BackpackScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.backpackSize = handler.inventory.method_5439();
        int totalRows = handler.getTotalRows();
        this.visibleBackpackRows = Math.min(totalRows, 6);
        this.backpackStartY = handler.getBackpackStartY();
        this.playerInventoryStartY = handler.getPlayerInventoryStartY();
        this.field_2792 = 176;
        this.field_2779 = 14 + this.visibleBackpackRows * 18 + 13 + 54 + 4 + 18 + 7;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        int backpackTitleY = 3;
        context.method_51439(this.field_22793, this.field_22785, 7, backpackTitleY, -12566464, false);
        Objects.requireNonNull(this.field_22793);
        int playerTitleY = this.backpackStartY + this.visibleBackpackRows * 18 + 6 - 9 / 2;
        context.method_51439(this.field_22793, this.field_29347, 7, playerTitleY, -12566464, false);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int backpackRows = Math.min(((BackpackScreenHandler)this.field_2797).getTotalRows(), 6);
        context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, guiX, guiY - 2, this.field_2792, this.field_2779 + 2);
        if (((BackpackScreenHandler)this.field_2797).needsScrolling()) {
            int scrollAddonX = guiX + 7 + 162 + 4;
            int scrollAddonY = guiY + this.backpackStartY - 4;
            context.method_52706(class_10799.field_56883, SCROLL_ADDON_TEXTURE, scrollAddonX, scrollAddonY, 19, backpackRows * 18 + 8);
        }
        int scrollOffset = ((BackpackScreenHandler)this.field_2797).getScrollOffset();
        int visibleSlots = Math.min(this.backpackSize - scrollOffset * 9, backpackRows * 9);
        int fullRows = visibleSlots / 9;
        int leftoverSlots = visibleSlots % 9;
        int rowX = guiX + 7 - 1;
        int rowY = guiY + this.backpackStartY - 1;
        if (fullRows > 0) {
            int rowTextureIndex = Math.min(fullRows - 1, SLOTS_ROW.length - 1);
            int rowsInTexture = rowTextureIndex + 1;
            context.method_52706(class_10799.field_56883, SLOTS_ROW[rowTextureIndex], rowX, rowY, 162, rowsInTexture * 18);
            rowY += rowsInTexture * 18;
        }
        for (int col = 0; col < leftoverSlots; ++col) {
            int slotX = rowX + col * 18;
            context.method_52706(class_10799.field_56883, SLOT_TEXTURE, slotX, rowY, 18, 18);
        }
        int inventoryX = guiX + 7 - 1;
        int inventoryY = guiY + this.playerInventoryStartY - 1;
        context.method_52706(class_10799.field_56883, INVENTORY_AND_HOTBAR_TEXTURE, inventoryX, inventoryY, 162, 76);
    }

    protected void method_25426() {
        super.method_25426();
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int widgetX = guiX + this.field_2792 - 18;
        int widgetY = guiY + 2;
        CustomizationWidget customizationWidget = new CustomizationWidget(widgetX, widgetY, 10, 10, null, (class_437)this, ((BackpackScreenHandler)this.field_2797).backpack);
        if (!((BackpackScreenHandler)this.field_2797).backpack.method_7960()) {
            this.method_37063((class_364)customizationWidget);
        }
        if (((BackpackScreenHandler)this.field_2797).needsScrolling()) {
            int scrollBarX = guiX + 7 + 162 + 5;
            int scrollBarY = guiY + this.backpackStartY;
            this.scrollBar = new ScrollBarWidget(scrollBarX, scrollBarY, this.visibleBackpackRows * 18 - 2, new ScrollBarWidget.ScrollCallback(){

                @Override
                public void onScroll(int delta) {
                    ((BackpackScreenHandler)BackpackScreen.this.field_2797).scroll(delta);
                    BackpackScreen.this.scrollBar.updateScrollPercent();
                }

                @Override
                public void scrollTo(int offset) {
                    int current = ((BackpackScreenHandler)BackpackScreen.this.field_2797).getScrollOffset();
                    ((BackpackScreenHandler)BackpackScreen.this.field_2797).scroll(offset - current);
                    BackpackScreen.this.scrollBar.updateScrollPercent();
                }

                @Override
                public int getMaxScrollOffset() {
                    return ((BackpackScreenHandler)BackpackScreen.this.field_2797).getTotalRows() - 6;
                }

                @Override
                public int getCurrentScrollOffset() {
                    return ((BackpackScreenHandler)BackpackScreen.this.field_2797).getScrollOffset();
                }

                @Override
                public boolean canScroll() {
                    return ((BackpackScreenHandler)BackpackScreen.this.field_2797).needsScrolling();
                }
            });
            this.scrollBar.updateScrollPercent();
            this.method_37063((class_364)this.scrollBar);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (((BackpackScreenHandler)this.field_2797).needsScrolling()) {
            int scrollDirection = verticalAmount > 0.0 ? -1 : 1;
            ((BackpackScreenHandler)this.field_2797).scroll(scrollDirection);
            if (this.scrollBar != null) {
                this.scrollBar.updateScrollPercent();
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

