/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.common.components;

import com.macuguita.backpacks.GBConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_2371;
import net.minecraft.class_269;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;

public class BackpacksComponent
implements Component {
    private final Map<UUID, class_1277> backpacks = new HashMap<UUID, class_1277>();

    public BackpacksComponent(class_269 provider, @Nullable MinecraftServer server) {
    }

    public void removeBackpack(UUID uuid) {
        this.backpacks.remove(uuid);
    }

    public void addInventory(UUID uuid) {
        assert (GBConfig.getDefaultBackpackSize() != null);
        if (uuid == null) {
            return;
        }
        this.addInventory(uuid, GBConfig.getDefaultBackpackSize());
    }

    public void addInventory(UUID uuid, int size) {
        if (uuid == null) {
            return;
        }
        this.backpacks.put(uuid, new class_1277(size));
    }

    public class_1277 getInventory(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return this.backpacks.get(uuid);
    }

    public boolean growBackpack(UUID uuid, int newSize) {
        if (uuid == null) {
            return false;
        }
        class_1277 oldInventory = this.backpacks.get(uuid);
        if (oldInventory != null) {
            int oldSize = oldInventory.method_5439();
            if (newSize <= oldSize) {
                return false;
            }
            class_1277 newInventory = new class_1277(newSize);
            for (int i = 0; i < oldSize; ++i) {
                newInventory.method_5447(i, oldInventory.method_5438(i));
            }
            this.backpacks.put(uuid, newInventory);
            return true;
        }
        return false;
    }

    public void readData(class_11368 readView) {
        this.backpacks.clear();
        class_11368.class_11370 backpacksList = readView.method_71438("Backpacks");
        for (class_11368 backpackReadView : backpacksList) {
            Optional uuid = backpackReadView.method_71426("UUID", class_4844.field_40825);
            int size = backpackReadView.method_71424("Size", 0);
            class_1277 inventory = new class_1277(size);
            class_1262.method_5429((class_11368)backpackReadView, (class_2371)inventory.field_5828);
            this.backpacks.put(uuid.orElse(null), inventory);
        }
    }

    public void writeData(class_11372 writeView) {
        class_11372.class_11374 backpacksList = writeView.method_71476("Backpacks");
        for (Map.Entry<UUID, class_1277> entry : this.backpacks.entrySet()) {
            UUID uuid = entry.getKey();
            class_1277 inventory = entry.getValue();
            class_11372 backpackView = backpacksList.method_71480();
            backpackView.method_71468("UUID", class_4844.field_40825, (Object)uuid);
            backpackView.method_71465("Size", inventory.method_5439());
            class_1262.method_5426((class_11372)backpackView, (class_2371)inventory.field_5828);
        }
    }
}

