/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.client.gui.widgets.CustomizationWidget;
import com.macuguita.backpacks.client.gui.widgets.ScrollBarWidget;
import com.macuguita.backpacks.common.GuitaBackpacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_8012;
import org.jetbrains.annotations.NotNull;

@Environment(value = EnvType.CLIENT)
public class BackpackScreen extends class_465<BackpackScreenHandler> {

	private static final class_2960 BACKGROUND_TEXTURE = GuitaBackpacks.res("background");
	private static final class_2960 SLOT_TEXTURE = class_2960.method_60656("container/slot");
	private static final class_2960 SCROLL_ADDON_TEXTURE = GuitaBackpacks.res("scroll_addon");
	private static final class_2960 INVENTORY_AND_HOTBAR_TEXTURE = GuitaBackpacks.res("inventory/inventory_and_hotbar");

	private static final class_2960 SLOTS_ROW1_TEXTURE = GuitaBackpacks.res("inventory/slots_row1");
	private static final class_2960 SLOTS_ROW2_TEXTURE = GuitaBackpacks.res("inventory/slots_row2");
	private static final class_2960 SLOTS_ROW3_TEXTURE = GuitaBackpacks.res("inventory/slots_row3");
	private static final class_2960 SLOTS_ROW4_TEXTURE = GuitaBackpacks.res("inventory/slots_row4");
	private static final class_2960 SLOTS_ROW5_TEXTURE = GuitaBackpacks.res("inventory/slots_row5");
	private static final class_2960 SLOTS_ROW6_TEXTURE = GuitaBackpacks.res("inventory/slots_row6");
	private static final class_2960[] SLOTS_ROW = {
			SLOTS_ROW1_TEXTURE,
			SLOTS_ROW2_TEXTURE,
			SLOTS_ROW3_TEXTURE,
			SLOTS_ROW4_TEXTURE,
			SLOTS_ROW5_TEXTURE,
			SLOTS_ROW6_TEXTURE
	}; //doing this ugly thing to make less calls to draw()

	private static final int VISIBLE_ROWS = 6;
	private static final int SLOT_SIZE = 18;
	private static final int SIDE_PADDING = 7;
	private static final int TOP_PADDING = 14;
	private static final int BOTTOM_PADDING = 7;
	private static final int GAP_BETWEEN_BACKPACK_AND_PLAYER = 13;

	private final int backpackSize;
	private final int visibleBackpackRows;
	private final int backpackStartY;
	private final int playerInventoryStartY;
	private ScrollBarWidget scrollBar;

	public BackpackScreen(BackpackScreenHandler handler, class_1661 inventory, class_2561 title) {
		super(handler, inventory, title);
		this.backpackSize = handler.inventory.method_5439();

		int totalRows = handler.getTotalRows();
		this.visibleBackpackRows = Math.min(totalRows, VISIBLE_ROWS);

		this.backpackStartY = handler.getBackpackStartY();
		this.playerInventoryStartY = handler.getPlayerInventoryStartY();

		this.field_2792 = SIDE_PADDING + (9 * SLOT_SIZE) + SIDE_PADDING;
		this.field_2779 = TOP_PADDING +
				(visibleBackpackRows * SLOT_SIZE) +
				GAP_BETWEEN_BACKPACK_AND_PLAYER +
				(3 * SLOT_SIZE) + 4 + SLOT_SIZE + BOTTOM_PADDING;
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		method_25420(context, mouseX, mouseY, delta);
		super.method_25394(context, mouseX, mouseY, delta);
		method_2380(context, mouseX, mouseY);
	}

	@Override
	protected void method_2388(@NotNull class_332 context, int mouseX, int mouseY) {
		int backpackTitleY = 3;
		context.method_51439(this.field_22793, this.field_22785, SIDE_PADDING, backpackTitleY, class_8012.field_60347, false);

		int playerTitleY = backpackStartY + visibleBackpackRows * SLOT_SIZE + GAP_BETWEEN_BACKPACK_AND_PLAYER / 2 - (this.field_22793.field_2000 / 2);
		context.method_51439(this.field_22793, this.field_29347, SIDE_PADDING, playerTitleY, class_8012.field_60347, false);
	}

	@Override
	protected void method_2389(@NotNull class_332 context, float delta, int mouseX, int mouseY) {
		int guiX = (this.field_22789 - this.field_2792) / 2;
		int guiY = (this.field_22790 - this.field_2779) / 2;

		int backpackRows = Math.min(field_2797.getTotalRows(), VISIBLE_ROWS);

		context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, guiX, guiY - 2, this.field_2792, this.field_2779 + 2);

		if (field_2797.needsScrolling()) {
			int scrollAddonX = guiX + SIDE_PADDING + 9 * SLOT_SIZE + 4;
			int scrollAddonY = guiY + backpackStartY - 4;
			context.method_52706(class_10799.field_56883, SCROLL_ADDON_TEXTURE, scrollAddonX, scrollAddonY,
					ScrollBarWidget.BACKGROUND_WIDTH + 5, backpackRows * SLOT_SIZE + 8);
		}

		int scrollOffset = field_2797.getScrollOffset();

		int visibleSlots = Math.min(backpackSize - scrollOffset * 9, backpackRows * 9);

		int fullRows = visibleSlots / 9;
		int leftoverSlots = visibleSlots % 9;

		int rowX = guiX + SIDE_PADDING - 1;
		int rowY = guiY + backpackStartY - 1;

		if (fullRows > 0) {
			int rowTextureIndex = Math.min(fullRows - 1, SLOTS_ROW.length - 1);
			int rowsInTexture = rowTextureIndex + 1;

			context.method_52706(class_10799.field_56883, SLOTS_ROW[rowTextureIndex], rowX, rowY, 9 * SLOT_SIZE, rowsInTexture * SLOT_SIZE);

			rowY += rowsInTexture * SLOT_SIZE;
		}

		for (int col = 0; col < leftoverSlots; col++) {
			int slotX = rowX + col * SLOT_SIZE;
			context.method_52706(class_10799.field_56883, SLOT_TEXTURE, slotX, rowY, SLOT_SIZE, SLOT_SIZE);
		}

		int inventoryX = guiX + SIDE_PADDING - 1;
		int inventoryY = guiY + playerInventoryStartY - 1;
		context.method_52706(class_10799.field_56883, INVENTORY_AND_HOTBAR_TEXTURE, inventoryX, inventoryY, 162, 76);
	}

	@Override
	protected void method_25426() {
		super.method_25426();

		int guiX = (this.field_22789 - this.field_2792) / 2;
		int guiY = (this.field_22790 - this.field_2779) / 2;

		int widgetX = guiX + this.field_2792 - 18;
		int widgetY = guiY + 2;
		CustomizationWidget customizationWidget = new CustomizationWidget(widgetX, widgetY, 10, 10, null, this, field_2797.slotIndex);
		if (!field_2797.backpack.method_7960())
			this.method_37063(customizationWidget);

		if (field_2797.needsScrolling()) {
			int scrollBarX = guiX + SIDE_PADDING + (9 * SLOT_SIZE) + 5;
			int scrollBarY = guiY + backpackStartY;

			this.scrollBar = new ScrollBarWidget(scrollBarX, scrollBarY, visibleBackpackRows * SLOT_SIZE - 2, new ScrollBarWidget.ScrollCallback() {
				@Override
				public void onScroll(int delta) {
					field_2797.scroll(delta);
					scrollBar.updateScrollPercent();
				}

				@Override
				public void scrollTo(int offset) {
					int current = field_2797.getScrollOffset();
					field_2797.scroll(offset - current);
					scrollBar.updateScrollPercent();
				}

				@Override
				public int getMaxScrollOffset() {
					return field_2797.getTotalRows() - VISIBLE_ROWS;
				}

				@Override
				public int getCurrentScrollOffset() {
					return field_2797.getScrollOffset();
				}

				@Override
				public boolean canScroll() {
					return field_2797.needsScrolling();
				}
			});

			this.scrollBar.updateScrollPercent();
			this.method_37063(scrollBar);
		}
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (field_2797.needsScrolling()) {
			int scrollDirection = verticalAmount > 0 ? -1 : 1;
			field_2797.scroll(scrollDirection);
			if (scrollBar != null) scrollBar.updateScrollPercent();
			return true;
		}
		return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
	}
}
