/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui.slots;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BackpackSlot extends class_1735 {

	@Nullable
	private final class_6862<class_1792> backpackBlacklist;
	@Nullable
	private final Predicate<class_1799> insertPredicate;
	private final class_1799 backpack;

	public BackpackSlot(class_1263 inventory, int index, int x, int y, @Nullable Predicate<class_1799> insertPredicate) {
		this(inventory, index, x, y, null, null, insertPredicate);
	}

	public BackpackSlot(class_1263 inventory, int index, int x, int y, class_1799 backpack, @Nullable class_6862<class_1792> backpackBlacklist) {
		this(inventory, index, x, y, backpack, backpackBlacklist, null);
	}

	public BackpackSlot(class_1263 inventory, int index, int x, int y, class_1799 backpack, @Nullable class_6862<class_1792> backpackBlacklist, @Nullable Predicate<class_1799> insertPredicate) {
		super(inventory, index, x, y);
		this.backpack = backpack;
		this.backpackBlacklist = backpackBlacklist;
		this.insertPredicate = insertPredicate;
	}

	public BackpackSlot(class_1263 inventory, int index, int x, int y, class_1799 backpack) {
		this(inventory, index, x, y, backpack, null);
	}

	@Override
	public boolean method_7680(class_1799 stack) {
		if (backpackBlacklist != null && stack.method_31573(backpackBlacklist)) {
			return false;
		}

		if (insertPredicate != null && !insertPredicate.test(stack)) {
			return false;
		}

		return super.method_7680(stack);
	}

	@Override
	public boolean method_7674(class_1657 playerEntity) {
		if (backpack != null && !backpack.method_7960()) {
			class_1799 current = this.method_7677();
			if (class_1799.method_7984(current, backpack)) {
				return false;
			}
		}
		return super.method_7674(playerEntity);
	}
}
