/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import com.macuguita.backpacks.client.model.GBModelReloadListener;
import com.macuguita.backpacks.client.render.state.BackpackRenderState;
import com.macuguita.backpacks.common.reg.GBComponents;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_7833;

@Environment(EnvType.CLIENT)
public class BackpackFeatureRenderer<S extends class_10034, M extends class_572<S>> extends class_3887<S, M> {

	public BackpackFeatureRenderer(class_3883<S, M> context) {
		super(context);
	}

	@Override
	public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, S renderState, float yRot, float xRot) {

		@Nullable BackpackRenderState backpackRenderState = renderState.getData(BackpackRenderState.KEY);

		if (backpackRenderState == null)
			return;

		class_1799 chestStack = backpackRenderState.chest;
		if (chestStack.method_7909() == class_1802.field_8833)
			return;

		class_1799 backpack = backpackRenderState.backpack;
		if (backpack.method_7960()) return;

		if (!backpack.method_57826(GBComponents.VISIBLE.get()) || !backpack.method_57826(GBComponents.BACKPACK_MODEL_ID.get()))
			return;

		if (Boolean.FALSE.equals(backpack.method_58694(GBComponents.VISIBLE.get())))
			return;

		class_1087 model = GBModelReloadListener.INSTANCE.getModel(backpack.method_58694(GBComponents.BACKPACK_MODEL_ID.get()));

		if (model == null)
			return;

		poseStack.method_22903();

		var playerModel = this.method_17165();
		// Align with body
		playerModel.field_3391.method_22703(poseStack);

		// Fix model placement
		poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
		poseStack.method_22905(1.1F, -1.1F, -1.1F);
		poseStack.method_22904(0, -0.06, 0.125);

		poseStack.method_46416(-0.5F, -0.5F, -0.5F);

		// FIXME 1.21.9
		// Fabric had this in their example leaving this to remind me later of when it is fixed
		// https://github.com/FabricMC/fabric/blob/0.134.1%2B1.21.10/fabric-model-loading-api-v1/src/testmodClient/java/net/fabricmc/fabric/test/model/loading/BakedModelFeatureRenderer.java
		// FabricBlockModelRenderer.render(matrices.peek(), RenderLayerHelper.entityDelegate(vertexConsumers), model, 1, 1, 1, light, OverlayTexture.DEFAULT_UV, EmptyBlockRenderView.INSTANCE, BlockPos.ORIGIN, Blocks.AIR.getDefaultState());

		nodeCollector.method_73529(0).method_73484(
				poseStack,
				class_4722.method_24074(),
				model,
				1, 1, 1,
				packedLight,
				class_4608.field_21444,
				0
		);

		poseStack.method_22909();
	}
}
