/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.block.entity;

import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import com.macuguita.backpacks.common.reg.GBBlockEntities;

public class BackpackBlockEntity extends class_2586 {

	private class_2960 blockModelId;
	private class_2960 itemModelId;
	private UUID uuid;

	public BackpackBlockEntity(class_2338 pos, class_2680 state) {
		super(GBBlockEntities.BACKPACK, pos, state);
	}

	public class_2960 getBlockModelId() {
		return blockModelId;
	}

	public void setBlockModelId(class_2960 modelId) {
		this.blockModelId = modelId;
	}

	public class_2960 getItemModelId() {
		return itemModelId;
	}

	public void setItemModelId(class_2960 itemModelId) {
		this.itemModelId = itemModelId;
	}

	public UUID getUuid() {
		return uuid;
	}

	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}

	@Override
	protected void method_11007(class_11372 view) {
		super.method_11007(view);
		view.method_71468("UUID", class_4844.field_40825, this.uuid);
		view.method_71469("Model", this.blockModelId.toString());
		view.method_71469("ItemModel", this.itemModelId.toString());
	}

	@Override
	protected void method_11014(class_11368 view) {
		super.method_11014(view);
		this.uuid = view.method_71426("UUID", class_4844.field_40825).orElse(null);
		this.blockModelId = class_2960.method_60654(view.method_71428("Model", ""));
		this.itemModelId = class_2960.method_60654(view.method_71428("ItemModel", ""));
	}

	public class_2622 method_38235() {
		return class_2622.method_38585(this);
	}

	@Override
	public class_2487 method_16887(class_7225.class_7874 registryLookup) {
		return this.method_38244(registryLookup);
	}
}
